/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zigythebird.playeranimatorapi.data.PlayerParts;
import com.zigythebird.playeranimatorapi.modifier.CommonModifier;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;

public record PlayerAnimationData(UUID playerUUID, ResourceLocation animationID, PlayerParts parts, List<CommonModifier> modifiers, int fadeLength, int easeID, int priority, boolean firstPersonEnabled) {
    public static final Codec<UUID> UUID_CODEC = Codec.list((Codec)Codec.LONG).comapFlatMap(PlayerAnimationData::readUUID, PlayerAnimationData::writeUUID).stable();
    public static final Codec<ResourceLocation> RESOURCE_LOCATION_CODEC = Codec.STRING.comapFlatMap(ResourceLocation::read, PlayerAnimationData::resourceLocationToString).stable();
    public static final Codec<PlayerAnimationData> CODEC = RecordCodecBuilder.create(playerAnimationDataInstance -> playerAnimationDataInstance.group((App)UUID_CODEC.fieldOf("playerUUID").forGetter(PlayerAnimationData::playerUUID), (App)RESOURCE_LOCATION_CODEC.fieldOf("animationID").forGetter(PlayerAnimationData::animationID), (App)PlayerParts.CODEC.fieldOf("parts").forGetter(PlayerAnimationData::parts), (App)CommonModifier.LIST_CODEC.fieldOf("modifiers").forGetter(PlayerAnimationData::modifiers), (App)Codec.INT.fieldOf("fadeLength").forGetter(PlayerAnimationData::fadeLength), (App)Codec.INT.fieldOf("easeID").forGetter(PlayerAnimationData::easeID), (App)Codec.INT.fieldOf("priority").forGetter(PlayerAnimationData::priority), (App)Codec.BOOL.fieldOf("firstPersonEnabled").forGetter(PlayerAnimationData::firstPersonEnabled)).apply((Applicative)playerAnimationDataInstance, PlayerAnimationData::new));

    public static DataResult<UUID> readUUID(List<Long> input) {
        return DataResult.success((Object)new UUID(input.get(0), input.get(1)));
    }

    public static List<Long> writeUUID(UUID uuid) {
        ArrayList<Long> list = new ArrayList<Long>();
        list.add(uuid.getMostSignificantBits());
        list.add(uuid.getLeastSignificantBits());
        return list;
    }

    public static String resourceLocationToString(ResourceLocation location) {
        if (location == null) {
            return "null:null";
        }
        return location.toString();
    }
}

