/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.playeranims;

import com.zigythebird.playeranimatorapi.data.PlayerAnimationData;
import com.zigythebird.playeranimatorapi.playeranims.CustomModifierLayer;
import com.zigythebird.playeranimatorapi.playeranims.PlayerAnimations;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ConditionalAnimations {
    private static Map<String, Function<PlayerAnimationData, ResourceLocation>> perModConditions = new HashMap<String, Function<PlayerAnimationData, ResourceLocation>>();

    public static void addModConditions(String namespace, Function<PlayerAnimationData, ResourceLocation> function) {
        perModConditions.put(namespace, function);
    }

    public static ResourceLocation getAnimationForCurrentConditions(PlayerAnimationData data) {
        if (perModConditions.containsKey(data.animationID().getNamespace())) {
            return perModConditions.get(data.animationID().getNamespace()).apply(data);
        }
        AbstractClientPlayer player = (AbstractClientPlayer)Minecraft.getInstance().level.getPlayerByUUID(data.playerUUID());
        CustomModifierLayer animationContainer = (CustomModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)player).get(PlayerAnimations.animationLayerId);
        ResourceLocation currentAnim = animationContainer.currentAnim;
        ResourceLocation baseAnim = data.animationID();
        ResourceLocation runningAnim = data.animationID().withPath(data.animationID().getPath() + "_run");
        ResourceLocation crouchedAnim = data.animationID().withPath(data.animationID().getPath() + "_crouch");
        ResourceLocation crawlingAnim = data.animationID().withPath(data.animationID().getPath() + "_crawl");
        ResourceLocation swimmingAnim = data.animationID().withPath(data.animationID().getPath() + "_swim");
        Map animations = PlayerAnimationRegistry.getAnimations();
        if (player.isCrouching() && currentAnim != crawlingAnim && animations.containsKey(crouchedAnim)) {
            return crouchedAnim;
        }
        if (player.isVisuallyCrawling() && currentAnim != crawlingAnim && animations.containsKey(crawlingAnim)) {
            return crawlingAnim;
        }
        if (player.isVisuallySwimming() && currentAnim != swimmingAnim && animations.containsKey(swimmingAnim)) {
            return swimmingAnim;
        }
        if (player.isSprinting() && currentAnim != runningAnim && animations.containsKey(runningAnim)) {
            return runningAnim;
        }
        return baseAnim;
    }
}

