/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.registry;

import com.google.gson.JsonObject;
import com.zigythebird.playeranimatorapi.modifier.HeadPosBoundCamera;
import com.zigythebird.playeranimatorapi.modifier.HeadRotBoundCamera;
import com.zigythebird.playeranimatorapi.modifier.LengthModifier;
import com.zigythebird.playeranimatorapi.modifier.MirrorOnAltHandModifier;
import com.zigythebird.playeranimatorapi.playeranims.CustomModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.MirrorModifier;
import dev.kosmx.playerAnim.api.layered.modifier.SpeedModifier;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AnimModifierRegistry {
    private static final Map<ResourceLocation, BiFunction<CustomModifierLayer, JsonObject, AbstractModifier>> modifiers = new HashMap<ResourceLocation, BiFunction<CustomModifierLayer, JsonObject, AbstractModifier>>();

    public static void registerModifier(ResourceLocation ID, BiFunction<CustomModifierLayer, JsonObject, AbstractModifier> function) {
        modifiers.put(ID, function);
    }

    public static Map<ResourceLocation, BiFunction<CustomModifierLayer, JsonObject, AbstractModifier>> getModifiers() {
        return modifiers;
    }

    public static void register() {
        AnimModifierRegistry.registerModifier(new ResourceLocation("player-animator", "mirror"), (layer, json) -> new MirrorModifier());
        AnimModifierRegistry.registerModifier(new ResourceLocation("player-animator", "speed"), (layer, json) -> {
            try {
                return new SpeedModifier(json.get("speed").getAsFloat());
            }
            catch (IllegalArgumentException | NullPointerException | UnsupportedOperationException e) {
                return new SpeedModifier(1.0f);
            }
        });
        AnimModifierRegistry.registerModifier(new ResourceLocation("playeranimatorapi", "length"), (layer, json) -> {
            try {
                return new LengthModifier((CustomModifierLayer)((Object)layer), json.get("desiredLength").getAsFloat());
            }
            catch (IllegalArgumentException | NullPointerException | UnsupportedOperationException e) {
                return new LengthModifier((CustomModifierLayer)((Object)layer), -1.0f);
            }
        });
        AnimModifierRegistry.registerModifier(new ResourceLocation("playeranimatorapi", "mirroronalthand"), (layer, json) -> new MirrorOnAltHandModifier((CustomModifierLayer)((Object)layer)));
        AnimModifierRegistry.registerModifier(new ResourceLocation("playeranimatorapi", "headposboundcamera"), (layer, json) -> new HeadPosBoundCamera((CustomModifierLayer)((Object)layer)));
        AnimModifierRegistry.registerModifier(new ResourceLocation("playeranimatorapi", "headrotboundcamera"), (layer, json) -> new HeadRotBoundCamera((CustomModifierLayer)((Object)layer)));
    }
}

