/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.API;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.zigythebird.multiloaderutils.utils.NetworkManager;
import com.zigythebird.playeranimatorapi.ModInit;
import com.zigythebird.playeranimatorapi.data.PlayerAnimationData;
import com.zigythebird.playeranimatorapi.data.PlayerParts;
import com.zigythebird.playeranimatorapi.modifier.CommonModifier;
import com.zigythebird.playeranimatorapi.utils.CommonPlayerLookup;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerAnimAPI {
    public static final ResourceLocation playerAnimPacket = new ResourceLocation("playeranimatorapi", "player_anim");
    public static final ResourceLocation playerAnimStopPacket = new ResourceLocation("playeranimatorapi", "player_anim_stop");
    public static final ResourceLocation MIRROR_ON_ALT_HAND = new ResourceLocation("playeranimatorapi", "mirroronalthand");
    public static final List<CommonModifier> gameplayModifiers = new ArrayList<CommonModifier>(){
        {
            this.add(new CommonModifier(MIRROR_ON_ALT_HAND, null));
        }
    };
    private static final Logger logger = LogManager.getLogger(ModInit.class);
    public static Gson gson = new GsonBuilder().setLenient().serializeNulls().create();

    public static void playPlayerAnim(ServerLevel level, Player player, ResourceLocation animationID) {
        PlayerAnimAPI.playPlayerAnim(level, player, animationID, PlayerParts.allEnabled, null, -1, -1, 1000, false);
    }

    public static void playPlayerAnim(ServerLevel level, Player player, ResourceLocation animationID, PlayerParts parts, List<CommonModifier> modifiers, int priority) {
        PlayerAnimAPI.playPlayerAnim(level, player, animationID, parts, modifiers, -1, -1, priority, false);
    }

    public static void playPlayerAnim(ServerLevel level, Player player, PlayerAnimationData data) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeUtf(gson.toJson((JsonElement)PlayerAnimationData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data).getOrThrow(true, arg_0 -> ((Logger)logger).warn(arg_0))));
        NetworkManager.sendToPlayers(CommonPlayerLookup.tracking(level, player.chunkPosition()), (ResourceLocation)playerAnimPacket, (FriendlyByteBuf)buf);
    }

    public static void playPlayerAnim(ServerLevel level, Player player, ResourceLocation animationID, PlayerParts parts, List<CommonModifier> modifiers, int fadeLength, int easeID, int priority, boolean firstPersonEnabled) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        PlayerAnimationData data = new PlayerAnimationData(player.getUUID(), animationID, parts, modifiers, fadeLength, easeID, priority, firstPersonEnabled);
        buf.writeUtf(gson.toJson((JsonElement)PlayerAnimationData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data).getOrThrow(true, arg_0 -> ((Logger)logger).warn(arg_0))));
        NetworkManager.sendToPlayers(CommonPlayerLookup.tracking(level, player.chunkPosition()), (ResourceLocation)playerAnimPacket, (FriendlyByteBuf)buf);
    }

    public static void stopPlayerAnim(ServerLevel level, Player player, ResourceLocation animationID) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeUUID(player.getUUID());
        buf.writeResourceLocation(animationID);
        NetworkManager.sendToPlayers(CommonPlayerLookup.tracking(level, player.chunkPosition()), (ResourceLocation)playerAnimStopPacket, (FriendlyByteBuf)buf);
    }
}

