/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.modifier;

import com.zigythebird.playeranimatorapi.modifier.AbstractCameraModifier;
import com.zigythebird.playeranimatorapi.playeranims.CustomModifierLayer;
import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.core.util.Vec3f;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import org.jetbrains.annotations.NotNull;

public class HeadRotBoundCamera
extends AbstractCameraModifier {
    private final CustomModifierLayer layer;

    public HeadRotBoundCamera(CustomModifierLayer layer) {
        this.layer = layer;
    }

    @Override
    @NotNull
    public Vec3f get3DCameraTransform(GameRenderer renderer, Camera camera, TransformType type, float tickDelta, @NotNull Vec3f value0) {
        LocalPlayer player = Minecraft.getInstance().player;
        float f = player.yBodyRot;
        float g = player.yHeadRot;
        float netHeadYaw = g - f;
        if (player.isPassenger() && player.getVehicle() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)player.getVehicle();
            f = player.yBodyRot;
            netHeadYaw = g - f;
            float i = Mth.wrapDegrees((float)netHeadYaw);
            if (i < -85.0f) {
                i = -85.0f;
            }
            if (i >= 85.0f) {
                i = 85.0f;
            }
            f = g - i;
            if (i * i > 2500.0f) {
                f += i * 0.2f;
            }
            netHeadYaw = g - f;
        }
        float headPitch = player.getXRot();
        if (HeadRotBoundCamera.isEntityUpsideDown((LivingEntity)player)) {
            headPitch *= -1.0f;
            netHeadYaw *= -1.0f;
        }
        if (type == TransformType.ROTATION && Minecraft.getInstance().options.getCameraType() == CameraType.FIRST_PERSON) {
            value0 = this.layer.get3DTransform("head", TransformType.ROTATION, tickDelta, value0).add(new Vec3f(0.0f, Mth.wrapDegrees((float)(player.getYRot() - netHeadYaw)) * ((float)Math.PI / 180), 0.0f));
        }
        return value0;
    }

    public static boolean isEntityUpsideDown(LivingEntity entity) {
        String string;
        if ((entity instanceof Player || entity.hasCustomName()) && ("Dinnerbone".equals(string = ChatFormatting.stripFormatting((String)entity.getName().getString())) || "Grumm".equals(string))) {
            return !(entity instanceof Player) || ((Player)entity).isModelPartShown(PlayerModelPart.CAPE);
        }
        return false;
    }
}

