/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.azure;

import com.zigythebird.playeranimatorapi.azure.ModAzureUtilsClient;
import com.zigythebird.playeranimatorapi.playeranims.CustomModifierLayer;
import com.zigythebird.playeranimatorapi.playeranims.PlayerAnimations;
import com.zigythebird.playeranimatorapi.registry.AzureControllerRegistry;
import mod.azure.azurelib.common.internal.client.util.RenderUtils;
import mod.azure.azurelib.common.internal.common.core.animatable.GeoAnimatable;
import mod.azure.azurelib.common.internal.common.core.animatable.instance.AnimatableInstanceCache;
import mod.azure.azurelib.common.internal.common.core.animation.AnimatableManager;
import mod.azure.azurelib.common.internal.common.core.animation.AnimationController;
import mod.azure.azurelib.common.internal.common.core.object.PlayState;
import mod.azure.azurelib.common.internal.common.network.AbstractPacket;
import mod.azure.azurelib.common.internal.common.network.SerializableDataTicket;
import mod.azure.azurelib.common.internal.common.network.packet.EntityAnimDataSyncPacket;
import mod.azure.azurelib.common.internal.common.network.packet.EntityAnimTriggerPacket;
import mod.azure.azurelib.common.internal.common.util.AzureLibUtil;
import mod.azure.azurelib.common.platform.Services;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class AnimatablePlayerLayer
implements GeoAnimatable {
    private final AbstractClientPlayer player;
    private final AnimatableInstanceCache cache = AzureLibUtil.createInstanceCache((GeoAnimatable)this);

    public AnimatablePlayerLayer(AbstractClientPlayer player) {
        this.player = player;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        CustomModifierLayer layer = PlayerAnimations.getModifierLayer(this.player);
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "playeranimatorapi", state -> PlayState.CONTINUE).setOverrideEasingTypeFunction(azurePlayer -> ModAzureUtilsClient.getEasingTypeForID((Player)this.player))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "playeranimatorapi", AzureControllerRegistry.getControllerForMod(0, layer))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "playeranimatorapi", AzureControllerRegistry.getControllerForMod(1, layer))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "playeranimatorapi", AzureControllerRegistry.getControllerForMod(2, layer))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "playeranimatorapi", AzureControllerRegistry.getControllerForMod(3, layer))});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "playeranimatorapi", AzureControllerRegistry.getControllerForMod(4, layer))});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    public <D> D getAnimData(SerializableDataTicket<D> dataTicket) {
        return (D)this.getAnimatableInstanceCache().getManagerForId((long)this.player.getId()).getData(dataTicket);
    }

    public <D> void setAnimData(SerializableDataTicket<D> dataTicket, D data) {
        AbstractClientPlayer entity = this.player;
        if (entity.level().isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId((long)entity.getId()).setData(dataTicket, data);
        } else {
            EntityAnimDataSyncPacket entityAnimDataSyncPacket = new EntityAnimDataSyncPacket(entity.getId(), dataTicket, data);
            Services.NETWORK.sendToTrackingEntityAndSelf((AbstractPacket)entityAnimDataSyncPacket, (Entity)entity);
        }
    }

    public void triggerAnim(@Nullable String controllerName, String animName) {
        AbstractClientPlayer entity = this.player;
        if (entity.level().isClientSide()) {
            this.getAnimatableInstanceCache().getManagerForId((long)entity.getId()).tryTriggerAnimation(controllerName, animName);
        } else {
            EntityAnimTriggerPacket entityAnimTriggerPacket = new EntityAnimTriggerPacket(entity.getId(), controllerName, animName);
            Services.NETWORK.sendToTrackingEntityAndSelf((AbstractPacket)entityAnimTriggerPacket, (Entity)entity);
        }
    }

    public double getTick(Object object) {
        return RenderUtils.getCurrentTick();
    }

    public AbstractClientPlayer getPlayer() {
        return this.player;
    }
}

