/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.compatibility.fabric;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.replaymod.recording.ReplayModRecording;
import com.zigythebird.playeranimatorapi.API.PlayerAnimAPI;
import com.zigythebird.playeranimatorapi.ModInit;
import com.zigythebird.playeranimatorapi.data.PlayerAnimationData;
import com.zigythebird.playeranimatorapi.data.PlayerParts;
import com.zigythebird.playeranimatorapi.fabric.PlayerAnimatorAPIClientFabric;
import com.zigythebird.playeranimatorapi.modifier.CommonModifier;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class ReplayModCompatImpl {
    public static void playPlayerAnim(AbstractClientPlayer player, ResourceLocation animationID, PlayerParts parts, List<CommonModifier> modifiers, int fadeLength, int easeID, int priority, boolean firstPersonEnabled, boolean replaceTick) {
        if (ReplayModRecording.instance.getConnectionEventHandler().getPacketListener() != null) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            PlayerAnimationData data = new PlayerAnimationData(player.getUUID(), animationID, parts, modifiers, fadeLength, easeID, priority, firstPersonEnabled);
            buf.writeUtf(PlayerAnimAPI.gson.toJson((JsonElement)PlayerAnimationData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)data).getOrThrow(true, arg_0 -> ((Logger)ModInit.LOGGER).warn(arg_0))));
            buf.writeBoolean(replaceTick);
            ReplayModRecording.instance.getConnectionEventHandler().getPacketListener().save(ServerPlayNetworking.createS2CPacket((ResourceLocation)PlayerAnimatorAPIClientFabric.altPlayPlayerAnimationPacket, (FriendlyByteBuf)buf));
        }
    }

    public static void stopPlayerAnim(AbstractClientPlayer player, ResourceLocation animationID) {
        if (ReplayModRecording.instance.getConnectionEventHandler().getPacketListener() != null) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeUUID(player.getUUID());
            buf.writeResourceLocation(animationID);
            ReplayModRecording.instance.getConnectionEventHandler().getPacketListener().save(ServerPlayNetworking.createS2CPacket((ResourceLocation)PlayerAnimatorAPIClientFabric.altStopPlayerAnimationPacket, (FriendlyByteBuf)buf));
        }
    }
}

