/*
 * Decompiled with CFR 0.152.
 */
package com.zigythebird.playeranimatorapi.fabric;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.zigythebird.playeranimatorapi.API.PlayerAnimAPI;
import com.zigythebird.playeranimatorapi.ModInit;
import com.zigythebird.playeranimatorapi.ModInitClient;
import com.zigythebird.playeranimatorapi.data.PlayerAnimationData;
import com.zigythebird.playeranimatorapi.playeranims.PlayerAnimations;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class PlayerAnimatorAPIClientFabric
implements ClientModInitializer {
    public static final ResourceLocation altPlayPlayerAnimationPacket = new ResourceLocation("playeranimatorapi", "alt_play_player_animation_packet");
    public static final ResourceLocation altStopPlayerAnimationPacket = new ResourceLocation("playeranimatorapi", "alt_stop_player_animation_packet");

    public void onInitializeClient() {
        ModInitClient.init();
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)altPlayPlayerAnimationPacket, (client, handler, buf, responseSender) -> {
            String jsonData = buf.readUtf();
            boolean replaceTick = buf.readBoolean();
            client.execute(() -> {
                try {
                    PlayerAnimationData data = (PlayerAnimationData)PlayerAnimationData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)PlayerAnimAPI.gson.fromJson(jsonData, JsonElement.class))).getOrThrow(true, arg_0 -> ((Logger)ModInit.LOGGER).warn(arg_0));
                    AbstractClientPlayer player2 = (AbstractClientPlayer)Minecraft.getInstance().level.getPlayerByUUID(data.playerUUID());
                    PlayerAnimations.playAnimation(player2, data, replaceTick);
                }
                catch (NullPointerException e) {
                    ModInit.LOGGER.error(e.getMessage());
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)altStopPlayerAnimationPacket, (client, handler, buf, responseSender) -> {
            UUID uuid = buf.readUUID();
            ResourceLocation resourceLocation = buf.readResourceLocation();
            client.execute(() -> {
                try {
                    PlayerAnimations.stopAnimation((AbstractClientPlayer)Minecraft.getInstance().level.getPlayerByUUID(uuid), resourceLocation);
                }
                catch (NullPointerException e) {
                    ModInit.LOGGER.error(e.getMessage());
                }
            });
        });
    }
}

