/*
 * Decompiled with CFR 0.152.
 */
package com.kasetoatz.noexplosiongrief.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_128;
import net.minecraft.class_148;

public class Config {
    public static boolean BLOCK_CREEPER = true;
    public static boolean BLOCK_GHAST = true;
    public static boolean BLOCK_WITHER = true;
    private static final Path FILE = FabricLoader.getInstance().getConfigDir().resolve("noexplosiongrief.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void load() {
        if (!Files.exists(FILE, new LinkOption[0])) {
            Config.save();
            return;
        }
        try {
            String json = Files.readString(FILE);
            JsonObject data = (JsonObject)GSON.fromJson(json, JsonObject.class);
            if (data.has("block-creeper")) {
                BLOCK_CREEPER = data.get("block-creeper").getAsBoolean();
            }
            if (data.has("block-ghast")) {
                BLOCK_GHAST = data.get("block-ghast").getAsBoolean();
            }
            if (data.has("block-wither")) {
                BLOCK_WITHER = data.get("block-wither").getAsBoolean();
            }
            Config.save();
        }
        catch (IOException exc) {
            throw new class_148(class_128.method_560((Throwable)exc, (String)"Loading config file."));
        }
    }

    public static void save() {
        try {
            JsonObject data = new JsonObject();
            data.addProperty("block-creeper", Boolean.valueOf(BLOCK_CREEPER));
            data.addProperty("block-ghast", Boolean.valueOf(BLOCK_GHAST));
            data.addProperty("block-wither", Boolean.valueOf(BLOCK_WITHER));
            Files.writeString(FILE, (CharSequence)GSON.toJson((JsonElement)data), new OpenOption[0]);
        }
        catch (IOException exc) {
            throw new class_148(class_128.method_560((Throwable)exc, (String)"Saving config file."));
        }
    }
}

