/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.particletweaks;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientChunkEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.lunade.particletweaks.impl.CaveDustSpawner;
import net.lunade.particletweaks.impl.FlowingFluidParticleUtil;
import net.lunade.particletweaks.impl.TorchParticleUtil;
import net.lunade.particletweaks.particle.CampfireFlareParticle;
import net.lunade.particletweaks.particle.CaveDustParticle;
import net.lunade.particletweaks.particle.ComfySmokeParticle;
import net.lunade.particletweaks.particle.FlareParticle;
import net.lunade.particletweaks.particle.FluidFlowParticle;
import net.lunade.particletweaks.particle.PoofParticle;
import net.lunade.particletweaks.particle.RippleParticle;
import net.lunade.particletweaks.particle.SmallBubbleParticle;
import net.lunade.particletweaks.particle.WaveParticle;
import net.lunade.particletweaks.particle.WaveSeedParticle;
import net.lunade.particletweaks.registry.ParticleTweaksParticleTypes;
import net.minecraft.class_2396;

@Environment(value=EnvType.CLIENT)
public class ParticleTweaksClient
implements ClientModInitializer {
    public static boolean areConfigsInit = false;

    public void onInitializeClient() {
        ClientChunkEvents.CHUNK_UNLOAD.register((clientLevel, levelChunk) -> {
            FlowingFluidParticleUtil.clearCascadesInChunk(levelChunk.method_12004());
            TorchParticleUtil.clearTorchesInChunk(levelChunk.method_12004());
        });
        ClientLifecycleEvents.CLIENT_STOPPING.register(clientLevel -> {
            FlowingFluidParticleUtil.clearCascades();
            TorchParticleUtil.clearTorches();
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            FlowingFluidParticleUtil.clearCascades();
            TorchParticleUtil.clearTorches();
        });
        ClientTickEvents.START_WORLD_TICK.register(clientLevel -> {
            FlowingFluidParticleUtil.tickCascades(clientLevel);
            TorchParticleUtil.tickTorches(clientLevel);
            CaveDustSpawner.tick(clientLevel);
        });
        ParticleTweaksParticleTypes.init();
        ParticleFactoryRegistry particleRegistry = ParticleFactoryRegistry.getInstance();
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.FLOWING_LAVA, FluidFlowParticle.LavaFactory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.FLOWING_WATER, FluidFlowParticle.WaterFactory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.SMALL_BUBBLE, SmallBubbleParticle.Factory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.SMALL_CASCADE, FluidFlowParticle.SmallCascadeFactory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.CASCADE_A, FluidFlowParticle.CascadeFactory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.CASCADE_B, FluidFlowParticle.CascadeFactory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.SPLASH, FluidFlowParticle.SplashFactory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.RIPPLE, RippleParticle.Factory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.WAVE_OUTLINE, WaveParticle.OutlineFactory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.WAVE, WaveParticle.Factory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.WAVE_SEED, WaveSeedParticle.Factory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.CAVE_DUST, CaveDustParticle.Factory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.POOF, PoofParticle.Factory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.FLARE, FlareParticle.Factory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.SOUL_FLARE, FlareParticle.SoulFactory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.CAMPFIRE_FLARE, CampfireFlareParticle.Factory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.SOUL_CAMPFIRE_FLARE, CampfireFlareParticle.SoulFactory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.COMFY_SMOKE_A, ComfySmokeParticle.Factory::new);
        particleRegistry.register((class_2396)ParticleTweaksParticleTypes.COMFY_SMOKE_B, ComfySmokeParticle.Factory::new);
    }
}

