/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.particletweaks.impl;

import java.util.ArrayList;
import net.lunade.particletweaks.config.ParticleTweaksConfig;
import net.lunade.particletweaks.registry.ParticleTweaksParticleTypes;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowingFluidParticleUtil {
    private static final ArrayList<class_2338> CASCADES = new ArrayList();

    public static boolean isUnderFluid(@NotNull class_1937 level, double x, double y, double z) {
        class_2338 blockPos = class_2338.method_49637((double)x, (double)y, (double)z);
        class_2680 blockState = level.method_8320(blockPos);
        class_3610 fluidState = blockState.method_26227();
        return !fluidState.method_15769() && (double)(fluidState.method_15763((class_1922)level, blockPos) + (float)blockPos.method_10264()) >= y;
    }

    @Nullable
    public static class_243 handleFluidInteraction(class_1937 level, class_243 pos, class_243 movement, class_703 particle, boolean safeInLavaOrFire, boolean slowsInFluid, boolean flowsWithFluid, double fluidMovementScale) {
        if (!safeInLavaOrFire || slowsInFluid || flowsWithFluid) {
            class_238 shape;
            boolean willBurn;
            boolean atRiskOfLava;
            class_2338 blockPos = class_2338.method_49638((class_2374)pos);
            class_2680 blockState = level.method_8320(blockPos);
            class_3610 fluidState = blockState.method_26227();
            boolean isFluidHighEnough = false;
            boolean bl = atRiskOfLava = !safeInLavaOrFire && fluidState.method_15767(class_3486.field_15518);
            if (slowsInFluid || flowsWithFluid || atRiskOfLava) {
                isFluidHighEnough = !fluidState.method_15769() && (double)(fluidState.method_15763((class_1922)level, blockPos) + (float)blockPos.method_10264()) >= pos.field_1351;
            }
            boolean bl2 = willBurn = atRiskOfLava && isFluidHighEnough;
            if (!safeInLavaOrFire && fluidState.method_15769() && blockState.method_26164(class_3481.field_21952) && (shape = blockState.method_26218((class_1922)level, blockPos).method_1107().method_996(blockPos)).method_1006(pos)) {
                willBurn = true;
            }
            if (willBurn) {
                level.method_8406((class_2394)class_2398.field_11251, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
                particle.method_3085();
                return null;
            }
            if (slowsInFluid && isFluidHighEnough) {
                movement = new class_243(movement.field_1352 * 0.8, movement.field_1351 * 0.1, movement.field_1350 * 0.8);
            }
            if (flowsWithFluid && isFluidHighEnough) {
                class_243 flow = fluidState.method_15758((class_1922)level, blockPos);
                movement = movement.method_1019(flow.method_1021(fluidMovementScale));
            }
        }
        return movement;
    }

    public static void onAnimateTick(class_1937 world, class_2338 pos, @NotNull class_3610 state, class_5819 random, int maxCount, int horizontalChance, int downChance, boolean horizontalParticles, boolean createCascades, class_2394 particle) {
        int count = maxCount == 1 ? 1 : random.method_43051(1, maxCount);
        boolean isSource = state.method_15771();
        class_243 rawFlow = state.method_15758((class_1922)world, pos);
        if (!(isSource && rawFlow.method_37267() == 0.0 || state.method_15769())) {
            class_243 flow2;
            class_243 flow1;
            ArrayList<class_2350> possibleFlowingDirections;
            class_243 flowVec = rawFlow.method_1029();
            float fluidHeight = state.method_15763((class_1922)world, pos);
            boolean isDown = (Boolean)state.method_11654((class_2769)class_3609.field_15902);
            if ((isDown || horizontalParticles) && random.method_43048(isDown ? downChance : horizontalChance) == 0 && ParticleTweaksConfig.TRAILER_FLOWING_FLUIDS) {
                if (!isDown) {
                    possibleFlowingDirections = new ArrayList<class_2350>();
                    flow1 = new class_243(flowVec.field_1352, 0.0, 0.0);
                    flow2 = new class_243(0.0, 0.0, flowVec.field_1350);
                    if (flow1.method_37267() > 0.0) {
                        possibleFlowingDirections.add(class_2350.method_58251((class_243)flow1));
                    }
                    if (flow2.method_37267() > 0.0) {
                        possibleFlowingDirections.add(class_2350.method_58251((class_243)flow2));
                    }
                    if (!possibleFlowingDirections.isEmpty()) {
                        for (int i = 0; i < count; ++i) {
                            FlowingFluidParticleUtil.spawnParticleFromDirection(world, pos, (class_2350)possibleFlowingDirections.get((int)(Math.random() * (double)possibleFlowingDirections.size())), 1, false, 0.0, 0.225, 0.3, fluidHeight, random, particle);
                        }
                    }
                } else {
                    for (class_2350 direction : class_2350.class_2353.field_11062) {
                        FlowingFluidParticleUtil.spawnParticleFromDirection(world, pos, direction, count, true, 0.0, 0.075, 0.1, fluidHeight, random, particle);
                    }
                }
            }
            if (!isSource && createCascades && ParticleTweaksConfig.TRAILER_CASCADES) {
                if (isDown) {
                    class_2338 immutablePos;
                    class_3610 belowFluidState = world.method_8316(pos.method_10074());
                    if (belowFluidState.method_15771() && !CASCADES.contains(immutablePos = pos.method_10062())) {
                        CASCADES.add(immutablePos);
                    }
                } else {
                    possibleFlowingDirections = new ArrayList();
                    flow1 = new class_243(flowVec.field_1352, 0.0, 0.0);
                    flow2 = new class_243(0.0, 0.0, flowVec.field_1350);
                    if (flow1.method_37267() > 0.0) {
                        possibleFlowingDirections.add(class_2350.method_58251((class_243)flow1));
                    }
                    if (flow2.method_37267() > 0.0) {
                        possibleFlowingDirections.add(class_2350.method_58251((class_243)flow2));
                    }
                    for (class_2350 direction : possibleFlowingDirections) {
                        class_2338 immutablePos;
                        class_3610 flowingEndFluidState;
                        class_2338 flowingToPos = pos.method_10093(direction);
                        class_2680 flowingToBlockState = world.method_8320(flowingToPos);
                        if (!flowingToBlockState.method_26220((class_1922)world, flowingToPos).method_1110() || !(flowingEndFluidState = world.method_8316(flowingToPos.method_10074())).method_15771() || CASCADES.contains(immutablePos = pos.method_10062())) continue;
                        CASCADES.add(immutablePos);
                    }
                }
            }
        }
    }

    private static void spawnParticleFromDirection(@NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2350 direction, int count, boolean isFalling, double yVelocity, double minVelocityScale, double maxVelocityScale, float fluidHeight, class_5819 random, class_2394 particle) {
        class_2338 otherPos = pos.method_10093(direction);
        class_2680 otherState = world.method_8320(otherPos);
        if (otherState.method_26220((class_1922)world, otherPos).method_1110() && (otherState.method_26227().method_15769() || !isFalling)) {
            class_243 directionOffset = class_243.method_24954((class_2382)direction.method_62675()).method_1021(0.5);
            class_243 offsetPos = pos.method_61082().method_1019(isFalling ? directionOffset : class_243.field_1353);
            for (int i = 0; i < count; ++i) {
                double yOffset = isFalling ? random.method_43058() * (double)fluidHeight : (double)fluidHeight;
                class_243 particleOffsetPos = offsetPos.method_1031(random.method_43385(0.0, 0.65) * (double)Math.abs(direction.method_10165()), yOffset, random.method_43385(0.0, 0.65) * (double)Math.abs(direction.method_10148()));
                class_243 velocity = directionOffset.method_1021(0.75).method_1021(random.method_43385((minVelocityScale + maxVelocityScale) * 0.5, maxVelocityScale - minVelocityScale));
                world.method_8406(particle, particleOffsetPos.field_1352, particleOffsetPos.field_1351, particleOffsetPos.field_1350, velocity.field_1352, yVelocity, velocity.field_1350);
            }
        }
    }

    public static void clearCascades() {
        CASCADES.clear();
    }

    public static void clearCascadesInChunk(class_1923 chunkPos) {
        CASCADES.removeIf(blockPos -> new class_1923(blockPos).equals((Object)chunkPos));
    }

    public static void tickCascades(class_638 world) {
        if (!ParticleTweaksConfig.TRAILER_CASCADES) {
            CASCADES.clear();
            return;
        }
        class_310 minecraft = class_310.method_1551();
        class_2338 cameraPos = minecraft.field_1773.method_19418().method_19328();
        CASCADES.removeIf(blockPos -> !FlowingFluidParticleUtil.onCascadeTick((class_1937)world, blockPos, world.method_8316(blockPos), world.field_9229, cameraPos));
    }

    public static boolean onCascadeTick(@NotNull class_1937 world, class_2338 pos, @NotNull class_3610 state, class_5819 random, class_2338 cameraPos) {
        if (!world.method_8477(pos)) {
            return false;
        }
        int camDifferenceX = Math.abs(cameraPos.method_10260() - pos.method_10260());
        int camDifferenceZ = Math.abs(cameraPos.method_10260() - pos.method_10260());
        if ((camDifferenceX > 16 || camDifferenceZ > 16) && random.method_43056()) {
            return true;
        }
        if (camDifferenceX > 32 || camDifferenceZ > 32) {
            return true;
        }
        if (!state.method_15771() && !state.method_15769()) {
            boolean isDown;
            int cascadeStrength = 1;
            float largeCascadeChance = 0.0f;
            class_243 rawFlow = state.method_15758((class_1922)world, pos);
            ArrayList<class_2350> validDirections = new ArrayList<class_2350>();
            class_243 flowVec = rawFlow.method_1029();
            boolean bl = isDown = state.method_28498((class_2769)class_3609.field_15902) && (Boolean)state.method_11654((class_2769)class_3609.field_15902) != false;
            if (isDown) {
                class_3610 aboveFluidState;
                for (class_2350 direction : class_2350.class_2353.field_11062) {
                    class_2338 belowOtherPos;
                    class_3610 belowOtherFluidState;
                    class_2338 otherPos = pos.method_10093(direction);
                    class_2680 otherBlockState = world.method_8320(otherPos);
                    class_3610 otherFluidState = otherBlockState.method_26227();
                    if (otherFluidState.method_39360(state.method_15772()) && otherFluidState.method_28498((class_2769)class_3609.field_15902) && ((Boolean)otherFluidState.method_11654((class_2769)class_3609.field_15902)).booleanValue()) {
                        ++cascadeStrength;
                        continue;
                    }
                    if (!otherFluidState.method_15769() || !otherBlockState.method_26220((class_1922)world, pos).method_1110() || !(belowOtherFluidState = world.method_8316(belowOtherPos = otherPos.method_10074())).method_15771()) continue;
                    validDirections.add(direction);
                }
                int fallingFromHeight = 1;
                int i = 1;
                while (i < 20 && (aboveFluidState = world.method_8316(pos.method_10086(i))).method_39360(state.method_15772()) && aboveFluidState.method_28498((class_2769)class_3609.field_15902) && ((Boolean)aboveFluidState.method_11654((class_2769)class_3609.field_15902)).booleanValue()) {
                    fallingFromHeight = i++;
                }
                largeCascadeChance = fallingFromHeight >= 10 ? 1.0f - (20.0f - (float)fallingFromHeight) / 10.0f : 0.0f;
                cascadeStrength += Math.min(fallingFromHeight, 1);
            } else {
                ArrayList<class_2350> possibleFlowingDirections = new ArrayList<class_2350>();
                class_243 flow1 = new class_243(flowVec.field_1352, 0.0, 0.0);
                class_243 flow2 = new class_243(0.0, 0.0, flowVec.field_1350);
                if (flow1.method_37267() > 0.0) {
                    possibleFlowingDirections.add(class_2350.method_58251((class_243)flow1));
                }
                if (flow2.method_37267() > 0.0) {
                    possibleFlowingDirections.add(class_2350.method_58251((class_243)flow2));
                }
                for (class_2350 direction : possibleFlowingDirections) {
                    class_3610 flowingEndFluidState;
                    class_2338 flowingToPos = pos.method_10093(direction);
                    class_2680 flowingToBlockState = world.method_8320(flowingToPos);
                    if (!flowingToBlockState.method_26220((class_1922)world, flowingToPos).method_1110() || !(flowingEndFluidState = world.method_8316(flowingToPos.method_10074())).method_15771()) continue;
                    validDirections.add(direction);
                }
            }
            if (!validDirections.isEmpty()) {
                for (class_2350 direction : validDirections) {
                    int firstStrength = (int)((double)cascadeStrength * 1.25);
                    int secondStrength = (int)((double)cascadeStrength * 1.5);
                    boolean largeCascade = random.method_43057() <= largeCascadeChance;
                    boolean isSmallWater = !largeCascade && random.method_43057() <= 0.05f;
                    FlowingFluidParticleUtil.spawnParticleFromDirection(world, pos, direction, random.method_43051(firstStrength, Math.max(firstStrength + 1, secondStrength)), true, largeCascade ? 0.2 : (isSmallWater ? 0.2 : 0.125), isSmallWater ? 0.2 : (largeCascade ? 0.1 : 0.05), isSmallWater ? 0.4 : (largeCascade ? 0.3 : 0.225), largeCascade ? 0.3f : 0.05f, random, (class_2394)(largeCascade ? (random.method_43056() ? ParticleTweaksParticleTypes.CASCADE_A : ParticleTweaksParticleTypes.CASCADE_B) : (isSmallWater ? ParticleTweaksParticleTypes.FLOWING_WATER : ParticleTweaksParticleTypes.SMALL_CASCADE)));
                }
                return true;
            }
        }
        return false;
    }
}

