/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.particletweaks.impl;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Map;
import net.lunade.particletweaks.config.ParticleTweaksConfig;
import net.lunade.particletweaks.registry.ParticleTweaksParticleTypes;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2527;
import net.minecraft.class_2555;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class TorchParticleUtil {
    private static final Map<class_2338, Integer> TORCH_TICKS = new Object2ObjectLinkedOpenHashMap();

    public static void onAnimateTick(@NotNull class_2338 pos) {
        class_2338 immutablePos = pos.method_10062();
        if (!TORCH_TICKS.containsKey(immutablePos)) {
            TORCH_TICKS.put(immutablePos, 0);
        }
    }

    public static void clearTorches() {
        TORCH_TICKS.clear();
    }

    public static void clearTorchesInChunk(class_1923 chunkPos) {
        ArrayList posesToRemove = new ArrayList();
        TORCH_TICKS.forEach((blockPos, integer) -> {
            if (new class_1923(blockPos).equals((Object)chunkPos)) {
                posesToRemove.add(blockPos);
            }
        });
        posesToRemove.forEach(TORCH_TICKS::remove);
    }

    public static void tickTorches(class_638 world) {
        if (!ParticleTweaksConfig.TRAILER_TORCHES) {
            TORCH_TICKS.clear();
            return;
        }
        class_310 minecraft = class_310.method_1551();
        class_2338 cameraPos = minecraft.field_1773.method_19418().method_19328();
        ArrayList posesToRemove = new ArrayList();
        TORCH_TICKS.forEach((blockPos, tickCount) -> {
            if (!TorchParticleUtil.onTorchTick((class_1937)world, blockPos, world.method_8320(blockPos), world.field_9229, tickCount, cameraPos)) {
                posesToRemove.add(blockPos);
            }
        });
        posesToRemove.forEach(TORCH_TICKS::remove);
        for (class_2338 pos : TORCH_TICKS.keySet()) {
            int tickCount2 = TORCH_TICKS.getOrDefault(pos, 0) + 1;
            TORCH_TICKS.put(pos, tickCount2);
        }
    }

    public static boolean onTorchTick(@NotNull class_1937 world, class_2338 pos, @NotNull class_2680 state, class_5819 random, int tickCount, class_2338 cameraPos) {
        if (!world.method_8477(pos)) {
            return false;
        }
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof class_2527)) {
            return false;
        }
        class_2527 torchBlock = (class_2527)class_22482;
        int camDifferenceX = Math.abs(cameraPos.method_10260() - pos.method_10260());
        int camDifferenceZ = Math.abs(cameraPos.method_10260() - pos.method_10260());
        if ((camDifferenceX > 16 || camDifferenceZ > 16) && random.method_43056()) {
            return true;
        }
        if (camDifferenceX > 32 || camDifferenceZ > 32) {
            return true;
        }
        boolean isSoulTorch = torchBlock.field_22155 == class_2398.field_22246;
        class_2400 flareParticle = isSoulTorch ? ParticleTweaksParticleTypes.SOUL_FLARE : ParticleTweaksParticleTypes.FLARE;
        double x = (double)pos.method_10263() + 0.5;
        double y = (double)pos.method_10264() + 0.6;
        double z = (double)pos.method_10260() + 0.5;
        if (state.method_26204() instanceof class_2555) {
            class_2350 direction = (class_2350)state.method_11654((class_2769)class_2555.field_11731);
            class_2350 opposite = direction.method_10153();
            x += 0.27 * (double)opposite.method_10148();
            y += 0.15;
            z += 0.27 * (double)opposite.method_10165();
        }
        if (tickCount % 5 == 0) {
            world.method_8406((class_2394)flareParticle, x, y - 0.05, z, 0.0, 0.0, 0.0);
        }
        if (tickCount % 8 == 0) {
            world.method_8406((class_2394)(tickCount % 16 == 0 ? ParticleTweaksParticleTypes.COMFY_SMOKE_B : ParticleTweaksParticleTypes.COMFY_SMOKE_A), x, y, z, 0.0, 0.0, 0.0);
        }
        return true;
    }
}

