/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.particletweaks.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.lunade.particletweaks.impl.ParticleTweakInterface;
import net.lunade.particletweaks.registry.ParticleTweaksParticleTypes;
import net.minecraft.class_1922;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3609;
import net.minecraft.class_3610;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class FluidFlowParticle
extends class_3940 {
    private static final int LAVA_COLOR = 16743195;
    private final class_4002 spriteSet;
    private boolean isLava;
    private boolean floatOnFluid;
    private boolean endWhenUnderFluid;
    private boolean spawnsRipples;
    private boolean hasSpawnedRipple;

    FluidFlowParticle(class_638 level, double x, double y, double z, double xd, double yd, double zd, class_4002 spriteSet) {
        super(level, x, y, z, xd, yd, zd, spriteSet.method_74304());
        this.field_3852 = xd;
        this.field_3869 = yd;
        this.field_3850 = zd;
        this.spriteSet = spriteSet;
        this.field_3844 = 0.9f;
    }

    public void method_3070() {
        boolean isFluidHighEnough;
        super.method_3070();
        this.method_74306(this.spriteSet);
        if (this.field_3845) {
            this.field_3866 = this.field_3847;
            return;
        }
        class_2338 blockPos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
        class_2680 blockState = this.field_3851.method_8320(blockPos);
        class_3610 fluidState = blockState.method_26227();
        float fluidHeight = fluidState.method_15763((class_1922)this.field_3851, blockPos);
        float worldFluidHeight = fluidHeight + (float)blockPos.method_10264();
        boolean bl = isFluidHighEnough = !fluidState.method_15769() && (double)worldFluidHeight >= this.field_3854;
        if (isFluidHighEnough) {
            if (fluidState.method_15758((class_1922)this.field_3851, blockPos).method_37267() == 0.0) {
                this.field_3866 = Math.clamp((long)(this.field_3866 + 3), 0, this.field_3847);
            }
            if (!(!this.floatOnFluid || fluidState.method_28498((class_2769)class_3609.field_15902) && ((Boolean)fluidState.method_11654((class_2769)class_3609.field_15902)).booleanValue())) {
                if (this.field_3869 < 0.01) {
                    this.field_3869 += 0.05;
                }
                this.field_3869 += (0.0 - this.field_3869) * 0.4;
                this.field_3854 += ((double)((float)blockPos.method_10264() + fluidHeight) - this.field_3854) * 0.5;
            }
            if (this.endWhenUnderFluid || this.spawnsRipples) {
                this.field_3866 = this.field_3847;
            }
            if (this.spawnsRipples && !this.hasSpawnedRipple && (double)worldFluidHeight < this.field_3838 && this.field_3851.method_8316(blockPos.method_10084()).method_15769()) {
                this.hasSpawnedRipple = true;
                this.field_3851.method_8406((class_2394)ParticleTweaksParticleTypes.RIPPLE, this.field_3874, (double)((float)blockPos.method_10264() + fluidHeight), this.field_3871, 0.0, 0.0, 0.0);
            }
        }
    }

    protected int method_3068(float tint) {
        return this.isLava ? 240 : super.method_3068(tint);
    }

    @NotNull
    protected class_3940.class_11941 method_74255() {
        return class_3940.class_11941.field_62641;
    }

    @Environment(value=EnvType.CLIENT)
    public record CascadeFactory(class_4002 spriteSet) implements class_707<class_2400>
    {
        @NotNull
        public class_703 createParticle(@NotNull class_2400 defaultParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            FluidFlowParticle cascadeParticle = new FluidFlowParticle(level, x, y, z, xd, yd, zd, this.spriteSet);
            cascadeParticle.field_62636 = 0.75f;
            cascadeParticle.endWhenUnderFluid = false;
            cascadeParticle.field_17867 *= 2.5f;
            if (cascadeParticle instanceof ParticleTweakInterface) {
                ParticleTweakInterface particleTweakInterface = (ParticleTweakInterface)((Object)cascadeParticle);
                particleTweakInterface.particleTweaks$setNewSystem(true);
                particleTweakInterface.particleTweaks$setMovesWithFluid(true);
                particleTweakInterface.particleTweaks$setCanBurn(true);
                particleTweakInterface.particleTweaks$setScalesToZero();
                particleTweakInterface.particleTweaks$setSwitchesExit(true);
                particleTweakInterface.particleTweaks$setFluidMovementScale(0.125);
                particleTweakInterface.particleTweaks$setScaler(0.5f);
                particleTweakInterface.particleTweaks$setMaxAlpha(0.75f);
            }
            return cascadeParticle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record SmallCascadeFactory(class_4002 spriteSet) implements class_707<class_2400>
    {
        @NotNull
        public class_703 createParticle(@NotNull class_2400 defaultParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            FluidFlowParticle smallCascadeParticle = new FluidFlowParticle(level, x, y, z, xd, yd, zd, this.spriteSet);
            int waterColor = ((class_1959)level.method_23753(class_2338.method_49637((double)x, (double)y, (double)z)).comp_349()).method_8687();
            smallCascadeParticle.field_62633 = Math.clamp((float)class_9848.method_61327((int)waterColor) / 255.0f * (float)random.method_43385(1.3, 0.3), 0.0f, 1.0f);
            smallCascadeParticle.field_62635 = Math.clamp((float)class_9848.method_61331((int)waterColor) / 255.0f * (float)random.method_43385(1.3, 0.3), 0.0f, 1.0f);
            smallCascadeParticle.field_62634 = Math.clamp((float)class_9848.method_61329((int)waterColor) / 255.0f * (float)random.method_43385(1.3, 0.3), 0.0f, 1.0f);
            smallCascadeParticle.field_62636 = 0.25f;
            smallCascadeParticle.endWhenUnderFluid = true;
            smallCascadeParticle.field_17867 *= 1.5f;
            if (smallCascadeParticle instanceof ParticleTweakInterface) {
                ParticleTweakInterface particleTweakInterface = (ParticleTweakInterface)((Object)smallCascadeParticle);
                particleTweakInterface.particleTweaks$setNewSystem(true);
                particleTweakInterface.particleTweaks$setMovesWithFluid(true);
                particleTweakInterface.particleTweaks$setCanBurn(true);
                particleTweakInterface.particleTweaks$setScalesToZero();
                particleTweakInterface.particleTweaks$setSwitchesExit(true);
                particleTweakInterface.particleTweaks$setFluidMovementScale(0.125);
                particleTweakInterface.particleTweaks$setScaler(0.5f);
                particleTweakInterface.particleTweaks$setMaxAlpha(0.25f);
            }
            return smallCascadeParticle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record SplashFactory(class_4002 spriteSet) implements class_707<class_2400>
    {
        @NotNull
        public class_703 createParticle(@NotNull class_2400 defaultParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            FluidFlowParticle splashParticle = new FluidFlowParticle(level, x, y, z, xd, yd, zd, this.spriteSet);
            splashParticle.field_62636 = 0.6f;
            splashParticle.endWhenUnderFluid = true;
            splashParticle.spawnsRipples = true;
            splashParticle.field_17867 *= 1.5f;
            splashParticle.field_3847 *= 3;
            if (splashParticle instanceof ParticleTweakInterface) {
                ParticleTweakInterface particleTweakInterface = (ParticleTweakInterface)((Object)splashParticle);
                particleTweakInterface.particleTweaks$setNewSystem(true);
                particleTweakInterface.particleTweaks$setMovesWithFluid(true);
                particleTweakInterface.particleTweaks$setCanBurn(true);
                particleTweakInterface.particleTweaks$setScalesToZero();
                particleTweakInterface.particleTweaks$setSwitchesExit(true);
                particleTweakInterface.particleTweaks$setFluidMovementScale(0.05);
                particleTweakInterface.particleTweaks$setScaler(0.75f);
                particleTweakInterface.particleTweaks$setMaxAlpha(0.6f);
            }
            return splashParticle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record WaterFactory(class_4002 spriteSet) implements class_707<class_2400>
    {
        @NotNull
        public class_703 createParticle(@NotNull class_2400 defaultParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            FluidFlowParticle waterParticle = new FluidFlowParticle(level, x, y, z, xd, yd, zd, this.spriteSet);
            int waterColor = ((class_1959)level.method_23753(class_2338.method_49637((double)x, (double)y, (double)z)).comp_349()).method_8687();
            waterParticle.field_62633 = Math.clamp((float)class_9848.method_61327((int)waterColor) / 255.0f * (float)random.method_43385(1.3, 0.3), 0.0f, 1.0f);
            waterParticle.field_62635 = Math.clamp((float)class_9848.method_61331((int)waterColor) / 255.0f * (float)random.method_43385(1.3, 0.3), 0.0f, 1.0f);
            waterParticle.field_62634 = Math.clamp((float)class_9848.method_61329((int)waterColor) / 255.0f * (float)random.method_43385(1.3, 0.3), 0.0f, 1.0f);
            waterParticle.field_62636 = 0.6f;
            waterParticle.field_17867 *= 0.5f;
            waterParticle.floatOnFluid = true;
            waterParticle.endWhenUnderFluid = false;
            waterParticle.method_3080(0.0325f, 0.0325f);
            if (waterParticle instanceof ParticleTweakInterface) {
                ParticleTweakInterface particleTweakInterface = (ParticleTweakInterface)((Object)waterParticle);
                particleTweakInterface.particleTweaks$setNewSystem(true);
                particleTweakInterface.particleTweaks$setMovesWithFluid(true);
                particleTweakInterface.particleTweaks$setCanBurn(true);
                particleTweakInterface.particleTweaks$setScalesToZero();
                particleTweakInterface.particleTweaks$setSwitchesExit(true);
                particleTweakInterface.particleTweaks$setFluidMovementScale(0.05);
                particleTweakInterface.particleTweaks$setScaler(0.5f);
                particleTweakInterface.particleTweaks$setMaxAlpha(0.6f);
            }
            return waterParticle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record LavaFactory(class_4002 spriteSet) implements class_707<class_2400>
    {
        @NotNull
        public class_703 createParticle(@NotNull class_2400 defaultParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            FluidFlowParticle lavaParticle = new FluidFlowParticle(level, x, y, z, xd, yd, zd, this.spriteSet);
            lavaParticle.field_62633 = (float)class_9848.method_61327((int)16743195) / 255.0f;
            lavaParticle.field_62635 = (float)class_9848.method_61331((int)16743195) / 255.0f;
            lavaParticle.field_62634 = (float)class_9848.method_61329((int)16743195) / 255.0f;
            lavaParticle.isLava = true;
            lavaParticle.field_17867 *= 0.75f;
            lavaParticle.floatOnFluid = false;
            lavaParticle.endWhenUnderFluid = false;
            lavaParticle.method_3080(0.078125f, 0.078125f);
            if (lavaParticle instanceof ParticleTweakInterface) {
                ParticleTweakInterface particleTweakInterface = (ParticleTweakInterface)((Object)lavaParticle);
                particleTweakInterface.particleTweaks$setNewSystem(true);
                particleTweakInterface.particleTweaks$setMovesWithFluid(true);
                particleTweakInterface.particleTweaks$setCanBurn(true);
                particleTweakInterface.particleTweaks$setScalesToZero();
                particleTweakInterface.particleTweaks$setSwitchesExit(true);
                particleTweakInterface.particleTweaks$setFluidMovementScale(0.05);
                particleTweakInterface.particleTweaks$setScaler(0.5f);
            }
            return lavaParticle;
        }
    }
}

