/*
 * Decompiled with CFR 0.152.
 */
package net.lunade.particletweaks.particle;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1059;
import net.minecraft.class_10799;
import net.minecraft.class_11944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2400;
import net.minecraft.class_310;
import net.minecraft.class_3940;
import net.minecraft.class_4002;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class WaveParticle
extends class_3940 {
    private static final Quaternionf EMPTY = new Quaternionf();
    public static final class_3940.class_11941 WAVE = new class_3940.class_11941(true, class_1059.field_17898, class_10799.field_56871);
    private final class_4002 spriteSet;
    private final float width;
    private final float strength;

    WaveParticle(@NotNull class_638 level, double x, double y, double z, float width, float strength, @NotNull class_4002 spriteSet) {
        super(level, x, y + 1.0 - 0.15625, z, 0.0, 0.0, 0.0, spriteSet.method_74304());
        this.method_3080(width, 1.0f);
        this.field_17867 = 0.75f;
        this.field_17867 *= 1.25f;
        this.spriteSet = spriteSet;
        this.width = width;
        this.strength = strength;
        this.field_3847 = 13;
    }

    public void method_3070() {
        if (this.field_3866++ >= this.field_3847) {
            this.method_3085();
        }
        this.method_74306(this.spriteSet);
        class_310 minecraft = class_310.method_1551();
        Vector3f leftVector = minecraft.field_1773.method_19418().method_35689();
        leftVector = new Vector3f(leftVector.x(), 0.0f, leftVector.z()).normalize();
        double sin = Math.sin((double)this.field_3866 * Math.PI / 19.0);
        this.field_3852 = sin * (0.015 * (double)leftVector.x());
        this.field_3850 = sin * (0.015 * (double)leftVector.z());
    }

    protected void method_60375(class_11944 quadParticleRenderState, Quaternionf quaternionf, float x, float y, float z, float partialTick) {
        float width = this.getWidth(partialTick);
        float halfWidth = width * 0.5f;
        float height = this.getHeight(partialTick);
        float quadSize = this.method_18132(partialTick);
        float UA = this.method_18133();
        float UB = this.method_18134();
        float V0 = this.method_18135();
        float V1 = this.method_18136();
        int color = class_9848.method_61318((float)this.field_62636, (float)this.field_62633, (float)this.field_62634, (float)this.field_62635);
        int lightColor = this.method_3068(partialTick);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            float offsetX = x - (float)direction.method_10148() * halfWidth;
            float offsetZ = z - (float)direction.method_10165() * halfWidth;
            quadParticleRenderState.method_74323(WAVE, offsetX, y, offsetZ, (float)direction.ordinal(), width, height, 0.0f, quadSize, UA, UB, V0, V1, color, lightColor);
            quadParticleRenderState.method_74323(WAVE, offsetX, y, offsetZ, (float)direction.ordinal(), width, height, 1.0f, quadSize, UB, UA, V0, V1, color, lightColor);
        }
    }

    public float getWidth(float tickDelta) {
        return this.width + ((float)this.field_3866 + tickDelta) / (float)this.field_3847 * this.strength * 0.75f;
    }

    public float getHeight(float tickDelta) {
        float heightProgress = (float)Math.sin((double)((float)this.field_3866 + tickDelta) * Math.PI / (double)this.field_3847);
        return 1.0f + heightProgress * this.strength * 0.1f;
    }

    @NotNull
    protected class_3940.class_11941 method_74255() {
        return WAVE;
    }

    @Environment(value=EnvType.CLIENT)
    public record Factory(@NotNull class_4002 spriteSet) implements class_707<class_2400>
    {
        @NotNull
        public class_703 createParticle(@NotNull class_2400 defaultParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            WaveParticle waveParticle = new WaveParticle(level, x, y, z, (float)xd, (float)yd, this.spriteSet);
            int waterColor = ((class_1959)level.method_23753(class_2338.method_49637((double)x, (double)y, (double)z)).comp_349()).method_8687();
            waveParticle.field_62633 = (float)class_9848.method_61327((int)waterColor) / 255.0f;
            waveParticle.field_62635 = (float)class_9848.method_61331((int)waterColor) / 255.0f;
            waveParticle.field_62634 = (float)class_9848.method_61329((int)waterColor) / 255.0f;
            return waveParticle;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record OutlineFactory(@NotNull class_4002 spriteSet) implements class_707<class_2400>
    {
        @NotNull
        public class_703 createParticle(@NotNull class_2400 defaultParticleType, @NotNull class_638 level, double x, double y, double z, double xd, double yd, double zd, class_5819 random) {
            return new WaveParticle(level, x, y, z, (float)xd, (float)yd, this.spriteSet);
        }
    }
}

