/*
 * Decompiled with CFR 0.152.
 */
package quest.toybox.clickthrough.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import quest.toybox.clickthrough.config.MappedValueHolder;

public class Config {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static MappedValueHolder<class_2680, class_2248> clickThroughBlocks = new MappedValueHolder(class_4970.class_4971::method_41520);
    public static MappedValueHolder<class_1297, class_1299<?>> clickThroughEntities = new MappedValueHolder(entity -> entity.method_5864().method_40124());
    public static boolean includeSigns = false;
    public static boolean includeItemFrames = false;

    public static void load() {
        Path path = FabricLoader.getInstance().getConfigDir().resolve("quinnsclickthrough.json");
        try {
            Config.writeDefault(path);
        }
        catch (IOException e) {
            LOGGER.error("Failed to write default config: ", (Throwable)e);
        }
        Gson gson = new GsonBuilder().create();
        try {
            JsonArray entities;
            String config = Files.readString(path);
            JsonObject json = (JsonObject)gson.fromJson(config, JsonObject.class);
            JsonElement includeSigns = json.get("include_signs");
            Config.includeSigns = includeSigns == null || includeSigns.getAsBoolean();
            JsonElement includeItemFrames = json.get("include_item_frames");
            Config.includeItemFrames = includeItemFrames == null || includeItemFrames.getAsBoolean();
            JsonArray blocks = json.getAsJsonArray("click_through_blocks");
            if (blocks != null) {
                clickThroughBlocks.clear();
                List elements = (List)class_5699.field_39274.listOf().parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)blocks)).getOrThrow();
                for (class_5699.class_7476 element : elements) {
                    if (element.comp_814()) {
                        Optional tag = class_7923.field_41175.method_46733(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)element.comp_813()));
                        tag.ifPresent(clickThroughBlocks::add);
                        continue;
                    }
                    class_7923.field_41175.method_10223(element.comp_813()).ifPresent(clickThroughBlocks::add);
                }
            }
            if ((entities = json.getAsJsonArray("click_through_entities")) != null) {
                clickThroughEntities.clear();
                List elements = (List)class_5699.field_39274.listOf().parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)entities)).getOrThrow();
                for (class_5699.class_7476 element : elements) {
                    if (element.comp_814()) {
                        Optional tag = class_7923.field_41177.method_46733(class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)element.comp_813()));
                        tag.ifPresent(clickThroughEntities::add);
                        continue;
                    }
                    class_7923.field_41177.method_10223(element.comp_813()).ifPresent(clickThroughEntities::add);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to read config: ", (Throwable)e);
        }
    }

    public static void writeDefault(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.writeString(path, (CharSequence)"{\n  \"click_through_blocks\": [\n    \"framedblocks:framed_item_frame\",\n    \"framedblocks:framed_glowing_item_frame\"\n  ],\n  \"include_signs\": true,\n  \"click_through_entities\": [],\n  \"include_item_frames\": true\n}\n", new OpenOption[0]);
    }
}

