/*
 * Decompiled with CFR 0.152.
 */
package quest.toybox.clickthrough;

import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import quest.toybox.clickthrough.services.ClickThroughHelper;

public class ClickThrough {
    private static ClickThroughHelper helper = ServiceLoader.load(ClickThroughHelper.class).findFirst().orElseThrow();

    public static BlockPos canClickThroughBlock(ClientLevel level, BlockHitResult hit) {
        BlockPos target;
        if (helper.isDisabled()) {
            return null;
        }
        BlockPos pos = hit.getBlockPos();
        BlockState state = level.getBlockState(pos);
        if ((helper.canClickThroughAllSigns() && (state.is(BlockTags.WALL_SIGNS) || state.getBlock() instanceof SignBlock) || helper.getExtraClickThroughBlocks().contains(state)) && (target = ClickThrough.raytraceBlockBehindTarget(pos)) != null) {
            return target;
        }
        if (helper.canClickThroughAllSigns() && (state.is(BlockTags.WALL_SIGNS) || state.getBlock() instanceof SignBlock) && state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            return pos.relative(facing.getOpposite());
        }
        return null;
    }

    @Nullable
    private static BlockPos raytraceBlockBehindTarget(BlockPos target) {
        LocalPlayer player = Minecraft.getInstance().player;
        float partialTicks = Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(true);
        Vec3 eyePosition = player.getEyePosition(partialTicks);
        Vec3 viewVector = player.getViewVector(partialTicks);
        double hitDistance = player.blockInteractionRange();
        Vec3 endPos = eyePosition.add(viewVector.multiply(hitDistance, hitDistance, hitDistance));
        ClipContext context = new ClipContext(eyePosition, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        AtomicBoolean hasSeenTarget = new AtomicBoolean(false);
        return (BlockPos)BlockGetter.traverseBlocks((Vec3)context.getFrom(), (Vec3)context.getTo(), (Object)context, (clipContext, pos1) -> {
            if (hasSeenTarget.get()) {
                return pos1;
            }
            if (target.equals(pos1)) {
                hasSeenTarget.set(true);
            }
            return null;
        }, clipContext -> null);
    }

    public static BlockPos canClickThroughEntity(ClientLevel level, LocalPlayer player, EntityHitResult hit) {
        BlockPos target;
        if (helper.isDisabled()) {
            return null;
        }
        Entity entity = hit.getEntity();
        if ((helper.canClickThroughAllItemFrames() && entity instanceof ItemFrame || helper.getExtraClickThroughEntities().contains(entity)) && (target = ClickThrough.raytraceBlockBehindTarget(entity.blockPosition())) != null) {
            return target;
        }
        if (helper.canClickThroughAllItemFrames() && entity instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)entity;
            return frame.getPos().relative(frame.getDirection().getOpposite());
        }
        return null;
    }

    public static boolean shouldInteractWith(ClientLevel level, BlockPos pos) {
        return true;
    }
}

