/*
 * Decompiled with CFR 0.152.
 */
package quest.toybox.clickthrough;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import quest.toybox.clickthrough.config.Config;
import quest.toybox.clickthrough.config.ToggleKeyBind;

@Mod(value="quinnsclickthrough", dist={Dist.CLIENT})
public class NeoForgeClient {
    public static final String MOD_ID = "quinnsclickthrough";
    public static final Lazy<ToggleKeyBind> TOGGLE_MOD_KEY = Lazy.of(() -> new ToggleKeyBind("key.quinnsclickthrough.toggle", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 46, KeyMapping.Category.GAMEPLAY));

    public NeoForgeClient(IEventBus bus, ModContainer container) {
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.SPEC);
        bus.addListener(this::registerKeyBinds);
        bus.addListener(this::onConfigLoaded);
        NeoForge.EVENT_BUS.addListener(this::onTagsUpdated);
    }

    private void registerKeyBinds(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)TOGGLE_MOD_KEY.get());
    }

    private void onConfigLoaded(ModConfigEvent event) {
        Config.loadConfig();
    }

    private void onTagsUpdated(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED) {
            Config.loadConfig();
        }
    }
}

