/*
 * Decompiled with CFR 0.152.
 */
package quest.toybox.clickthrough.config;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ModConfigSpec;
import quest.toybox.clickthrough.config.MappedValueHolder;

public class Config {
    public static MappedValueHolder<BlockState, Block> clickThroughBlocks = new MappedValueHolder(BlockBehaviour.BlockStateBase::getBlockHolder);
    public static MappedValueHolder<Entity, EntityType<?>> clickThroughEntities = new MappedValueHolder(entity -> entity.getType().builtInRegistryHolder());
    public static boolean includeSigns = true;
    public static boolean includeItemFrames = true;
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.ConfigValue<List<? extends String>> CLICK_THROUGH_BLOCKS = BUILDER.comment("A list of blocks or tags that can be clicked through.").defineListAllowEmpty("click_through_blocks", List.of("framedblocks:framed_item_frame", "framedblocks:framed_glowing_item_frame"), string -> true);
    public static final ModConfigSpec.BooleanValue INCLUDE_SIGNS = BUILDER.comment("Should all sign blocks be allowed to be clicked through?").define("include_signs", true);
    public static final ModConfigSpec.ConfigValue<List<? extends String>> CLICK_THROUGH_ENTITIES = BUILDER.comment("A list of entities or tags that can be clicked through.").defineListAllowEmpty("click_through_entities", List.of(), string -> true);
    public static final ModConfigSpec.BooleanValue INCLUDE_ITEM_FRAMES = BUILDER.comment("Should all item frames be allowed to be clicked through?").define("include_item_frames", true);
    public static final ModConfigSpec SPEC = BUILDER.build();

    public static void loadConfig() {
        Optional tag;
        includeSigns = INCLUDE_SIGNS.getAsBoolean();
        includeItemFrames = INCLUDE_ITEM_FRAMES.getAsBoolean();
        clickThroughBlocks.clear();
        List elements = (List)ExtraCodecs.TAG_OR_ELEMENT_ID.listOf().parse(new Dynamic((DynamicOps)JavaOps.INSTANCE, CLICK_THROUGH_BLOCKS.get())).getOrThrow();
        for (ExtraCodecs.TagOrElementLocation element : elements) {
            if (element.tag()) {
                tag = BuiltInRegistries.BLOCK.get(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)element.id()));
                tag.ifPresent(clickThroughBlocks::add);
                continue;
            }
            BuiltInRegistries.BLOCK.get(element.id()).ifPresent(clickThroughBlocks::add);
        }
        clickThroughEntities.clear();
        elements = (List)ExtraCodecs.TAG_OR_ELEMENT_ID.listOf().parse(new Dynamic((DynamicOps)JavaOps.INSTANCE, CLICK_THROUGH_ENTITIES.get())).getOrThrow();
        for (ExtraCodecs.TagOrElementLocation element : elements) {
            if (element.tag()) {
                tag = BuiltInRegistries.ENTITY_TYPE.get(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)element.id()));
                tag.ifPresent(clickThroughEntities::add);
                continue;
            }
            BuiltInRegistries.ENTITY_TYPE.get(element.id()).ifPresent(clickThroughEntities::add);
        }
    }
}

