/*
 * Decompiled with CFR 0.152.
 */
package quest.toybox.clickthrough.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;

public class MappedValueHolder<Specific, Type> {
    private final List<Holder<Type>> singlets = new ArrayList<Holder<Type>>();
    private final List<HolderSet<Type>> plurals = new ArrayList<HolderSet<Type>>();
    private final Function<Specific, Holder<Type>> getType;

    public MappedValueHolder(Function<Specific, Holder<Type>> getType) {
        this.getType = getType;
    }

    public boolean contains(Specific specific) {
        for (Holder<Type> holder : this.singlets) {
            if (this.getType.apply(specific) != holder) continue;
            return true;
        }
        for (HolderSet holderSet : this.plurals) {
            if (!holderSet.contains(this.getType.apply(specific))) continue;
            return true;
        }
        return false;
    }

    public void add(Holder<Type> holder) {
        this.singlets.add(holder);
    }

    public void add(HolderSet<Type> holders) {
        this.plurals.add(holders);
    }

    public void clear() {
        this.singlets.clear();
        this.plurals.clear();
    }
}

