/*
 * Decompiled with CFR 0.152.
 */
package quest.toybox.clickthrough.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import quest.toybox.clickthrough.ClickThrough;

@Mixin(value={Minecraft.class})
public abstract class ClickThroughMixin {
    @Shadow
    @Nullable
    public LocalPlayer player;
    @Shadow
    @Nullable
    public ClientLevel level;
    @Shadow
    @Nullable
    public HitResult hitResult;

    @Shadow
    protected abstract void startUseItem();

    @WrapOperation(method={"startUseItem()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;useItemOn(Lnet/minecraft/client/player/LocalPlayer;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/phys/BlockHitResult;)Lnet/minecraft/world/InteractionResult;")})
    private InteractionResult allowClickThroughBlock(MultiPlayerGameMode instance, LocalPlayer player, InteractionHand hand, BlockHitResult hit, Operation<InteractionResult> original) {
        if (player.isShiftKeyDown()) {
            return (InteractionResult)original.call(new Object[]{instance, player, hand, hit});
        }
        BlockPos supportingBlockPos = ClickThrough.canClickThroughBlock(this.level, hit);
        if (supportingBlockPos != null && ClickThrough.shouldInteractWith(this.level, supportingBlockPos)) {
            return (InteractionResult)original.call(new Object[]{instance, player, hand, new BlockHitResult(Vec3.atCenterOf((Vec3i)supportingBlockPos), hit.getDirection(), supportingBlockPos, hit.isInside())});
        }
        return (InteractionResult)original.call(new Object[]{instance, player, hand, hit});
    }

    @Inject(method={"startUseItem()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;interactAt(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/EntityHitResult;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;")}, cancellable=true)
    private void allowClickThroughEntity(CallbackInfo ci, @Local EntityHitResult hit) {
        if (this.player.isShiftKeyDown()) {
            return;
        }
        BlockPos supportingBlockPos = ClickThrough.canClickThroughEntity(this.level, this.player, hit);
        if (supportingBlockPos != null && ClickThrough.shouldInteractWith(this.level, supportingBlockPos)) {
            float partialTicks = Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(true);
            Optional closest = this.level.getBlockState(supportingBlockPos).getShape((BlockGetter)this.level, supportingBlockPos).move((double)supportingBlockPos.getX(), (double)supportingBlockPos.getY(), (double)supportingBlockPos.getZ()).closestPointTo(this.player.getEyePosition(partialTicks));
            this.hitResult = new BlockHitResult(closest.orElse(Vec3.atCenterOf((Vec3i)supportingBlockPos)), Direction.getApproximateNearest((Vec3)this.player.getLookAngle()), supportingBlockPos, false);
            this.startUseItem();
            this.hitResult = hit;
            ci.cancel();
        }
    }
}

