/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.blocks;

import com.mojang.serialization.MapCodec;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity.PPM_BlockEntity;
import com.qdc_mod.qdc_core_4.qdc_core.core.init.BlockInit;
import com.qdc_mod.qdc_core_4.qdc_core.functions.pushy_pully_mergy.PushyPullyMergyFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class PPM_Block
extends BaseEntityBlock {
    public static final MapCodec<PPM_Block> CODEC = PPM_Block.simpleCodec(PPM_Block::new);

    public PPM_Block(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new PPM_BlockEntity(pPos, pState);
    }

    protected RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof PPM_BlockEntity) {
            PPM_BlockEntity ppm_BlockEntity = (PPM_BlockEntity)blockEntity;
            if (pStack.getItem() == QdcApi.PUSHY_PULLY_MERGY.PPM_MONITOR) {
                if (PushyPullyMergyFunctions.displayMonitorData(ppm_BlockEntity, pLevel.isClientSide)) {
                    PushyPullyMergyFunctions.playMonitorSound(pPlayer, pLevel, pPos);
                } else {
                    PushyPullyMergyFunctions.playErrorSound(pPlayer, pLevel, pPos);
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (pStack.getItem() == QdcApi.PUSHY_PULLY_MERGY.PPM_MERGER) {
                if (PushyPullyMergyFunctions.mergePpmBlocks(pPlayer, pLevel, pHitResult.getDirection(), ppm_BlockEntity, pPos, pLevel.isClientSide)) {
                    PushyPullyMergyFunctions.playMergeSound(pPlayer, pLevel, pPos);
                } else {
                    PushyPullyMergyFunctions.playErrorSound(pPlayer, pLevel, pPos);
                    if (pLevel.isClientSide) {
                        GlobalFuncs.showInGameMessage("Not enough blocks with same item and level!!");
                    }
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (pStack.isEmpty() && !ppm_BlockEntity.isEmpty()) {
                BlockPos newPos = PushyPullyMergyFunctions.movePPMBlock(pPos, pHitResult.getDirection(), pPlayer.isShiftKeyDown());
                if (pLevel.getBlockState(newPos).getBlock() != Blocks.AIR) {
                    return ItemInteractionResult.SUCCESS;
                }
                pLevel.setBlockAndUpdate(newPos, pState);
                PPM_BlockEntity newEntity = (PPM_BlockEntity)pLevel.getBlockEntity(newPos);
                newEntity.cloneFrom(ppm_BlockEntity);
                pLevel.setBlockAndUpdate(pPos, Blocks.AIR.defaultBlockState());
                return ItemInteractionResult.SUCCESS;
            }
            if (pStack.getItem() == ((PPM_Block)((Object)BlockInit.EMPTY_PPM_CONTAINER.get())).asItem()) {
                return ItemInteractionResult.SUCCESS;
            }
            if (ppm_BlockEntity.inventory.getStackInSlot(0).isEmpty() && !pStack.isEmpty() && QdcApi.QDC_CORE.FUNCTIONS.itemHasParticles(pStack.getItem())) {
                ppm_BlockEntity.inventory.insertItem(0, pStack.copy(), false);
                if (!pLevel.isClientSide) {
                    ppm_BlockEntity.setItemParticles(pStack.getItem());
                }
                pStack.shrink(1);
                pLevel.playSound(pPlayer, pPos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 2.0f);
            }
        }
        return ItemInteractionResult.SUCCESS;
    }
}

