/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines;

import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.functions.BERFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import com.qdc_mod.qdc_core_4.qdc_machines.boxes.mob_compressor_box.MobCompressorBox;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.MachineDataMobCompressor;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.MachineData;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineSpeedHandler;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MobCompressorFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockEntityInit;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockInit;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class tile_entity_mob_compressor
extends BlockEntity {
    public boolean isWorking = false;
    public MachineData machineData = new MachineData("Mob Compressor MK5");
    public int speed = 5;
    public int size = 0;
    public Block placeSeedItem = null;
    public ParticleCollection fuelParticles = null;
    public int workAreaIndex = 0;
    public int tickPerc = 0;
    public ItemStackHandler itemHandler = this.createItemHandler();
    public int curTick = 0;
    public int nextTarget = 100;
    public int curDelayTicks = 0;
    public int idleTickCount = 170;
    public int maxIdleTicks = 1700;
    public int maxDelayTicks = 16;
    public int speedLevelValue = 2;
    public int idleSpeedLevelValue = 100;
    public boolean powered = true;
    public Block curInvBlock = null;
    private boolean isSpeedSet = false;
    private Direction placerDirection = null;
    private IItemHandler blockInventoryHandler = null;
    private AABB workArea = null;
    public Entity curMob = null;
    public Item curEggType = null;
    public boolean hasEggParticles = false;
    private ParticleCollection eggParticles = null;
    MachineDataMobCompressor mobData = null;
    private int steps = 4;
    private double angleGap = 180 / this.steps;

    public tile_entity_mob_compressor(BlockPos pos, BlockState state) {
        super(BlockEntityInit.TILE_ENTITY_MOB_COMPRESSOR.get(), pos, state);
    }

    private ParticleCollection getEggParticles() {
        return QdcApi.QDC_CORE.FUNCTIONS.getItemParticles(Items.EGG);
    }

    public ItemStack getSizeStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    public ItemStack getSpeedStack() {
        return this.itemHandler.getStackInSlot(1);
    }

    public ItemStack getSeedStack() {
        return this.itemHandler.getStackInSlot(2);
    }

    public ItemStack getCurInvBlockStack() {
        if (this.curInvBlock == null) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)this.curInvBlock);
    }

    public boolean addMachineCore(Item item, int index) {
        if (index < 0 || index > 1) {
            return false;
        }
        if (this.itemHandler.getStackInSlot(index).getItem() == item) {
            return false;
        }
        this.itemHandler.setStackInSlot(index, new ItemStack((ItemLike)item));
        this.setSpeed();
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        GlobalFuncs.showInGameMessage("--------------------------");
        GlobalFuncs.showInGameMessage(this.machineData._machineName + " : " + String.valueOf(this.getBlockPos()));
        if (index == 0) {
            GlobalFuncs.showInGameMessage("Area size set to: " + this.machineData._sizeString);
        } else {
            GlobalFuncs.showInGameMessage("Machine speed set to: " + this.machineData._speedString);
        }
        return true;
    }

    private void setSpeed() {
        this.speed = MachineSpeedHandler.getHoeItemSpeedLevel(this.itemHandler.getStackInSlot(1).getItem());
        this.updateTickCountsBySpeed();
        this.machineData._speedString = this.speed + 1 + "/7";
    }

    public void setWorkArea() {
        this.workArea = MobCompressorFunctions.getWorkArea(this.getBlockPos());
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                tile_entity_mob_compressor.this.setChanged();
                if (slot == 0) {
                    // empty if block
                }
                if (slot == 1) {
                    tile_entity_mob_compressor.this.setSpeed();
                }
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void updateTickCountsBySpeed() {
        this.idleTickCount = this.maxIdleTicks - this.speed * this.idleSpeedLevelValue;
        this.nextTarget = this.curDelayTicks = this.maxDelayTicks - this.speed * this.speedLevelValue;
    }

    public void sendToClient() {
        if (this.level != null) {
            if (!this.getSeedStack().isEmpty()) {
                this.machineData._mainItemName = BERFunctions.getItemName(this.getSeedStack());
            } else {
                this.machineData._toolTip = "";
                this.machineData._toolTipColor = Color.red;
                this.machineData._mainItemName = "";
            }
            if (!this.powered) {
                this.machineData._toolTip = "No redstone signal!!";
                this.machineData._toolTipColor = Color.red;
                this.machineData._isPowered = false;
            } else if (this.curEggType == null) {
                this.machineData._toolTip = "No eggs in storage...!!!! ";
                this.machineData._toolTipColor = Color.red;
                this.machineData._isPowered = false;
            } else if (!this.hasEggParticles) {
                this.machineData._toolTip = "Not enough particles...!!!! ";
                this.machineData._toolTipColor = Color.red;
                this.machineData._isPowered = false;
            } else if (this.isWorking) {
                this.machineData._toolTip = "Working...!!!! ";
                this.machineData._toolTipColor = Color.green;
                this.machineData._isPowered = true;
            }
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void tick() {
        if (!this.level.isClientSide) {
            if (!this.isSpeedSet) {
                this.updateTickCountsBySpeed();
                this.isSpeedSet = true;
            }
            if (this.workArea == null) {
                this.setWorkArea();
            }
            this.curEggType = this.checkForChickenEggs();
            this.hasEggParticles = this.checkIfHasItemParticles();
            this.sendToClient();
            if (this.level.getDirectSignalTo(this.getBlockPos()) > 0) {
                this.powered = true;
                if (this.curEggType != null && this.hasEggParticles) {
                    ++this.curTick;
                    this.isWorking = true;
                    if (this.curTick >= this.nextTarget) {
                        if (this.handleMob()) {
                            this.isWorking = true;
                            this.animateDecoration();
                        } else {
                            this.isWorking = false;
                        }
                        this.nextTarget = this.curDelayTicks;
                        this.curTick = 0;
                        this.tickPerc = 0;
                    }
                }
            } else {
                this.powered = false;
            }
        }
    }

    private boolean checkIfHasItemParticles() {
        if (this.eggParticles == null) {
            this.eggParticles = this.getEggParticles();
        }
        if (this.eggParticles == null) {
            return false;
        }
        return QdcApi.QDC_CORE.FUNCTIONS.canRemoveParticles(this.eggParticles);
    }

    private Item checkForChickenEggs() {
        return MobCompressorBox.getAvailableEgg();
    }

    private void animateDecoration() {
        if (this.machineData._decorationGoingUp) {
            if (this.machineData._decorationAngle < 360.0f) {
                this.machineData._decorationAngle = (float)((double)this.machineData._decorationAngle + this.angleGap);
            } else {
                this.machineData._decorationGoingUp = false;
            }
        } else if (this.machineData._decorationAngle > 180.0f) {
            this.machineData._decorationAngle = (float)((double)this.machineData._decorationAngle - this.angleGap);
        } else {
            this.machineData._decorationGoingUp = true;
        }
    }

    private boolean handleMob() {
        if (this.mobData == null) {
            this.curMob = this.getMob();
            if (this.curMob == null) {
                return false;
            }
            Item egg = MobCompressorBox.getEggFromEntity(this.curMob);
            this.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)egg));
            this.mobData = new MachineDataMobCompressor(this.curMob, egg, this.addOffset(this.getBlockPos(), 0.5, -1.0, 0.5));
        }
        if (!this.curMob.isAlive()) {
            this.curMob = null;
            this.mobData = null;
            this.emptySeedStack();
            return false;
        }
        if (this.curMob == null) {
            return false;
        }
        this.curMob.setNoGravity(true);
        this.curMob.setGlowingTag(true);
        this.curMob.setSprinting(true);
        BlockPos pos = this.getBlockPos();
        Vec3 curPos = this.mobData.getNext();
        if (curPos != null) {
            this.curMob.setPosRaw(curPos.x, curPos.y, curPos.z);
        } else {
            this.curMob.kill();
            ItemEntity ie = new ItemEntity(this.level, (double)pos.getX() + 0.5, (double)(pos.getY() - 1), (double)pos.getZ() + 0.5, new ItemStack((ItemLike)this.mobData.egg, 1));
            this.level.addFreshEntity((Entity)ie);
            this.removeEggParticlesAndStorage();
            this.emptySeedStack();
            this.curMob = null;
            this.mobData = null;
        }
        return true;
    }

    private void removeEggParticlesAndStorage() {
        QdcApi.QDC_CORE.FUNCTIONS.removeFromStorage(this.curEggType, 1);
        QdcApi.QDC_CORE.FUNCTIONS.removeParticles(this.eggParticles);
    }

    private void emptySeedStack() {
        this.itemHandler.setStackInSlot(2, ItemStack.EMPTY);
    }

    private Vec3 addOffset(BlockPos pos, double x, double y, double z) {
        return new Vec3((double)pos.getX() + x, (double)pos.getY() + y, (double)pos.getZ() + z);
    }

    private Entity getMob() {
        List mobs = this.level.getEntities(null, this.workArea);
        for (Entity e : mobs) {
            if (MobCompressorBox.isValidMob(e) == null) continue;
            return e;
        }
        return null;
    }

    private void dropStuffs(BlockPos pos) {
        NonNullList list = NonNullList.create();
        list.add((Object)new ItemStack((ItemLike)BlockInit.MOB_COMPRESSOR.get()));
        Containers.dropContents((Level)this.level, (BlockPos)pos, (NonNullList)list);
    }

    public void onRemove() {
        this.dropStuffs(this.getBlockPos());
    }

    protected void saveAdditional(CompoundTag output, HolderLookup.Provider provider) {
        output.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        output.putInt("speed", this.speed);
        this.machineData.save(output);
        super.saveAdditional(output, provider);
    }

    protected void loadAdditional(CompoundTag input, HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, input.getCompound("inventory"));
        this.speed = input.getInt("speed");
        this.updateTickCountsBySpeed();
        this.machineData.load(input);
        super.loadAdditional(input, provider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        this.saveAdditional(nbt, provider);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider holders) {
        super.handleUpdateTag(tag, holders);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

