/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.functions.BERFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.PotionMachineData;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.WorkAreaSize;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineSpeedHandler;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.PotionMachineFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockEntityInit;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockInit;
import com.qdc_mod.qdc_core_4.qdc_machines.functions.MachineSoundFunctions;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;

public class tile_entity_potion_machine
extends BlockEntity {
    public boolean isWorking = false;
    public PotionMachineData machineData = new PotionMachineData("Potion Machine MK2");
    public int speed = 0;
    public int size = 0;
    public WorkAreaSize workAreaSize;
    public Block placeSeedItem = null;
    public ParticleCollection seedParticles = null;
    public ParticleCollection enchantmentParticles = null;
    public ItemStackHandler itemHandler = this.createItemHandler();
    public double natureParticleAmount = 0.0;
    public int powerLevel = 1;
    public boolean hasFuel = false;
    public boolean effectApplied = false;
    public int effectDuration = 24000;
    public int additionalEffectDuration = 0;

    public tile_entity_potion_machine(BlockPos pos, BlockState state) {
        super(BlockEntityInit.TILE_ENTITY_POTION_MACHINE.get(), pos, state);
    }

    public ItemStack getSpeedStack() {
        return this.itemHandler.getStackInSlot(1);
    }

    public ItemStack getItemStack() {
        return this.itemHandler.getStackInSlot(2);
    }

    public boolean addMachineCore(Item item, int index) {
        if (index < 0 || index > 1) {
            return false;
        }
        if (this.itemHandler.getStackInSlot(index).getItem() == item) {
            return false;
        }
        this.itemHandler.setStackInSlot(index, new ItemStack((ItemLike)item));
        this.setEnchantmentPower();
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        GlobalFuncs.showInGameMessage("--------------------------");
        GlobalFuncs.showInGameMessage(this.machineData._machineName + " : " + String.valueOf(this.getBlockPos()));
        if (index != 0) {
            GlobalFuncs.showInGameMessage("Potion Duration Power set to: " + this.machineData._powerString);
        }
        return true;
    }

    public boolean hasAnItem() {
        return !this.itemHandler.getStackInSlot(2).isEmpty();
    }

    public boolean updateItem(ItemStack item) {
        this.itemHandler.setStackInSlot(2, item.copy());
        this.setChanged();
        if (!item.isEmpty()) {
            GlobalFuncs.showInGameMessage("--------------------------");
            GlobalFuncs.showInGameMessage(this.machineData._machineName + " : " + String.valueOf(this.getBlockPos()));
            GlobalFuncs.showInGameMessage("Potion set to: " + BERFunctions.getItemName(this.getItemStack()));
        }
        return true;
    }

    private void setEnchantmentPower() {
        this.speed = MachineSpeedHandler.getHoeItemSpeedLevel(this.itemHandler.getStackInSlot(1).getItem());
        this.updatePowerLevelByCore();
        this.machineData._powerString = this.speed + 1 + "/7";
        this.machineData.setDurationString(this.effectDuration + this.additionalEffectDuration);
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                tile_entity_potion_machine.this.setChanged();
                if (slot == 1) {
                    tile_entity_potion_machine.this.setEnchantmentPower();
                }
            }
        };
    }

    public void updatePowerLevelByCore() {
        this.additionalEffectDuration = this.speed * 3600;
    }

    public void sendToClient() {
        if (this.level != null) {
            if (this.hasAnItem()) {
                this.machineData._mainItemName = BERFunctions.getItemName(this.getItemStack());
                if (!this.hasFuel) {
                    this.machineData._toolTip = "Not Enough Nature Particles!!!!";
                    this.machineData._toolTipColor = Color.red;
                } else {
                    this.machineData._toolTip = "Apply redstone signal to apply potion!!";
                    this.machineData._toolTipColor = Color.green;
                }
            } else {
                this.machineData._toolTip = "No Potion added!!!!";
                this.machineData._toolTipColor = Color.red;
                this.machineData._mainItemName = "";
            }
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void tick() {
        if (!this.level.isClientSide) {
            this.updatePowerLevelByCore();
            if (this.hasAnItem()) {
                this.enchantmentParticles = null;
                this.hasFuel = this.checkIfHasParticlesInStorage();
                if (this.level.getDirectSignalTo(this.getBlockPos()) > 0) {
                    if (this.hasFuel && !this.effectApplied) {
                        this.applyPotionEffect();
                        this.removeFuelParticles();
                        MachineSoundFunctions.playEnchantSound(this.level, this.getBlockPos());
                        this.effectApplied = true;
                    }
                } else {
                    this.effectApplied = false;
                }
            }
            this.sendToClient();
        }
    }

    public void applyPotionEffect() {
        Iterable<MobEffectInstance> effects = PotionMachineFunctions.getEffectsFromPotion(this.getItemStack());
        if (effects != null) {
            for (MobEffectInstance mei : effects) {
                MobEffectInstance tempEffect = new MobEffectInstance(mei.getEffect(), this.effectDuration + this.additionalEffectDuration);
                Qdc.curPlayer.addEffect(tempEffect);
            }
        }
    }

    private void removeFuelParticles() {
        QdcApi.QDC_CORE.FUNCTIONS.removeParticles(this.enchantmentParticles);
    }

    private boolean checkIfHasParticlesInStorage() {
        if (this.enchantmentParticles == null) {
            this.enchantmentParticles = new ParticleCollection();
            this.natureParticleAmount = 10000.0;
            this.enchantmentParticles.add(new ParticleItem(ENUMS.ParticleType.NATURE, this.natureParticleAmount));
        }
        return QdcApi.QDC_CORE.FUNCTIONS.canRemoveParticles(this.enchantmentParticles);
    }

    private void dropStuffs(BlockPos pos) {
        NonNullList list = NonNullList.create();
        list.add((Object)new ItemStack((ItemLike)BlockInit.POTION_MACHINE.get()));
        if (this.hasAnItem()) {
            list.add((Object)this.getItemStack());
        }
        Containers.dropContents((Level)this.level, (BlockPos)pos, (NonNullList)list);
    }

    public void onRemove() {
        this.dropStuffs(this.getBlockPos());
    }

    protected void saveAdditional(CompoundTag output, HolderLookup.Provider provider) {
        output.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        output.putInt("speed", this.speed);
        this.machineData.save(output);
        super.saveAdditional(output, provider);
    }

    protected void loadAdditional(CompoundTag input, HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, input.getCompound("inventory"));
        this.speed = input.getInt("speed");
        this.updatePowerLevelByCore();
        this.machineData.load(input);
        this.setEnchantmentPower();
        super.loadAdditional(input, provider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        this.saveAdditional(nbt, provider);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider holders) {
        super.handleUpdateTag(tag, holders);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

