/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.functions;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.classes.PosePoint;
import java.awt.Color;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BERFunctions {
    public static final float PLAYER_ANGLE_OFFSET = -90.0f;

    public static float calcToPlayerAngle(Player player, BlockPos pos, float offset) {
        float angle = BERFunctions.getAngle(new PosePoint((float)player.position().x, (float)player.position().z), new PosePoint(pos.getX(), pos.getZ()));
        return angle + offset;
    }

    private static float getAngle(PosePoint targetA, PosePoint targetB) {
        float angle = (float)Math.toDegrees(Math.atan2(targetA.y - targetB.y, targetA.x - targetB.x));
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    public static void writeText(PosePoint pp, String toWrite, Color color, Font font, PoseStack ps, MultiBufferSource buffer, int packedLight) {
        float textWidth = font.width(toWrite) / 2;
        ps.translate(pp.x, pp.y, 0.0f);
        ps.translate(textWidth * -1.0f, 0.0f, 0.0f);
        font.drawInBatch(toWrite, 0.0f, 0.0f, color.getRGB(), false, ps.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        ps.translate(textWidth, 0.0f, 0.0f);
        ps.translate(pp.getInverse().x, pp.getInverse().y, 0.0f);
    }

    public static void drawDecorationIcon(PosePoint pp, BlockEntityRendererProvider.Context ctx, ItemStack stack, PoseStack ps, MultiBufferSource buffer, Level level, int packedLight, float angle) {
        ps.translate(pp.x, pp.y, pp.z);
        ps.mulPose(Axis.ZP.rotationDegrees(angle + 180.0f));
        ctx.getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, ps, buffer, level, 0);
        ps.mulPose(Axis.ZP.rotationDegrees(360.0f - (angle + 180.0f)));
        ps.translate(pp.getInverse().x, pp.getInverse().y, pp.getInverse().z);
    }

    public static void drawIcon(PosePoint pp, BlockEntityRendererProvider.Context ctx, ItemStack stack, PoseStack ps, MultiBufferSource buffer, Level level, int packedLight) {
        ps.translate(pp.x, pp.y, 0.0f);
        ctx.getItemRenderer().renderStatic(stack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, ps, buffer, level, 0);
        ps.translate(pp.getInverse().x, pp.getInverse().y, 0.0f);
    }

    public static String getItemName(ItemStack is) {
        if (is != null && !is.isEmpty()) {
            return is.getDisplayName().getString();
        }
        return "";
    }

    public class POSITIONS {
        public static final PosePoint MAIN_ICON_POS = new PosePoint(0.0f, 0.9f);
        public static final PosePoint SIZE_ICON_POS = new PosePoint(-0.9f, -1.1f);
        public static final PosePoint SPEED_ICON_POS = new PosePoint(0.9f, -1.1f);
        public static final PosePoint mainItemNamePos = new PosePoint(0.0f, -17.0f);
        public static final PosePoint mainTextPos = new PosePoint(0.0f, -5.0f);
        public static final PosePoint machineNamePos = new PosePoint(0.0f, -65.0f);
        public static final PosePoint sizeTitlePos = new PosePoint(-35.0f, 5.0f);
        public static final PosePoint speetTitlePos = new PosePoint(35.0f, 5.0f);
        public static final PosePoint sizeValuePos = new PosePoint(-35.0f, 17.0f);
        public static final PosePoint speedValuePos = new PosePoint(35.0f, 17.0f);

        public POSITIONS(BERFunctions this$0) {
        }

        public class QUARRY {
            private static final float SIZE_CORE_ICON_WIDTH = 1.0f;
            private static final float SIZE_CORE_ICON_Y_POS = -1.75f;
            private static final float SIZE_CORE_TITLE_WIDTH = 28.0f;
            private static final float SIZE_CORE_TITLE_Y_POS = 15.0f;
            private static final float SIZE_CORE_VALUE_Y_POS = 25.0f;
            public static final PosePoint X_SIZE_ICON_POS = new PosePoint(-1.9f, -1.75f);
            public static final PosePoint Y_SIZE_ICON_POS = new PosePoint(QUARRY.X_SIZE_ICON_POS.x + 1.0f, -1.75f);
            public static final PosePoint Z_SIZE_ICON_POS = new PosePoint(QUARRY.Y_SIZE_ICON_POS.x + 1.0f, -1.75f);
            public static final PosePoint X_SIZE_TITLE_POS = new PosePoint(-53.0f, 15.0f);
            public static final PosePoint Y_SIZE_TITLE_POS = new PosePoint(QUARRY.X_SIZE_TITLE_POS.x + 28.0f, 15.0f);
            public static final PosePoint Z_SIZE_TITLE_POS = new PosePoint(QUARRY.Y_SIZE_TITLE_POS.x + 28.0f, 15.0f);
            public static final PosePoint X_SIZE_VALUE_POS = new PosePoint(QUARRY.X_SIZE_TITLE_POS.x, 25.0f);
            public static final PosePoint Y_SIZE_VALUE_POS = new PosePoint(QUARRY.Y_SIZE_TITLE_POS.x, 25.0f);
            public static final PosePoint Z_SIZE_VALUE_POS = new PosePoint(QUARRY.Z_SIZE_TITLE_POS.x, 25.0f);
            public static final PosePoint SPEED_ICON_POS = new PosePoint(1.1f, -1.1f);
            public static final PosePoint MAIN_ICON_POS = new PosePoint(0.0f, 0.9f);
            public static final PosePoint MAIN_ITEM_NAME_POS = new PosePoint(0.0f, -17.0f);
            public static final PosePoint MAIN_TEXT_POS = new PosePoint(0.0f, -5.0f);
            public static final PosePoint MACHINE_NAME_POS = new PosePoint(0.0f, -65.0f);
            public static final PosePoint SIZE_TITLE_POS = new PosePoint(-55.0f, 5.0f);
            public static final PosePoint SIZE_VALUE_POS = new PosePoint(-55.0f, 17.0f);
            public static final PosePoint SPEED_TITLE_POS = new PosePoint(45.0f, 5.0f);
            public static final PosePoint SPEED_VALUE_POS = new PosePoint(45.0f, 17.0f);

            public QUARRY(POSITIONS this$1) {
            }
        }
    }

    public class COLORS {
        public static final Color TITLE_COLOR = Color.cyan;
        public static final Color TEXT_COLOR = Color.white;
        public static final Color MAIN_ITEN_NAME_COLOR = Color.yellow;

        public COLORS(BERFunctions this$0) {
        }
    }
}

