/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.recycler;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.RecyclerSettings;
import com.qdc_mod.qdc_core_4.qdc_core.functions.GuiFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import java.awt.Color;
import java.awt.Point;
import net.minecraft.world.item.Item;

public class RecyclerGuiItem {
    public Item item;
    public String itemName = "";
    public boolean isDiscovered = false;
    public boolean hasEnoughParticles = false;
    public boolean isHoveringOver;
    public int corruptionAmount;
    public Point pos;
    public Point itemIconPos;
    public Point corruptionIconPos;
    public Point corruptionIconIconPos;
    public Point corruptionAmountPos;
    public Point corruptionAmountTextPos;
    public Color bgColor;
    public Color textColor;

    public RecyclerGuiItem(Item item, int corruptionAmount, Point pos) {
        this.item = item;
        this.corruptionAmount = corruptionAmount;
        this.pos = pos;
        this.itemName = GlobalFuncs.getItemName(item);
        this.updateDiscovery();
        this.calcStuffPosition();
        this.chechIfHaveEnoughParticles();
        this.calcStuffColor();
    }

    public boolean checkIfHoveringOver(Point windowPos, int mouseX, int mouseY) {
        this.isHoveringOver = GuiFunctions.isHoveringOver(windowPos, this.pos, RecyclerSettings.ITEMS.ITEM.SIZE, new Point(mouseX, mouseY));
        return this.isHoveringOver;
    }

    public void updateDiscovery() {
        this.isDiscovered = QdcApi.QDC_CORE.FUNCTIONS.isItemDiscovered(this.item);
    }

    private void calcStuffPosition() {
        this.itemIconPos = new Point(this.pos.x + RecyclerSettings.ITEMS.ICON.POS.x, this.pos.y + RecyclerSettings.ITEMS.ICON.POS.y);
        this.corruptionIconPos = new Point(this.pos.x + RecyclerSettings.ITEMS.CORRUPTION.ICON.POS.x, this.pos.y + RecyclerSettings.ITEMS.CORRUPTION.ICON.POS.y);
        this.corruptionIconIconPos = new Point(this.pos.x + RecyclerSettings.ITEMS.CORRUPTION.ICON.ICON_POS.x, this.pos.y + RecyclerSettings.ITEMS.CORRUPTION.ICON.ICON_POS.y);
        this.corruptionAmountPos = new Point(this.pos.x + RecyclerSettings.ITEMS.CORRUPTION.AMOUNT.POS.x, this.pos.y + RecyclerSettings.ITEMS.CORRUPTION.AMOUNT.POS.y);
        this.corruptionAmountTextPos = new Point(this.pos.x + RecyclerSettings.ITEMS.CORRUPTION.AMOUNT.TEXT_POS.x, this.pos.y + RecyclerSettings.ITEMS.CORRUPTION.AMOUNT.TEXT_POS.y);
    }

    public void calcStuffColor() {
        if (this.isDiscovered) {
            this.bgColor = Color.green;
            this.textColor = Color.white;
        } else if (this.hasEnoughParticles) {
            this.bgColor = Color.blue;
            this.textColor = Color.white;
        } else {
            this.bgColor = Color.red;
            this.textColor = Color.white;
        }
    }

    public void chechIfHaveEnoughParticles() {
        ParticleCollection collection = new ParticleCollection();
        collection.add(new ParticleItem(ENUMS.ParticleType.CORRUPTION, this.corruptionAmount));
        this.hasEnoughParticles = QdcApi.QDC_CORE.FUNCTIONS.canRemoveParticles(collection);
    }
}

