/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.discovery_box.classes.DiscoveryItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.functions.BERFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.DisassemblerFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import com.qdc_mod.qdc_core_4.qdc_machines.QdcMachines;
import com.qdc_mod.qdc_core_4.qdc_machines.boxes.MachineAreaBox;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.MachineData;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.WorkAreaSize;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineAreaFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineAreaSizeHandler;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineSpeedHandler;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockEntityInit;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockInit;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemStackHandler;

public class tile_entity_crop_harvester
extends BlockEntity {
    public boolean isWorking = false;
    public MachineData machineData = new MachineData("Crop Harvester");
    public Item[] options = new Item[]{Items.PUMPKIN, Items.MELON, Items.SUGAR_CANE, Items.CACTUS, Items.KELP, Items.WHEAT};
    public int speed = 0;
    public int size = 0;
    public WorkAreaSize workAreaSize;
    public Block placeSeedItem = null;
    public boolean hasGrowthLevel = false;
    public ParticleCollection fuelParticles = null;
    public int workAreaIndex = 0;
    public int tickPerc = 0;
    public ItemStackHandler itemHandler = this.createItemHandler();
    public ArrayList<BlockPos> workArea = null;
    public int curTick = 0;
    public int nextTarget = 100;
    public int curDelayTicks = 0;
    public int idleTickCount = 170;
    public int maxIdleTicks = 1700;
    public int maxDelayTicks = 16;
    public int speedLevelValue = 2;
    public int idleSpeedLevelValue = 100;
    public boolean hasCharges = true;
    public boolean powered = true;
    private boolean isSpeedSet = false;
    private boolean isMultiBlock;

    public tile_entity_crop_harvester(BlockPos pos, BlockState state) {
        super(BlockEntityInit.TILE_ENTITY_CROP_HARVESTER.get(), pos, state);
    }

    public ItemStack getSizeStack() {
        return this.itemHandler.getStackInSlot(0);
    }

    public ItemStack getSpeedStack() {
        return this.itemHandler.getStackInSlot(1);
    }

    public ItemStack getSeedStack() {
        return this.itemHandler.getStackInSlot(2);
    }

    public boolean addMachineCore(Item item, int index) {
        if (index < 0 || index > 1) {
            return false;
        }
        if (this.itemHandler.getStackInSlot(index).getItem() == item) {
            return false;
        }
        this.itemHandler.setStackInSlot(index, new ItemStack((ItemLike)item));
        this.setWorkAreaSize();
        this.setSpeed();
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        GlobalFuncs.showInGameMessage("--------------------------");
        GlobalFuncs.showInGameMessage(this.machineData._machineName + " : " + String.valueOf(this.getBlockPos()));
        if (index == 0) {
            GlobalFuncs.showInGameMessage("Area size set to: " + this.machineData._sizeString);
        } else {
            GlobalFuncs.showInGameMessage("Machine speed set to: " + this.machineData._speedString);
        }
        return true;
    }

    public boolean updateSeed(Item item) {
        if (this.getSeedStack().getItem() == item) {
            return false;
        }
        if (!MainBox.isItemDiscovered(item)) {
            DisassemblerFunctions.setItemDiscovered(item);
        }
        this.itemHandler.setStackInSlot(2, new ItemStack((ItemLike)item));
        this.loadSeedItem();
        this.setChanged();
        GlobalFuncs.showInGameMessage("--------------------------");
        GlobalFuncs.showInGameMessage(this.machineData._machineName + " : " + String.valueOf(this.getBlockPos()));
        GlobalFuncs.showInGameMessage("Crop set to: " + BERFunctions.getItemName(this.getSeedStack()));
        return true;
    }

    private void setSpeed() {
        this.speed = MachineSpeedHandler.getHoeItemSpeedLevel(this.itemHandler.getStackInSlot(1).getItem());
        this.updateTickCountsBySpeed();
        this.machineData._speedString = this.speed + 1 + "/7";
    }

    private void setWorkAreaSize() {
        this.workAreaSize = MachineAreaSizeHandler.getAreaSize(this.itemHandler.getStackInSlot(0).getItem());
        this.size = this.workAreaSize.level;
        this.workArea = this.isMultiBlock ? MachineAreaFunctions.getWorkAreaBlocks_multi(this.getLevel(), this.getBlockPos(), MachineAreaBox.box_crop_harvester, this.workAreaSize) : MachineAreaFunctions.getWorkAreaBlocks(this.getLevel(), this.getBlockPos(), MachineAreaBox.box_crop_harvester, this.workAreaSize);
        this.workAreaIndex = 0;
        this.machineData._sizeString = this.workAreaSize.width + "x" + this.workAreaSize.depth;
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(3){

            protected void onContentsChanged(int slot) {
                tile_entity_crop_harvester.this.setChanged();
                if (slot == 0) {
                    tile_entity_crop_harvester.this.setWorkAreaSize();
                }
                if (slot == 1) {
                    tile_entity_crop_harvester.this.setSpeed();
                }
            }
        };
    }

    public void updateTickCountsBySpeed() {
        this.idleTickCount = this.maxIdleTicks - this.speed * this.idleSpeedLevelValue;
        this.nextTarget = this.curDelayTicks = this.maxDelayTicks - this.speed * this.speedLevelValue;
    }

    private Item getCurSeed() {
        if (this.getSeedStack().isEmpty()) {
            return null;
        }
        return this.getSeedStack().getItem();
    }

    public void sendToClient() {
        if (this.level != null) {
            if (this.getCurSeed() != null) {
                this.machineData._mainItemName = BERFunctions.getItemName(this.getSeedStack());
                if (!this.powered) {
                    this.machineData._toolTip = "No redstone signal!!";
                    this.machineData._toolTipColor = Color.red;
                } else if (!this.hasCharges) {
                    this.machineData._toolTip = "No Fuel Particles!!!!";
                    this.machineData._toolTipColor = Color.red;
                } else if (this.isWorking) {
                    this.machineData._toolTip = "Working... " + this.tickPerc + "%";
                    this.machineData._toolTipColor = Color.green;
                } else {
                    this.machineData._toolTip = "Idle... " + this.tickPerc + "%";
                    this.machineData._toolTipColor = Color.blue;
                }
            } else {
                this.machineData._toolTip = "No Crop selected!!";
                this.machineData._toolTipColor = Color.red;
                this.machineData._mainItemName = "";
            }
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void tick() {
        if (!this.level.isClientSide) {
            if (!this.isSpeedSet) {
                this.updateTickCountsBySpeed();
                this.isSpeedSet = true;
            }
            if (this.workAreaSize == null) {
                this.loadWorkAreaSize();
            }
            this.sendToClient();
            this.hasCharges = this.checkIfHasFuel();
            if (this.getCurSeed() != null) {
                this.powered = false;
                if (this.workArea == null) {
                    this.workArea = this.isMultiBlock ? MachineAreaFunctions.getWorkAreaBlocks_multi(this.getLevel(), this.getBlockPos(), MachineAreaBox.box_crop_harvester, this.workAreaSize) : MachineAreaFunctions.getWorkAreaBlocks(this.getLevel(), this.getBlockPos(), MachineAreaBox.box_crop_harvester, this.workAreaSize);
                } else if (this.level.getDirectSignalTo(this.getBlockPos()) > 0) {
                    this.powered = true;
                    if (this.getCurSeed() != null) {
                        if (!this.isWorking) {
                            ++this.curTick;
                            if (this.curTick % 10 == 0) {
                                this.calcPerc(this.curTick, this.nextTarget);
                            }
                            if (this.curTick >= this.nextTarget) {
                                this.isWorking = true;
                                this.nextTarget = this.curDelayTicks;
                                this.curTick = 0;
                                this.tickPerc = 0;
                            }
                        } else {
                            ++this.curTick;
                            if (this.curTick >= this.nextTarget) {
                                this.curTick = 0;
                                if (this.isCropGrown()) {
                                    this.harvestCrop();
                                    QdcApi.QDC_CORE.FUNCTIONS.removeParticles(this.fuelParticles);
                                }
                                ++this.workAreaIndex;
                                this.calcPerc(this.workAreaIndex, this.workArea.size());
                                if (this.workAreaIndex == this.workArea.size()) {
                                    this.workAreaIndex = 0;
                                    this.isWorking = false;
                                    this.curTick = 0;
                                    this.tickPerc = 0;
                                    this.nextTarget = this.idleTickCount;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private boolean checkIfHasFuel() {
        if (this.fuelParticles == null) {
            this.fuelParticles = new ParticleCollection();
            this.fuelParticles.add(new ParticleItem(ENUMS.ParticleType.NATURE, QdcMachines.MACHINE_CHARGE));
        }
        return QdcApi.QDC_CORE.FUNCTIONS.canRemoveParticles(this.fuelParticles);
    }

    private List<ItemStack> getCropDrop(BlockPos pos) {
        ArrayList<ItemStack> res = new ArrayList();
        BlockState curState = this.level.getBlockState(pos);
        res = Block.getDrops((BlockState)curState, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.workArea.get(this.workAreaIndex), (BlockEntity)this.level.getBlockEntity(this.workArea.get(this.workAreaIndex)));
        return res;
    }

    private void harvestCrop() {
        List<ItemStack> res = this.getCropDrop(this.workArea.get(this.workAreaIndex));
        this.level.removeBlock(this.workArea.get(this.workAreaIndex), true);
        if (res != null) {
            for (ItemStack is : res) {
                MainBox.DISCOVERY_BOX.increaseItemCount(new DiscoveryItem(is.getItem(), is.getCount()));
                ParticleCollection pc = QdcApi.QDC_CORE.FUNCTIONS.getItemParticles(is.getItem());
                if ((pc = GlobalFuncs.removeManaFromParticleCollection(pc)) == null) continue;
                for (int i = 0; i < is.getCount(); ++i) {
                    QdcApi.QDC_CORE.FUNCTIONS.addParticles(pc);
                }
            }
        }
    }

    private boolean isCropGrown() {
        BlockState curBlockState = this.level.getBlockState(this.workArea.get(this.workAreaIndex));
        if (curBlockState == null) {
            return false;
        }
        if (this.placeSeedItem == null) {
            return false;
        }
        if (curBlockState.getBlock() == this.placeSeedItem) {
            if (this.hasGrowthLevel) {
                int age = (Integer)curBlockState.getValue((Property)CropBlock.AGE);
                return age == this.getMaxAge();
            }
            return true;
        }
        return false;
    }

    private int getMaxAge() {
        Block block = this.placeSeedItem;
        if (block instanceof CropBlock) {
            CropBlock cb = (CropBlock)block;
            return 7;
        }
        return -1;
    }

    private void calcPerc(int cur, int max) {
        float f_cur = cur;
        float f_max = max;
        this.tickPerc = (int)(f_cur / f_max * 100.0f);
    }

    private void loadSeedItem() {
        this.placeSeedItem = this.getSeedCropBlock();
    }

    private Block getSeedCropBlock() {
        if (this.getCurSeed() == Items.WHEAT) {
            this.hasGrowthLevel = true;
            this.isMultiBlock = false;
            return Block.byItem((Item)Items.WHEAT_SEEDS);
        }
        if (this.getCurSeed() == Items.POTATO) {
            this.hasGrowthLevel = true;
            this.isMultiBlock = false;
            return Blocks.POTATOES;
        }
        if (this.getCurSeed() == Items.PUMPKIN) {
            this.hasGrowthLevel = false;
            this.isMultiBlock = false;
            return Blocks.PUMPKIN;
        }
        if (this.getCurSeed() == Items.MELON) {
            this.hasGrowthLevel = false;
            this.isMultiBlock = false;
            return Blocks.MELON;
        }
        if (this.getCurSeed() == Items.SUGAR_CANE) {
            this.hasGrowthLevel = false;
            this.isMultiBlock = true;
            return Blocks.SUGAR_CANE;
        }
        if (this.getCurSeed() == Items.CACTUS) {
            this.hasGrowthLevel = false;
            this.isMultiBlock = true;
            return Blocks.CACTUS;
        }
        if (this.getCurSeed() == Items.KELP) {
            this.hasGrowthLevel = false;
            this.isMultiBlock = true;
            return Blocks.KELP_PLANT;
        }
        if (MachineFunctions.isValidSeedOption(this.getCurSeed())) {
            this.hasGrowthLevel = true;
            this.isMultiBlock = false;
            return Block.byItem((Item)this.getCurSeed());
        }
        return null;
    }

    private void loadWorkAreaSize() {
        this.workAreaSize = MachineAreaSizeHandler.getAreaSizeByLevel(this.size);
        if (this.workAreaSize == null) {
            this.workAreaSize = MachineAreaSizeHandler.getAreaSizeByLevel(0);
        }
    }

    private void dropStuffs(BlockPos pos) {
        NonNullList list = NonNullList.create();
        list.add((Object)new ItemStack(BlockInit.CROP_HARVESTER));
        Containers.dropContents((Level)this.level, (BlockPos)pos, (NonNullList)list);
    }

    public void onRemove() {
        this.dropStuffs(this.getBlockPos());
    }

    protected void saveAdditional(CompoundTag output, HolderLookup.Provider provider) {
        super.saveAdditional(output, provider);
        output.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        output.putInt("speed", this.speed);
        output.putInt("size", this.size);
        output.putInt("perc", this.tickPerc);
        this.machineData.save(output);
    }

    protected void loadAdditional(CompoundTag input, HolderLookup.Provider provider) {
        super.loadAdditional(input, provider);
        this.itemHandler.deserializeNBT(provider, input.getCompound("inventory"));
        this.speed = input.getInt("speed");
        this.size = input.getInt("size");
        this.loadWorkAreaSize();
        this.loadSeedItem();
        this.updateTickCountsBySpeed();
        this.tickPerc = input.getInt("perc");
        this.machineData.load(input);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        this.saveAdditional(nbt, provider);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider holders) {
        super.handleUpdateTag(tag, holders);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

