/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines;

import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.discovery_box.classes.DiscoveryItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.functions.BERFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.DisassemblerFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.MachineData_Quarry;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.classes.WorkAreaSize;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineSpeedHandler;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.QuarryWorkAreaFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.tile_entity_amber_block;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.classes.BlockProperties;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.resin.AmberBlock;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockEntityInit;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockInit;
import com.qdc_mod.qdc_core_4.qdc_machines.functions.MachineItemUseFunctions;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class tile_entity_quarry
extends BlockEntity {
    public boolean isWorking = false;
    public MachineData_Quarry machineData = new MachineData_Quarry("Quantum Quarry");
    public int speed = 0;
    public int size = 0;
    public WorkAreaSize workAreaSize;
    public Block placeSeedItem = null;
    public ParticleCollection seedParticles = null;
    public int workAreaIndex = 0;
    public int tickPerc = 0;
    public ItemStackHandler itemHandler = this.createItemHandler();
    public List<BlockPos> workArea = null;
    public int curTick = 0;
    public int nextTarget = 100;
    public int curDelayTicks = 0;
    public int idleTickCount = 170;
    public int maxIdleTicks = 1700;
    public int maxDelayTicks = 16;
    public int speedLevelValue = 2;
    public int idleSpeedLevelValue = 100;
    public int workArea_width = 1;
    public int workArea_height = 1;
    public int workArea_depth = 1;
    public boolean powered = true;
    private boolean isSpeedSet = false;
    private Direction placerDirection = null;
    private boolean isDigging = false;
    private boolean isRegenerating = false;

    public tile_entity_quarry(BlockPos pos, BlockState state) {
        super(BlockEntityInit.TILE_ENTITY_QUARRY.get(), pos, state);
    }

    public ItemStack getSeedStack() {
        return this.itemHandler.getStackInSlot(4);
    }

    public boolean addMachineCore(Item item, int index) {
        if (index < 0 || index > 3) {
            return false;
        }
        if (this.itemHandler.getStackInSlot(index).getItem() == item) {
            return false;
        }
        this.itemHandler.setStackInSlot(index, new ItemStack((ItemLike)item));
        this.setSpeed();
        this.getWorkAreaDataFromCores();
        this.setWorkArea();
        this.setChanged();
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        this.workAreaIndex = 0;
        GlobalFuncs.showInGameMessage("--------------------------");
        GlobalFuncs.showInGameMessage(this.machineData._machineName + " : " + String.valueOf(this.getBlockPos()));
        if (index == 0) {
            GlobalFuncs.showInGameMessage("Area Width set to: " + this.machineData._sizeWidthString);
        } else if (index == 1) {
            GlobalFuncs.showInGameMessage("Area Height set to: " + this.machineData._sizeHeightString);
        } else if (index == 2) {
            GlobalFuncs.showInGameMessage("Area Depth set to: " + this.machineData._sizeDepthString);
        } else {
            GlobalFuncs.showInGameMessage("Machine speed set to: " + this.machineData._speedString);
        }
        return true;
    }

    private void setSpeed() {
        this.speed = MachineSpeedHandler.getHoeItemSpeedLevel(this.itemHandler.getStackInSlot(3).getItem());
        this.updateTickCountsBySpeed();
        this.machineData._speedString = this.speed + 1 + "/7";
    }

    private void setWorkArea() {
        this.workArea = QuarryWorkAreaFunctions.getQuarryWorkArea(this.getBlockPos(), this.placerDirection, this.workArea_width, this.workArea_height, this.workArea_depth);
    }

    private void getWorkAreaDataFromCores() {
        int x = MachineItemUseFunctions.getCoreLevel(this.itemHandler.getStackInSlot(0).getItem());
        int y = MachineItemUseFunctions.getCoreLevel(this.itemHandler.getStackInSlot(1).getItem());
        int z = MachineItemUseFunctions.getCoreLevel(this.itemHandler.getStackInSlot(2).getItem());
        this.workArea_width = x * 2 + 1;
        this.workArea_height = y * 2 + 1;
        this.workArea_depth = z + 1;
        this.machineData._sizeWidthString = "" + this.workArea_width;
        this.machineData._sizeHeightString = "" + this.workArea_height;
        this.machineData._sizeDepthString = "" + this.workArea_depth;
    }

    private ItemStackHandler createItemHandler() {
        return new ItemStackHandler(5){

            protected void onContentsChanged(int slot) {
                tile_entity_quarry.this.setChanged();
                if (slot == 3) {
                    tile_entity_quarry.this.setSpeed();
                } else {
                    tile_entity_quarry.this.getWorkAreaDataFromCores();
                }
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public void updateTickCountsBySpeed() {
        this.idleTickCount = this.maxIdleTicks - this.speed * this.idleSpeedLevelValue;
        this.nextTarget = this.curDelayTicks = this.maxDelayTicks - this.speed * this.speedLevelValue;
    }

    public void sendToClient() {
        if (this.level != null) {
            if (!this.getSeedStack().isEmpty()) {
                this.machineData._mainItemName = BERFunctions.getItemName(this.getSeedStack());
            }
            if (!this.powered) {
                this.machineData._toolTip = "No redstone signal!!";
                this.machineData._toolTipColor = Color.red;
            } else if (this.isDigging) {
                this.machineData._toolTip = "Digging...!!!! ";
                this.machineData._toolTipColor = Color.green;
            } else if (this.isRegenerating) {
                this.machineData._toolTip = "Regenerating...!!!! ";
                this.machineData._toolTipColor = Color.green;
            }
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void tick() {
        if (!this.level.isClientSide) {
            if (!this.isSpeedSet) {
                this.updateTickCountsBySpeed();
                this.isSpeedSet = true;
            }
            if (this.placerDirection == null) {
                this.placerDirection = (Direction)this.level.getBlockState(this.getBlockPos()).getValue(BlockProperties.FACING);
            }
            if (this.workArea == null) {
                this.setSpeed();
                this.getWorkAreaDataFromCores();
                this.setWorkArea();
            }
            if (!this.isDigging && !this.isRegenerating) {
                this.isDigging = true;
            }
            this.sendToClient();
            if (this.level.getDirectSignalTo(this.getBlockPos()) > 0) {
                this.powered = true;
                ++this.curTick;
                if (this.curTick >= this.nextTarget) {
                    if (this.isDigging) {
                        if (this.workAreaIndex > -1 && this.workAreaIndex < this.workArea.size()) {
                            this.absorbBlock(this.workArea.get(this.workAreaIndex));
                            ++this.workAreaIndex;
                        } else {
                            this.isDigging = false;
                            this.isRegenerating = true;
                            --this.workAreaIndex;
                        }
                    }
                    if (this.isRegenerating) {
                        if (this.workAreaIndex > -1 && this.workAreaIndex < this.workArea.size()) {
                            this.regenBlock(this.workArea.get(this.workAreaIndex));
                            --this.workAreaIndex;
                        } else {
                            this.workAreaIndex = 0;
                            this.isDigging = true;
                            this.isRegenerating = false;
                        }
                    }
                    this.nextTarget = this.curDelayTicks;
                    this.curTick = 0;
                    this.tickPerc = 0;
                }
            } else {
                this.powered = false;
            }
        }
    }

    private boolean regenBlock(BlockPos pos) {
        BlockEntity newEntity = this.level.getBlockEntity(pos);
        if (newEntity instanceof tile_entity_amber_block) {
            tile_entity_amber_block amb = (tile_entity_amber_block)newEntity;
            Block toPlace = amb.getBlockToPlace();
            this.level.removeBlock(pos, true);
            this.level.setBlockAndUpdate(pos, toPlace.defaultBlockState());
            this.itemHandler.setStackInSlot(4, new ItemStack((ItemLike)toPlace.asItem()));
            return true;
        }
        return false;
    }

    private List<ItemStack> getBlockDrops(BlockPos pos) {
        ArrayList<ItemStack> res = new ArrayList();
        BlockState curState = this.level.getBlockState(pos);
        res = Block.getDrops((BlockState)curState, (ServerLevel)((ServerLevel)this.level), (BlockPos)pos, (BlockEntity)this.level.getBlockEntity(pos));
        return res;
    }

    private boolean absorbBlock(BlockPos pos) {
        if (this.hasInventoryOnAnySide(pos)) {
            return false;
        }
        if (this.level.getBlockState(pos).getBlock() == Blocks.AIR) {
            return false;
        }
        if (this.level.getBlockState(pos).getBlock() == Blocks.BEDROCK) {
            return false;
        }
        if (this.level.getBlockState(pos).getBlock() == BlockInit.AMBER_BLOCK.get()) {
            return false;
        }
        Block curBlock = this.level.getBlockState(pos).getBlock();
        List<ItemStack> dropList = this.getBlockDrops(pos);
        if (dropList.size() == 0) {
            return false;
        }
        for (ItemStack is : dropList) {
            if (!QdcApi.QDC_CORE.FUNCTIONS.itemHasParticles(is.getItem())) continue;
            if (!MainBox.isItemDiscovered(is.getItem())) {
                DisassemblerFunctions.setItemDiscovered(is.getItem());
            }
            MainBox.DISCOVERY_BOX.increaseItemCount(new DiscoveryItem(is.getItem(), is.getCount()));
            this.itemHandler.setStackInSlot(4, is);
        }
        this.level.removeBlock(pos, true);
        this.level.setBlockAndUpdate(pos, ((AmberBlock)((Object)BlockInit.AMBER_BLOCK.get())).defaultBlockState());
        BlockEntity newEntity = this.level.getBlockEntity(pos);
        if (newEntity instanceof tile_entity_amber_block) {
            tile_entity_amber_block amb = (tile_entity_amber_block)newEntity;
            amb.setSeed(curBlock);
        }
        return true;
    }

    private boolean hasInventoryOnAnySide(BlockPos pos) {
        if (this.checkForInvenotryOnSide(pos, Direction.NORTH)) {
            return true;
        }
        if (this.checkForInvenotryOnSide(pos, Direction.SOUTH)) {
            return true;
        }
        if (this.checkForInvenotryOnSide(pos, Direction.EAST)) {
            return true;
        }
        if (this.checkForInvenotryOnSide(pos, Direction.WEST)) {
            return true;
        }
        if (this.checkForInvenotryOnSide(pos, Direction.UP)) {
            return true;
        }
        return this.checkForInvenotryOnSide(pos, Direction.DOWN);
    }

    private boolean checkForInvenotryOnSide(BlockPos pos, Direction side) {
        IItemHandler blockInventoryHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, pos, (Object)side);
        return blockInventoryHandler != null;
    }

    private void loadSeedItem() {
        if (!this.getSeedStack().isEmpty()) {
            if (this.level != null) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
            this.placeSeedItem = this.getSeedCropBlock(this.getSeedStack());
        } else {
            this.seedParticles = null;
        }
    }

    private Block getSeedCropBlock(ItemStack seedItem) {
        return Block.byItem((Item)seedItem.getItem());
    }

    private void dropStuffs(BlockPos pos) {
        NonNullList list = NonNullList.create();
        list.add((Object)new ItemStack((ItemLike)BlockInit.QUARRY.get()));
        Containers.dropContents((Level)this.level, (BlockPos)pos, (NonNullList)list);
    }

    public void onRemove() {
        this.dropStuffs(this.getBlockPos());
    }

    protected void saveAdditional(CompoundTag output, HolderLookup.Provider provider) {
        output.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        output.putInt("speed", this.speed);
        output.putInt("work_area_index", this.workAreaIndex);
        output.putBoolean("is_digging", this.isDigging);
        output.putBoolean("is_regenerating", this.isRegenerating);
        this.machineData.save(output);
        super.saveAdditional(output, provider);
    }

    protected void loadAdditional(CompoundTag input, HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, input.getCompound("inventory"));
        this.speed = input.getInt("speed");
        this.workAreaIndex = input.getInt("work_area_index");
        this.isDigging = input.getBoolean("is_digging");
        this.isRegenerating = input.getBoolean("is_regenerating");
        this.loadSeedItem();
        this.updateTickCountsBySpeed();
        this.machineData.load(input);
        this.getWorkAreaDataFromCores();
        super.loadAdditional(input, provider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag nbt = super.getUpdateTag(provider);
        this.saveAdditional(nbt, provider);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider holders) {
        super.handleUpdateTag(tag, holders);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

