/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.block_entity_renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.classes.PosePoint;
import com.qdc_mod.qdc_core_4.qdc_core.common.entity.block_entity_rederer.functions.BERFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.tile_entity_quarry;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.classes.BlockProperties;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockInit;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.ItemInit;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class QuarryBlockEntityRenderer
implements BlockEntityRenderer<tile_entity_quarry> {
    private final Color TITLE_COLOR = BERFunctions.COLORS.TITLE_COLOR;
    private final Color TEXT_COLOR = BERFunctions.COLORS.TEXT_COLOR;
    private final Color MAIN_ITEN_NAME_COLOR = BERFunctions.COLORS.MAIN_ITEN_NAME_COLOR;
    private final float PLAYER_ANGLE_OFFSET = -90.0f;
    private final BlockEntityRendererProvider.Context context;
    private float lookToPlayerAngle = 0.0f;
    private String machineName = null;
    private final PosePoint mainIconPos = BERFunctions.POSITIONS.QUARRY.MAIN_ICON_POS;
    private final PosePoint x_sizeIconPos = BERFunctions.POSITIONS.QUARRY.X_SIZE_ICON_POS;
    private final PosePoint y_sizeIconPos = BERFunctions.POSITIONS.QUARRY.Y_SIZE_ICON_POS;
    private final PosePoint z_sizeIconPos = BERFunctions.POSITIONS.QUARRY.Z_SIZE_ICON_POS;
    private final PosePoint speedIconPos = BERFunctions.POSITIONS.QUARRY.SPEED_ICON_POS;
    private final PosePoint x_sizeTitlePos = BERFunctions.POSITIONS.QUARRY.X_SIZE_TITLE_POS;
    private final PosePoint y_sizeTitlePos = BERFunctions.POSITIONS.QUARRY.Y_SIZE_TITLE_POS;
    private final PosePoint z_sizeTitlePos = BERFunctions.POSITIONS.QUARRY.Z_SIZE_TITLE_POS;
    private final PosePoint x_sizeValuePos = BERFunctions.POSITIONS.QUARRY.X_SIZE_VALUE_POS;
    private final PosePoint y_sizeValuePos = BERFunctions.POSITIONS.QUARRY.Y_SIZE_VALUE_POS;
    private final PosePoint z_sizeValuePos = BERFunctions.POSITIONS.QUARRY.Z_SIZE_VALUE_POS;
    private final PosePoint mainItemNamePos = BERFunctions.POSITIONS.QUARRY.MAIN_ITEM_NAME_POS;
    private final PosePoint mainTextPos = BERFunctions.POSITIONS.QUARRY.MAIN_TEXT_POS;
    private final PosePoint machineNamePos = BERFunctions.POSITIONS.QUARRY.MACHINE_NAME_POS;
    private final PosePoint sizeTitlePos = BERFunctions.POSITIONS.QUARRY.SIZE_TITLE_POS;
    private final PosePoint speetTitlePos = BERFunctions.POSITIONS.QUARRY.SPEED_TITLE_POS;
    private final PosePoint speedValuePos = BERFunctions.POSITIONS.QUARRY.SPEED_VALUE_POS;

    public QuarryBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.context = ctx;
    }

    public void render(@NotNull tile_entity_quarry te, float pPartialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        ItemStack mainItemStack = te.getSeedStack();
        ItemStack x_sizeStack = te.itemHandler.getStackInSlot(0);
        ItemStack y_sizeStack = te.itemHandler.getStackInSlot(1);
        ItemStack z_sizeStack = te.itemHandler.getStackInSlot(2);
        ItemStack speedStack = te.itemHandler.getStackInSlot(3);
        Level level = te.getLevel();
        if (level == null) {
            return;
        }
        if (level.getBlockState(te.getBlockPos()).getBlock() != BlockInit.QUARRY.get()) {
            return;
        }
        Direction placerDirection = null;
        if (placerDirection == null) {
            placerDirection = (Direction)level.getBlockState(te.getBlockPos()).getValue(BlockProperties.FACING);
        }
        if (placerDirection == null) {
            return;
        }
        this.machineName = te.machineData._machineName;
        LocalPlayer player = Minecraft.getInstance().player;
        String toolTip = te.machineData._toolTip;
        Color toolTipColor = te.machineData._toolTipColor;
        Font font = this.context.getFont();
        BlockPos pos = te.getBlockPos().above();
        int storage = MainBox.DISCOVERY_BOX.getItemCount(mainItemStack.getItem());
        int packedLight = 240;
        String mainItemName = te.machineData._mainItemName;
        String speedString = te.machineData._speedString;
        this.lookToPlayerAngle = BERFunctions.calcToPlayerAngle((Player)player, pos, -90.0f);
        poseStack.pushPose();
        switch (placerDirection) {
            case DOWN: {
                poseStack.translate(0.5, -0.5, 0.5);
                break;
            }
            case EAST: {
                poseStack.translate(0.5f, 1.5f, 0.5f);
                break;
            }
            case NORTH: {
                poseStack.translate(0.5f, 1.5f, 0.5f);
                break;
            }
            case SOUTH: {
                poseStack.translate(0.5f, 1.5f, 0.5f);
                break;
            }
            case UP: {
                poseStack.translate(0.5f, 1.5f, 0.5f);
                break;
            }
            case WEST: {
                poseStack.translate(0.5f, 1.5f, 0.5f);
                break;
            }
            default: {
                poseStack.translate(0.5f, 1.7f, 0.5f);
            }
        }
        poseStack.mulPose(Axis.YN.rotationDegrees(this.lookToPlayerAngle));
        this.drawBackground(poseStack, pBuffer, level, packedLight);
        poseStack.translate(0.0f, 0.0f, 0.05f);
        float scale = 0.25f;
        poseStack.scale(scale, scale, scale);
        if (mainItemStack != null) {
            BERFunctions.drawIcon(this.mainIconPos, this.context, mainItemStack, poseStack, pBuffer, level, packedLight);
        }
        if (speedStack.getItem() != Items.AIR) {
            BERFunctions.drawIcon(this.speedIconPos, this.context, speedStack, poseStack, pBuffer, level, packedLight);
        }
        scale = 0.7f;
        poseStack.scale(scale, scale, scale);
        if (x_sizeStack.getItem() != Items.AIR) {
            BERFunctions.drawIcon(this.x_sizeIconPos, this.context, x_sizeStack, poseStack, pBuffer, level, packedLight);
        }
        if (y_sizeStack.getItem() != Items.AIR) {
            BERFunctions.drawIcon(this.y_sizeIconPos, this.context, y_sizeStack, poseStack, pBuffer, level, packedLight);
        }
        if (z_sizeStack.getItem() != Items.AIR) {
            BERFunctions.drawIcon(this.z_sizeIconPos, this.context, z_sizeStack, poseStack, pBuffer, level, packedLight);
        }
        scale = 0.036f;
        poseStack.scale(scale, scale, scale);
        poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        BERFunctions.writeText(this.mainTextPos, toolTip, toolTipColor, font, poseStack, pBuffer, packedLight);
        BERFunctions.writeText(this.machineNamePos, this.machineName, this.TITLE_COLOR, font, poseStack, pBuffer, packedLight);
        if (!mainItemName.isEmpty()) {
            BERFunctions.writeText(this.mainItemNamePos, mainItemName, this.MAIN_ITEN_NAME_COLOR, font, poseStack, pBuffer, packedLight);
        }
        BERFunctions.writeText(this.sizeTitlePos, "Size", this.TITLE_COLOR, font, poseStack, pBuffer, packedLight);
        BERFunctions.writeText(this.x_sizeTitlePos, "X", this.TITLE_COLOR, font, poseStack, pBuffer, packedLight);
        BERFunctions.writeText(this.y_sizeTitlePos, "Y", this.TITLE_COLOR, font, poseStack, pBuffer, packedLight);
        BERFunctions.writeText(this.z_sizeTitlePos, "Z", this.TITLE_COLOR, font, poseStack, pBuffer, packedLight);
        BERFunctions.writeText(this.x_sizeValuePos, te.machineData._sizeWidthString, this.TEXT_COLOR, font, poseStack, pBuffer, packedLight);
        BERFunctions.writeText(this.y_sizeValuePos, te.machineData._sizeHeightString, this.TEXT_COLOR, font, poseStack, pBuffer, packedLight);
        BERFunctions.writeText(this.z_sizeValuePos, te.machineData._sizeDepthString, this.TEXT_COLOR, font, poseStack, pBuffer, packedLight);
        BERFunctions.writeText(this.speetTitlePos, "Speed", this.TITLE_COLOR, font, poseStack, pBuffer, packedLight);
        BERFunctions.writeText(this.speedValuePos, speedString, this.TEXT_COLOR, font, poseStack, pBuffer, packedLight);
        poseStack.popPose();
    }

    private void drawBackground(PoseStack poseStack, MultiBufferSource buffer, Level level, int packedLight) {
        this.context.getItemRenderer().renderStatic(new ItemStack((ItemLike)ItemInit.QDC_MACHINE_SCREEN_BG.get()), ItemDisplayContext.FIXED, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffer, level, 0);
    }
}

