/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines;

import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.tile_entity_item_placer;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.classes.BaseTransportBlock;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.classes.BlockProperties;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockEntityInit;
import com.qdc_mod.qdc_core_4.qdc_machines.functions.MachineSoundFunctions;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ItemPlacer
extends BaseTransportBlock
implements EntityBlock {
    public ItemPlacer(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof tile_entity_item_placer) {
            tile_entity_item_placer te = (tile_entity_item_placer)blockEntity;
            te.onRemove();
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.isClientSide) {
            BlockEntity be = level.getBlockEntity(pos);
            tile_entity_item_placer curTileEntity = null;
            if (be instanceof tile_entity_item_placer) {
                tile_entity_item_placer te;
                curTileEntity = te = (tile_entity_item_placer)be;
            }
            if (MachineFunctions.isValidOptionItemPlacer(stack.getItem())) {
                if (curTileEntity.updateSeed(stack.getItem())) {
                    MachineSoundFunctions.playMachineItemInsertedSound(level, pos);
                }
            } else if (MachineFunctions.isValidMachineCore(stack.getItem()) && curTileEntity.addMachineCore(stack.getItem(), 1)) {
                MachineSoundFunctions.playMachineCoreSound(level, pos);
            }
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return BlockProperties.VOXEL_SHAPE;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        if (level.isClientSide) {
            return null;
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof tile_entity_item_placer) {
                tile_entity_item_placer tile = (tile_entity_item_placer)t;
                tile.tick();
            }
        };
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return BlockEntityInit.TILE_ENTITY_ITEM_PLACER.get().create(pos, state);
    }
}

