/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.recycler;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.discovery_box.classes.DiscoveryItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.recycler.RecyclerGuiItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.RecyclerSettings;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.item.Item;

public class RecyclerGuiBox {
    public final int MAX_SLOTS = 24;
    public List<RecyclerGuiItem> itemList = new ArrayList<RecyclerGuiItem>();
    Random random = new Random();
    public RecyclerGuiItem curItemHovered = null;
    ParticleCollection recalibrationParticles = null;

    public boolean handleRecalibrateClick() {
        if (this.recalibrationParticles == null) {
            this.recalibrationParticles = new ParticleCollection();
            this.recalibrationParticles.add(new ParticleItem(ENUMS.ParticleType.CORRUPTION, 10.0));
        }
        if (this.hasData() && QdcApi.QDC_CORE.FUNCTIONS.canRemoveParticles(this.recalibrationParticles)) {
            QdcApi.QDC_CORE.FUNCTIONS.removeParticles(this.recalibrationParticles);
            this.regenerateAllItems();
            return true;
        }
        return false;
    }

    public boolean hasData() {
        return this.itemList.size() > 0;
    }

    public boolean handleItemClick() {
        Item curItem;
        if (this.curItemHovered != null && !this.curItemHovered.isDiscovered && this.curItemHovered.hasEnoughParticles && MainBox.ITEM_BOX.canItemBeDiscovered(curItem = this.curItemHovered.item) && !MainBox.DISCOVERY_BOX.isItemDiscovered(curItem)) {
            ParticleCollection particles = new ParticleCollection();
            particles.add(new ParticleItem(ENUMS.ParticleType.CORRUPTION, this.curItemHovered.corruptionAmount));
            QdcApi.QDC_CORE.FUNCTIONS.removeParticles(particles);
            MainBox.DISCOVERY_BOX.addDiscoveredItem(new DiscoveryItem(curItem, 0));
            Qdc.DisassemblerVariables.addNewDIscoveredItem(curItem);
            MainBox.ITEM_BOX.setDiscovered(curItem, true);
            MainBox.WINDOW_BOX.calcWindowDiscoveries();
            if (this.isTabAllDiscovered()) {
                this.regenerateAllItems();
            } else {
                this.handleDataLoad();
            }
            return true;
        }
        return false;
    }

    public void regenerateAllItems() {
        this.itemList = new ArrayList<RecyclerGuiItem>();
        this.generateRandomUndiscoveredItemsList();
        MainBox.ITEM_BOX.recyclerStorage.setData(this.generateItemLis());
        MainBox.ITEM_BOX.saveData(Qdc.curPlayer);
    }

    public boolean isTabAllDiscovered() {
        for (RecyclerGuiItem item : this.itemList) {
            item.updateDiscovery();
            if (item.isDiscovered) continue;
            return false;
        }
        return true;
    }

    public void checkIfHoveringOver(Point windowPos, int mouseX, int mouseY) {
        this.curItemHovered = null;
        for (RecyclerGuiItem ri : this.itemList) {
            if (!ri.checkIfHoveringOver(windowPos, mouseX, mouseY)) continue;
            this.curItemHovered = ri;
            break;
        }
    }

    public void handleDataLoad() {
        this.itemList = new ArrayList<RecyclerGuiItem>();
        if (MainBox.ITEM_BOX.recyclerStorage.hasData()) {
            int index = 0;
            for (Item item : MainBox.ITEM_BOX.recyclerStorage.storageItems) {
                Point curPos = RecyclerSettings.ITEMS.ITEM_LIST.get(index);
                this.itemList.add(new RecyclerGuiItem(item, MainBox.ITEM_BOX.getItemCorruptionAmount(item), curPos));
                ++index;
            }
            if (this.isTabAllDiscovered()) {
                this.regenerateAllItems();
            }
        } else {
            this.regenerateAllItems();
        }
    }

    private List<Item> generateItemLis() {
        ArrayList<Item> res = new ArrayList<Item>();
        for (RecyclerGuiItem guiItem : this.itemList) {
            res.add(guiItem.item);
        }
        return res;
    }

    public void generateRandomUndiscoveredItemsList() {
        List<Item> allItems = MainBox.ITEM_BOX.getAllUndiscoveredItems();
        for (int i = 0; i < 24; ++i) {
            Item randItem = this.getRandomItem(allItems);
            if (randItem == null) continue;
            Point curPos = RecyclerSettings.ITEMS.ITEM_LIST.get(i);
            this.itemList.add(new RecyclerGuiItem(randItem, MainBox.ITEM_BOX.getItemCorruptionAmount(randItem), curPos));
            allItems.remove(randItem);
        }
    }

    private Item getRandomItem(List<Item> allItems) {
        if (allItems.size() == 0) {
            return null;
        }
        int index = this.random.nextInt(allItems.size());
        return allItems.get(index);
    }
}

