/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines;

import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.functions.MachineFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.common.block_entities.machines.tile_entity_quarry;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.classes.BaseTransportBlock;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.classes.BlockProperties;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.BlockEntityInit;
import com.qdc_mod.qdc_core_4.qdc_machines.functions.MachineItemUseFunctions;
import com.qdc_mod.qdc_core_4.qdc_machines.functions.MachineSoundFunctions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class Quarry
extends BaseTransportBlock
implements EntityBlock {
    public Quarry(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.isClientSide) {
            BlockEntity be = level.getBlockEntity(pos);
            tile_entity_quarry curTileEntity = null;
            if (be instanceof tile_entity_quarry) {
                tile_entity_quarry te;
                curTileEntity = te = (tile_entity_quarry)be;
            }
            if (MachineFunctions.isValidMachineCore(stack.getItem())) {
                Direction machineDir = (Direction)state.getValue(BlockProperties.FACING);
                MachineItemUseFunctions.QuarryCoreType coreType = MachineItemUseFunctions.getQuarrySlot(hit.getLocation(), pos, hit.getDirection(), machineDir);
                if (coreType != null) {
                    int index = MachineItemUseFunctions.getQuarryCoreIndex(coreType);
                    if (curTileEntity.addMachineCore(stack.getItem(), index)) {
                        MachineSoundFunctions.playMachineCoreSound(level, pos);
                    }
                }
            }
        }
        return InteractionResult.CONSUME;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntity) {
        if (level.isClientSide) {
            return null;
        }
        return (lvl, pos, blockState, t) -> {
            if (t instanceof tile_entity_quarry) {
                tile_entity_quarry tile = (tile_entity_quarry)t;
                tile.tick();
            }
        };
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return BlockEntityInit.TILE_ENTITY_QUARRY.get().create(pos, state);
    }
}

