/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_elevator.common.gui.functions;

import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import com.qdc_mod.qdc_core_4.qdc_elevator.boxes.elevator_box.QdcElevatorBox;
import com.qdc_mod.qdc_core_4.qdc_elevator.common.gui.functions.classes.KeyMap;
import java.util.ArrayList;
import java.util.List;

public class KeyInputFunctions {
    public static List<KeyMap> letters = KeyInputFunctions.setupLetterList();

    public static KeyPressResult handleKeyPressElevator(int key) {
        if (Functions.isEscapeKey(key)) {
            return KeyPressResult.ESCAPE;
        }
        if (Functions.isReturnKey(key)) {
            return KeyPressResult.RETURN;
        }
        if (Functions.isBackspaceKey(key)) {
            QdcElevatorBox.elevatorEditString = Functions.removelastChar(QdcElevatorBox.elevatorEditString);
            return KeyPressResult.BACKSPACE;
        }
        if (Functions.isALetter(key) && QdcElevatorBox.elevatorEditString.length() < 14) {
            QdcElevatorBox.elevatorEditString = QdcElevatorBox.elevatorEditString + Functions.getLetter(key);
            GlobalFuncs.msg(key + " " + Functions.getLetter(key) + " " + QdcElevatorBox.elevatorEditString);
            return KeyPressResult.LETTER;
        }
        return KeyPressResult.ERROR;
    }

    public static KeyPressResult handleKeyPressPlatform(int key) {
        if (Functions.isEscapeKey(key)) {
            return KeyPressResult.ESCAPE;
        }
        if (Functions.isReturnKey(key)) {
            return KeyPressResult.RETURN;
        }
        if (Functions.isBackspaceKey(key)) {
            QdcElevatorBox.platformEditString = Functions.removelastChar(QdcElevatorBox.platformEditString);
            return KeyPressResult.BACKSPACE;
        }
        if (Functions.isALetter(key) && QdcElevatorBox.platformEditString.length() < 14) {
            QdcElevatorBox.platformEditString = QdcElevatorBox.platformEditString + Functions.getLetter(key);
            GlobalFuncs.msg(key + " " + Functions.getLetter(key) + " " + QdcElevatorBox.platformEditString);
            return KeyPressResult.LETTER;
        }
        return KeyPressResult.ERROR;
    }

    private static List<KeyMap> setupLetterList() {
        ArrayList<KeyMap> res = new ArrayList<KeyMap>();
        res.add(new KeyMap(65, "A"));
        res.add(new KeyMap(66, "B"));
        res.add(new KeyMap(67, "C"));
        res.add(new KeyMap(68, "D"));
        res.add(new KeyMap(69, "E"));
        res.add(new KeyMap(70, "F"));
        res.add(new KeyMap(71, "G"));
        res.add(new KeyMap(72, "H"));
        res.add(new KeyMap(73, "I"));
        res.add(new KeyMap(74, "J"));
        res.add(new KeyMap(75, "K"));
        res.add(new KeyMap(76, "L"));
        res.add(new KeyMap(77, "M"));
        res.add(new KeyMap(78, "N"));
        res.add(new KeyMap(79, "O"));
        res.add(new KeyMap(80, "P"));
        res.add(new KeyMap(81, "Q"));
        res.add(new KeyMap(82, "R"));
        res.add(new KeyMap(83, "S"));
        res.add(new KeyMap(84, "T"));
        res.add(new KeyMap(85, "U"));
        res.add(new KeyMap(86, "V"));
        res.add(new KeyMap(87, "W"));
        res.add(new KeyMap(88, "X"));
        res.add(new KeyMap(89, "Y"));
        res.add(new KeyMap(90, "Z"));
        res.add(new KeyMap(49, "1"));
        res.add(new KeyMap(50, "2"));
        res.add(new KeyMap(51, "3"));
        res.add(new KeyMap(52, "4"));
        res.add(new KeyMap(53, "5"));
        res.add(new KeyMap(54, "6"));
        res.add(new KeyMap(55, "7"));
        res.add(new KeyMap(56, "8"));
        res.add(new KeyMap(57, "9"));
        res.add(new KeyMap(48, "0"));
        res.add(new KeyMap(32, "_"));
        return res;
    }

    public class Functions {
        public Functions(KeyInputFunctions this$0) {
        }

        public static String removelastChar(String str) {
            if (str.length() == 0) {
                return str;
            }
            return str.substring(0, str.length() - 1);
        }

        public static String getLetter(int key) {
            for (KeyMap km : letters) {
                if (!km.isSame(key)) continue;
                GlobalFuncs.msg(key + " " + km.map);
                return km.map;
            }
            GlobalFuncs.msg(key + " not found");
            return "";
        }

        public static boolean isALetter(int key) {
            for (KeyMap km : letters) {
                if (!km.isSame(key)) continue;
                return true;
            }
            return false;
        }

        public static boolean isEscapeKey(int key) {
            return Functions.isSameKey(key, 256);
        }

        public static boolean isReturnKey(int key) {
            return Functions.isSameKey(key, 257);
        }

        public static boolean isBackspaceKey(int key) {
            return Functions.isSameKey(key, 259);
        }

        private static boolean isSameKey(int key, int constant) {
            return key == constant;
        }
    }

    public static enum KeyPressResult {
        LETTER,
        RETURN,
        ESCAPE,
        BACKSPACE,
        ERROR;

    }

    public class CONSTANTS {
        public static final int ESCAPE_KEY = 256;
        public static final int RETURN_KEY = 257;
        public static final int BACKSPACE_KEY = 259;

        public CONSTANTS(KeyInputFunctions this$0) {
        }
    }
}

