/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_machines.core.init;

import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.CropHarvester;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.CropPlanter;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.Enchanter;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.ItemExtractor;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.ItemPlacer;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.LightMachine;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.MobCloner;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.MobCompressor;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.PotionMachine;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.Quarry;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.Repairer;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.TreeHarvester;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.machines.TreePlanter;
import com.qdc_mod.qdc_core_4.qdc_machines.common.blocks.resin.AmberBlock;
import com.qdc_mod.qdc_core_4.qdc_machines.core.init.ItemInit;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class BlockInit {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"qdc_machines");
    public static final DeferredBlock<CropPlanter> CROP_PLANTER = BlockInit.registerBlock("machine_crop_planter", () -> new CropPlanter(BlockBehaviour.Properties.of().strength(4.0f).explosionResistance(1000000.0f).sound(SoundType.AMETHYST)));
    public static final DeferredBlock<CropHarvester> CROP_HARVESTER = BlockInit.registerBlock("machine_crop_harvester", () -> new CropHarvester(BlockBehaviour.Properties.of().strength(4.0f).explosionResistance(1000000.0f).sound(SoundType.AMETHYST)));
    public static final DeferredBlock<TreePlanter> TREE_PLANTER = BlockInit.registerBlock("machine_tree_planter", () -> new TreePlanter(BlockBehaviour.Properties.of().strength(4.0f).explosionResistance(1000000.0f).sound(SoundType.AMETHYST)));
    public static final DeferredBlock<TreeHarvester> TREE_HARVESTER = BlockInit.registerBlock("machine_tree_harvester", () -> new TreeHarvester(BlockBehaviour.Properties.of().strength(4.0f).explosionResistance(1000000.0f).sound(SoundType.AMETHYST)));
    public static final DeferredBlock<ItemPlacer> ITEM_PLACER = BlockInit.registerBlock("block_item_placer", () -> new ItemPlacer(BlockBehaviour.Properties.of().strength(4.0f).explosionResistance(1000000.0f).sound(SoundType.AMETHYST)));
    public static final DeferredBlock<ItemExtractor> ITEM_EXTRACTOR = BlockInit.registerBlock("block_item_extractor", () -> new ItemExtractor(BlockBehaviour.Properties.of().strength(4.0f).explosionResistance(1000000.0f).sound(SoundType.AMETHYST)));
    public static final DeferredBlock<Quarry> QUARRY = BlockInit.registerBlock("machine_quarry", () -> new Quarry(BlockBehaviour.Properties.of().strength(4.0f).explosionResistance(1000000.0f).sound(SoundType.AMETHYST)));
    public static final DeferredBlock<AmberBlock> AMBER_BLOCK = BlockInit.registerBlock("block_amber", () -> new AmberBlock(BlockBehaviour.Properties.of().strength(4.0f).explosionResistance(1000000.0f).sound(SoundType.AMETHYST).noOcclusion()));
    public static final DeferredBlock<MobCompressor> MOB_COMPRESSOR = BlockInit.registerBlock("mob_compressor", () -> new MobCompressor(BlockBehaviour.Properties.of().strength(4.0f).explosionResistance(1000000.0f).sound(SoundType.AMETHYST).noOcclusion()));
    public static final DeferredBlock<MobCloner> MOB_CLONER = BlockInit.registerBlock("mob_cloner", () -> new MobCloner(BlockBehaviour.Properties.of().strength(4.0f).explosionResistance(1000000.0f).sound(SoundType.AMETHYST).noOcclusion()));
    public static final DeferredBlock<Repairer> REPAIRER = BlockInit.registerBlock("repairer", () -> new Repairer(BlockBehaviour.Properties.of().strength(4.0f).explosionResistance(1000000.0f).sound(SoundType.AMETHYST).noOcclusion()));
    public static final DeferredBlock<Enchanter> ENCHANTER = BlockInit.registerBlock("enchanter", () -> new Enchanter(BlockBehaviour.Properties.of().strength(4.0f).explosionResistance(1000000.0f).sound(SoundType.AMETHYST).noOcclusion()));
    public static final DeferredBlock<PotionMachine> POTION_MACHINE = BlockInit.registerBlock("potion_machine", () -> new PotionMachine(BlockBehaviour.Properties.of().strength(4.0f).explosionResistance(1000000.0f).sound(SoundType.AMETHYST).noOcclusion()));
    public static final DeferredBlock<LightMachine> LIGHT_MACHINE = BlockInit.registerBlock("light_machine", () -> new LightMachine(BlockBehaviour.Properties.of().strength(4.0f).explosionResistance(1000000.0f).sound(SoundType.AMETHYST).noOcclusion()));
    public static final DeferredBlock<Block> QDC_LIGHT_BLOCK = BlockInit.registerBlock("light_block", () -> new Block(BlockBehaviour.Properties.of().sound(SoundType.AMETHYST).noCollission().lightLevel(i -> 15).noOcclusion()));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        BlockInit.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ItemInit.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

