/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.items_init_classes;

import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;

public class ItemIngredients {
    public Item resultItem = null;
    public int resultItemCount = 1;
    public ParticleCollection resultParticleCollection;
    public List<Item> items = null;
    public List<Integer> count = null;
    public List<ParticleCollection> particles = null;

    public ItemIngredients(Item item, int resultItemCount) {
        this.resultItem = item;
        this.resultItemCount = resultItemCount;
        this.items = new ArrayList<Item>();
        this.count = new ArrayList<Integer>();
        this.particles = new ArrayList<ParticleCollection>();
    }

    public boolean isResultItem(Item item) {
        return this.resultItem == item;
    }

    public boolean hasIngredient(Item item) {
        return this.getItemIndex(item) > -1;
    }

    public boolean hasMissingParticles() {
        return this.particles.contains(null);
    }

    public void addIngredient(Item item) {
        int index = this.getItemIndex(item);
        if (index == -1) {
            this.items.add(item);
            this.count.add(1);
            this.particles.add(null);
        } else {
            this.count.set(index, this.count.get(index) + 1);
        }
    }

    private int getItemIndex(Item item) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) != item) continue;
            return i;
        }
        return -1;
    }

    public void updateParticles(ParticleCollection pc, Item item) {
        int index = this.getItemIndex(item);
        this.particles.set(index, pc);
    }

    public ParticleCollection calculateTotalParticles() {
        ParticleCollection coll = new ParticleCollection();
        for (int i = 0; i < this.items.size(); ++i) {
            for (ParticleItem part : this.particles.get((int)i).particleList) {
                coll.add(new ParticleItem(part.type, part.amount * (double)this.count.get(i).intValue()));
            }
        }
        this.resultParticleCollection = this.fixParticlesAccordingResultCount(coll);
        return this.resultParticleCollection;
    }

    private ParticleCollection fixParticlesAccordingResultCount(ParticleCollection oldParticles) {
        ParticleCollection newParticles = new ParticleCollection();
        for (ParticleItem pi : oldParticles.particleList) {
            newParticles.add(new ParticleItem(pi.type, pi.amount / (double)this.resultItemCount));
        }
        return newParticles;
    }
}

