/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleBoxItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.core.init.AttachmentInit;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import java.math.BigDecimal;
import java.util.function.Supplier;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.attachment.AttachmentType;

public class ParticleBox {
    public ParticleBoxItem NATURE = new ParticleBoxItem(ENUMS.ParticleType.NATURE);
    public ParticleBoxItem FOOD = new ParticleBoxItem(ENUMS.ParticleType.FOOD);
    public ParticleBoxItem METAL = new ParticleBoxItem(ENUMS.ParticleType.METAL);
    public ParticleBoxItem GEM = new ParticleBoxItem(ENUMS.ParticleType.GEM);
    public ParticleBoxItem CORRUPTION = new ParticleBoxItem(ENUMS.ParticleType.CORRUPTION);
    public ParticleBoxItem MANA = new ParticleBoxItem(ENUMS.ParticleType.MANA);
    public ParticleBoxItem MANA_MAX = new ParticleBoxItem(ENUMS.ParticleType.MANA_MAX);

    public boolean increaseMana() {
        if (this.MANA.amount.compareTo(this.MANA_MAX.amount) == -1) {
            this.MANA.increment(0.05);
            return true;
        }
        return false;
    }

    public void updateBoxOldAmount() {
        this.NATURE.updateOldAmount();
        this.FOOD.updateOldAmount();
        this.METAL.updateOldAmount();
        this.GEM.updateOldAmount();
    }

    public void unpdateBoxIncrement() {
        this.NATURE.calculateIncrement();
        this.FOOD.calculateIncrement();
        this.METAL.calculateIncrement();
        this.GEM.calculateIncrement();
    }

    public void clear() {
        this.NATURE.amount = new BigDecimal("0");
        this.NATURE.stringVal = "0";
        this.FOOD.amount = new BigDecimal("0");
        this.FOOD.stringVal = "0";
        this.METAL.amount = new BigDecimal("0");
        this.METAL.stringVal = "0";
        this.GEM.amount = new BigDecimal("0");
        this.GEM.stringVal = "0";
        this.CORRUPTION.amount = new BigDecimal("0");
        this.CORRUPTION.stringVal = "0";
        this.MANA.amount = new BigDecimal("0");
        this.MANA.stringVal = "0";
        this.MANA_MAX.amount = new BigDecimal("0");
        this.MANA_MAX.stringVal = "0";
    }

    public int countItemsThatCanBeCreated(ParticleCollection particlesNeeded, ParticleCollection availableParticles, int ignoreManaCount) {
        int canMake = 64;
        if (ignoreManaCount > 0) {
            for (int i = 0; i < particlesNeeded.particleList.size(); ++i) {
                double need;
                double have;
                int curCanMake;
                if (availableParticles.particleList.get((int)i).type == ENUMS.ParticleType.MANA || (curCanMake = (int)((have = availableParticles.particleList.get((int)i).amount) / (need = particlesNeeded.particleList.get((int)i).amount))) >= canMake) continue;
                canMake = curCanMake;
            }
            if (canMake > ignoreManaCount) {
                canMake = ignoreManaCount;
            }
        } else {
            for (int i = 0; i < particlesNeeded.particleList.size(); ++i) {
                double have = availableParticles.particleList.get((int)i).amount;
                double need = particlesNeeded.particleList.get((int)i).amount;
                int curCanMake = (int)(have / need);
                if (curCanMake >= canMake) continue;
                canMake = curCanMake;
            }
        }
        return canMake;
    }

    public void removeParticles(ParticleCollection parts) {
        for (ParticleItem i : parts.particleList) {
            switch (i.type) {
                case NATURE: {
                    this.NATURE.decrement(i.amount);
                    break;
                }
                case FOOD: {
                    this.FOOD.decrement(i.amount);
                    break;
                }
                case METAL: {
                    this.METAL.decrement(i.amount);
                    break;
                }
                case GEM: {
                    this.GEM.decrement(i.amount);
                    break;
                }
                case CORRUPTION: {
                    this.CORRUPTION.decrement(i.amount);
                    break;
                }
                case MANA: {
                    this.MANA.decrement(i.amount);
                    break;
                }
                case MANA_MAX: {
                    this.MANA_MAX.decrement(i.amount);
                    break;
                }
            }
        }
    }

    public void addParticlesLong(ENUMS.ParticleType type, long amount) {
        switch (type) {
            case NATURE: {
                this.NATURE.increment(amount);
                break;
            }
            case FOOD: {
                this.FOOD.increment(amount);
                break;
            }
            case METAL: {
                this.METAL.increment(amount);
                break;
            }
            case GEM: {
                this.GEM.increment(amount);
                break;
            }
            case CORRUPTION: {
                this.CORRUPTION.increment(amount);
                break;
            }
            case MANA: {
                this.MANA.increment(amount);
                break;
            }
            case MANA_MAX: {
                this.MANA_MAX.increment(amount);
                break;
            }
        }
    }

    public void removeParticlesLong(ENUMS.ParticleType type, long amount) {
        switch (type) {
            case NATURE: {
                this.NATURE.decrement(amount);
                break;
            }
            case FOOD: {
                this.FOOD.decrement(amount);
                break;
            }
            case METAL: {
                this.METAL.decrement(amount);
                break;
            }
            case GEM: {
                this.GEM.decrement(amount);
                break;
            }
            case CORRUPTION: {
                this.CORRUPTION.decrement(amount);
                break;
            }
            case MANA: {
                this.MANA.decrement(amount);
                break;
            }
            case MANA_MAX: {
                this.MANA_MAX.decrement(amount);
                break;
            }
        }
    }

    public boolean checkCanRemoveParticles(ParticleCollection parts) {
        boolean hasParticles = true;
        for (ParticleItem i : parts.particleList) {
            switch (i.type) {
                case NATURE: {
                    if (this.NATURE.canDecrement(i.amount)) break;
                    hasParticles = false;
                    break;
                }
                case FOOD: {
                    if (this.FOOD.canDecrement(i.amount)) break;
                    hasParticles = false;
                    break;
                }
                case METAL: {
                    if (this.METAL.canDecrement(i.amount)) break;
                    hasParticles = false;
                    break;
                }
                case GEM: {
                    if (this.GEM.canDecrement(i.amount)) break;
                    hasParticles = false;
                    break;
                }
                case CORRUPTION: {
                    if (this.CORRUPTION.canDecrement(i.amount)) break;
                    hasParticles = false;
                    break;
                }
                case MANA: {
                    if (this.MANA.canDecrement(i.amount)) break;
                    hasParticles = false;
                    break;
                }
            }
        }
        return hasParticles;
    }

    public String getParticleStringShort(ENUMS.ParticleType pt) {
        switch (pt) {
            case NATURE: {
                return this.NATURE.stringVal;
            }
            case FOOD: {
                return this.FOOD.stringVal;
            }
            case METAL: {
                return this.METAL.stringVal;
            }
            case GEM: {
                return this.GEM.stringVal;
            }
            case CORRUPTION: {
                return this.CORRUPTION.stringVal;
            }
            case MANA: {
                return this.MANA.stringVal;
            }
            case MANA_MAX: {
                return this.MANA_MAX.stringVal;
            }
        }
        return "-1";
    }

    public String getParticleStringFormatted(ENUMS.ParticleType pt) {
        switch (pt) {
            case NATURE: {
                return GlobalFuncs.formatNumber(this.NATURE.amount, 0);
            }
            case FOOD: {
                return GlobalFuncs.formatNumber(this.FOOD.amount, 0);
            }
            case METAL: {
                return GlobalFuncs.formatNumber(this.METAL.amount, 0);
            }
            case GEM: {
                return GlobalFuncs.formatNumber(this.GEM.amount, 0);
            }
            case CORRUPTION: {
                return GlobalFuncs.formatNumber(this.CORRUPTION.amount, 0);
            }
            case MANA: {
                return GlobalFuncs.formatNumber(this.MANA.amount, 2);
            }
            case MANA_MAX: {
                return GlobalFuncs.formatNumber(this.MANA_MAX.amount, 0);
            }
        }
        return "-1";
    }

    public String getParticleAmountString(ENUMS.ParticleType pt) {
        switch (pt) {
            case NATURE: {
                return GlobalFuncs.prepareBigDecimalForSave(this.NATURE.amount);
            }
            case FOOD: {
                return GlobalFuncs.prepareBigDecimalForSave(this.FOOD.amount);
            }
            case METAL: {
                return GlobalFuncs.prepareBigDecimalForSave(this.METAL.amount);
            }
            case GEM: {
                return GlobalFuncs.prepareBigDecimalForSave(this.GEM.amount);
            }
            case CORRUPTION: {
                return GlobalFuncs.prepareBigDecimalForSave(this.CORRUPTION.amount);
            }
            case MANA: {
                return GlobalFuncs.prepareBigDecimalForSave(this.MANA.amount);
            }
            case MANA_MAX: {
                return GlobalFuncs.prepareBigDecimalForSave(this.MANA_MAX.amount);
            }
        }
        return "-1";
    }

    public BigDecimal getParticleAmount(ENUMS.ParticleType pt) {
        switch (pt) {
            case NATURE: {
                return this.NATURE.amount;
            }
            case FOOD: {
                return this.FOOD.amount;
            }
            case METAL: {
                return this.METAL.amount;
            }
            case GEM: {
                return this.GEM.amount;
            }
            case CORRUPTION: {
                return this.CORRUPTION.amount;
            }
            case MANA: {
                return this.MANA.amount;
            }
            case MANA_MAX: {
                return this.MANA_MAX.amount;
            }
        }
        return null;
    }

    public int getCreateAmount(ENUMS.ParticleType pt, double particleAmount) {
        switch (pt) {
            case NATURE: {
                return this.NATURE.canCreateCount(particleAmount);
            }
            case FOOD: {
                return this.FOOD.canCreateCount(particleAmount);
            }
            case METAL: {
                return this.METAL.canCreateCount(particleAmount);
            }
            case GEM: {
                return this.GEM.canCreateCount(particleAmount);
            }
            case CORRUPTION: {
                return this.CORRUPTION.canCreateCount(particleAmount);
            }
            case MANA: {
                return this.MANA.canCreateCount(particleAmount);
            }
        }
        return 0;
    }

    public void addParticles(ParticleCollection parts, int count, boolean ignoreMana) {
        for (ParticleItem i : parts.particleList) {
            switch (i.type) {
                case NATURE: {
                    this.NATURE.increment(i.amount, count);
                    break;
                }
                case FOOD: {
                    this.FOOD.increment(i.amount, count);
                    break;
                }
                case METAL: {
                    this.METAL.increment(i.amount, count);
                    break;
                }
                case GEM: {
                    this.GEM.increment(i.amount, count);
                    break;
                }
                case CORRUPTION: {
                    this.CORRUPTION.increment(i.amount, count);
                    break;
                }
                case MANA: {
                    if (ignoreMana) break;
                    this.MANA.increment(i.amount, count);
                    break;
                }
                case MANA_MAX: {
                    this.MANA_MAX.increment(i.amount, count);
                    break;
                }
            }
        }
    }

    public void addParticles(ParticleCollection parts) {
        for (ParticleItem i : parts.particleList) {
            switch (i.type) {
                case NATURE: {
                    this.NATURE.increment(i.amount);
                    break;
                }
                case FOOD: {
                    this.FOOD.increment(i.amount);
                    break;
                }
                case METAL: {
                    this.METAL.increment(i.amount);
                    break;
                }
                case GEM: {
                    this.GEM.increment(i.amount);
                    break;
                }
                case CORRUPTION: {
                    this.CORRUPTION.increment(i.amount);
                    break;
                }
                case MANA: {
                    this.MANA.increment(i.amount);
                    break;
                }
                case MANA_MAX: {
                    this.MANA_MAX.increment(i.amount);
                    break;
                }
            }
        }
    }

    public ParticleCollection cloneParticles(ParticleCollection particles) {
        ParticleCollection res = new ParticleCollection();
        if (particles == null) {
            return null;
        }
        for (ParticleItem item : particles.particleList) {
            res.add(new ParticleItem(item.type, item.amount));
        }
        return res;
    }

    public boolean hasEnoughParticles(ENUMS.ParticleType pt, double amount) {
        switch (pt) {
            case NATURE: {
                return this.NATURE.hasEnoughParticles(amount);
            }
            case FOOD: {
                return this.FOOD.hasEnoughParticles(amount);
            }
            case METAL: {
                return this.METAL.hasEnoughParticles(amount);
            }
            case GEM: {
                return this.GEM.hasEnoughParticles(amount);
            }
            case CORRUPTION: {
                return this.CORRUPTION.hasEnoughParticles(amount);
            }
            case MANA: {
                return this.MANA.hasEnoughParticles(amount);
            }
            case MANA_MAX: {
                return this.MANA_MAX.hasEnoughParticles(amount);
            }
        }
        return false;
    }

    public void loadPlayerParticles(Player player) {
        String natureString = this.getPlayerParticle(player, AttachmentInit.NATURE_PATICLES);
        String foodString = this.getPlayerParticle(player, AttachmentInit.FOOD_PATICLES);
        String metalString = this.getPlayerParticle(player, AttachmentInit.METAL_PATICLES);
        String gemString = this.getPlayerParticle(player, AttachmentInit.GEM_PATICLES);
        String corruptionString = this.getPlayerParticle(player, AttachmentInit.CORRUPTION_PATICLES);
        String manaString = this.getPlayerParticle(player, AttachmentInit.MANA_PATICLES);
        String manaMaxString = this.getPlayerParticle(player, AttachmentInit.MANA_MAX_PATICLES);
        this.setData(ENUMS.ParticleType.NATURE, natureString);
        this.setData(ENUMS.ParticleType.FOOD, foodString);
        this.setData(ENUMS.ParticleType.METAL, metalString);
        this.setData(ENUMS.ParticleType.GEM, gemString);
        this.setData(ENUMS.ParticleType.CORRUPTION, corruptionString);
        this.setData(ENUMS.ParticleType.MANA, manaString);
        this.setData(ENUMS.ParticleType.MANA_MAX, manaMaxString);
    }

    private String getPlayerParticle(Player player, Supplier<AttachmentType<String>> attachment) {
        if (player.hasData(attachment)) {
            String particlesString = (String)player.getData(attachment);
            return particlesString;
        }
        player.setData(attachment, (Object)"0");
        return "0";
    }

    public void setData(ENUMS.ParticleType type, String str) {
        switch (type) {
            case NATURE: {
                this.NATURE.amount = new BigDecimal(str);
                this.NATURE.fixString();
                break;
            }
            case FOOD: {
                this.FOOD.amount = new BigDecimal(str);
                this.FOOD.fixString();
                break;
            }
            case METAL: {
                this.METAL.amount = new BigDecimal(str);
                this.METAL.fixString();
                break;
            }
            case GEM: {
                this.GEM.amount = new BigDecimal(str);
                this.GEM.fixString();
                break;
            }
            case CORRUPTION: {
                this.CORRUPTION.amount = new BigDecimal(str);
                this.CORRUPTION.fixString();
                break;
            }
            case MANA: {
                this.MANA.amount = new BigDecimal(str);
                this.MANA.fixString();
                break;
            }
            case MANA_MAX: {
                if (str.equals("0")) {
                    this.MANA_MAX.amount = new BigDecimal(100);
                    this.MANA_MAX.fixString();
                    break;
                }
                this.MANA_MAX.amount = new BigDecimal(str);
                this.MANA_MAX.fixString();
                break;
            }
        }
    }

    public void saveData(Player player) {
        if (this.NATURE.amount != null) {
            player.setData(AttachmentInit.NATURE_PATICLES, (Object)this.NATURE.amount.toString());
        }
        if (this.FOOD.amount != null) {
            player.setData(AttachmentInit.FOOD_PATICLES, (Object)this.FOOD.amount.toString());
        }
        if (this.METAL.amount != null) {
            player.setData(AttachmentInit.METAL_PATICLES, (Object)this.METAL.amount.toString());
        }
        if (this.GEM.amount != null) {
            player.setData(AttachmentInit.GEM_PATICLES, (Object)this.GEM.amount.toString());
        }
        if (this.CORRUPTION.amount != null) {
            player.setData(AttachmentInit.CORRUPTION_PATICLES, (Object)this.CORRUPTION.amount.toString());
        }
        if (this.MANA.amount != null) {
            player.setData(AttachmentInit.MANA_PATICLES, (Object)this.MANA.amount.toString());
        }
        if (this.MANA_MAX.amount != null) {
            player.setData(AttachmentInit.MANA_MAX_PATICLES, (Object)this.MANA_MAX.amount.toString());
        }
    }
}

