/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class ParticleBoxItem {
    public ENUMS.ParticleType type;
    public BigDecimal amount;
    public BigDecimal old_amount;
    public double increment = 0.0;
    public String stringVal = "";

    public ParticleBoxItem(ENUMS.ParticleType particleType) {
        this.type = particleType;
        this.amount = new BigDecimal("0");
    }

    public void updateOldAmount() {
        if (this.amount != null) {
            this.old_amount = new BigDecimal(this.amount.toString());
        }
    }

    public void calculateIncrement() {
        if (this.old_amount != null) {
            BigDecimal inc = this.amount.subtract(this.old_amount);
            inc = inc.setScale(2, RoundingMode.FLOOR);
            this.increment = inc.doubleValue();
            this.updateOldAmount();
        }
    }

    public void increment(double amount2, int count) {
        BigDecimal add = new BigDecimal(amount2);
        add = add.multiply(new BigDecimal(count));
        this.amount = this.amount.add(add);
        this.fixString();
    }

    public void increment(double amount2) {
        BigDecimal add = new BigDecimal(amount2);
        this.amount = this.amount.add(add);
        this.fixString();
    }

    public void increment(long amount2) {
        BigDecimal add = new BigDecimal(amount2);
        this.amount = this.amount.add(add);
        this.fixString();
    }

    public boolean canDecrement(double amount2) {
        BigDecimal rem = new BigDecimal(amount2);
        int compare = this.amount.compareTo(rem);
        return compare != -1;
    }

    public void decrement(double decrement) {
        BigDecimal rem = new BigDecimal(decrement);
        this.amount = this.amount.subtract(rem);
        this.fixString();
    }

    public void decrement(long decrement) {
        BigDecimal rem = new BigDecimal(decrement);
        this.amount = this.amount.subtract(rem);
        this.fixString();
    }

    public void fixString() {
        this.stringVal = GlobalFuncs.fixString(this.amount);
    }

    public boolean hasEnoughParticles(double particleAmount) {
        int comp = this.amount.compareTo(new BigDecimal(particleAmount));
        return comp > -1;
    }

    public int canCreateCount(double particleAmount) {
        if (particleAmount == 0.0) {
            return 0;
        }
        return this.amount.divide(new BigDecimal(particleAmount), 2, RoundingMode.HALF_DOWN).intValue();
    }
}

