/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import java.util.ArrayList;

public class ParticleCollection {
    public ArrayList<ParticleItem> particleList = new ArrayList();
    public boolean canBeDiscovered = true;

    public void sortParticleItems() {
        ArrayList<ParticleItem> sorted = new ArrayList<ParticleItem>();
        for (ParticleItem pi : this.particleList) {
            if (pi.type != ENUMS.ParticleType.NATURE) continue;
            sorted.add(pi);
        }
        for (ParticleItem pi : this.particleList) {
            if (pi.type != ENUMS.ParticleType.FOOD) continue;
            sorted.add(pi);
        }
        for (ParticleItem pi : this.particleList) {
            if (pi.type != ENUMS.ParticleType.METAL) continue;
            sorted.add(pi);
        }
        for (ParticleItem pi : this.particleList) {
            if (pi.type != ENUMS.ParticleType.GEM) continue;
            sorted.add(pi);
        }
        for (ParticleItem pi : this.particleList) {
            if (pi.type != ENUMS.ParticleType.CORRUPTION) continue;
            sorted.add(pi);
        }
        for (ParticleItem pi : this.particleList) {
            if (pi.type != ENUMS.ParticleType.MANA) continue;
            sorted.add(pi);
        }
        for (ParticleItem pi : this.particleList) {
            if (pi.type != ENUMS.ParticleType.MANA_MAX) continue;
            sorted.add(pi);
        }
        this.particleList = new ArrayList(sorted);
    }

    public void clearManaParticles() {
        for (ParticleItem pi : this.particleList) {
            if (pi.type != ENUMS.ParticleType.MANA) continue;
            pi.amount = 0.0;
        }
    }

    private boolean isParticleTypeSame(ENUMS.ParticleType pt, ParticleCollection pc) {
        int index = this.indexOf(pt);
        if (index > -1) {
            int secondaryIndex = pc.indexOf(pt);
            if (secondaryIndex > -1) {
                return this.particleList.get((int)index).amount == pc.particleList.get((int)secondaryIndex).amount;
            }
            return false;
        }
        int secondaryIndex = pc.indexOf(pt);
        return secondaryIndex <= -1;
    }

    public ParticleCollection multiply(int amount) {
        ParticleCollection res = new ParticleCollection();
        for (int i = 0; i < this.particleList.size(); ++i) {
            ENUMS.ParticleType pt = this.particleList.get((int)i).type;
            double cur = this.particleList.get((int)i).amount;
            double mult = cur * (double)amount;
            res.add(new ParticleItem(pt, mult));
        }
        return res;
    }

    public void add(ParticleItem item, boolean overwrite) {
        if (!overwrite) {
            this.add(item);
        } else {
            int index = this.indexOf(item.type);
            if (index == -1) {
                this.particleList.add(item);
            } else {
                this.particleList.get((int)index).amount = item.amount;
            }
        }
    }

    public void add(ParticleItem item) {
        int index = this.indexOf(item.type);
        if (index == -1) {
            this.particleList.add(item);
        } else {
            this.particleList.get((int)index).amount += item.amount;
        }
    }

    private int indexOf(ENUMS.ParticleType type) {
        for (int i = 0; i < this.particleList.size(); ++i) {
            if (this.particleList.get((int)i).type != type) continue;
            return i;
        }
        return -1;
    }

    public void addOtherParticleCollection(ParticleCollection toAdd, boolean ignoreMana) {
        for (ParticleItem pi : toAdd.particleList) {
            if (ignoreMana) {
                if (pi.type == ENUMS.ParticleType.MANA || pi.type == ENUMS.ParticleType.MANA_MAX) continue;
                this.add(pi);
                GlobalFuncs.msg(String.valueOf((Object)pi.type) + " " + pi.amount);
                continue;
            }
            this.add(pi);
        }
    }

    public boolean isEqualTo(ParticleCollection pc) {
        if (!this.isParticleTypeSame(ENUMS.ParticleType.NATURE, pc)) {
            return false;
        }
        if (!this.isParticleTypeSame(ENUMS.ParticleType.FOOD, pc)) {
            return false;
        }
        if (!this.isParticleTypeSame(ENUMS.ParticleType.METAL, pc)) {
            return false;
        }
        if (!this.isParticleTypeSame(ENUMS.ParticleType.GEM, pc)) {
            return false;
        }
        return this.isParticleTypeSame(ENUMS.ParticleType.MANA, pc);
    }
}

