/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box;

import com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.classes.ResearchMission;
import com.qdc_mod.qdc_core_4.qdc_core.core.init.AttachmentInit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;

public class ResearchMissionBox {
    public List<ResearchMission> researchMissions = new ArrayList<ResearchMission>();
    public static final String separator = "_=_";
    List<String> researchMissionDiscoveryList = null;

    public void addNewMission(ResearchMission newResearchMission) {
        newResearchMission.updateItemsPos();
        this.researchMissions.add(newResearchMission);
    }

    public void updateDiscoveredMissionItem(Item item) {
        for (ResearchMission rm : this.researchMissions) {
            rm.updateDiscoveredItem(item);
        }
    }

    public void addResearchMissionToComplete(String missionName) {
        if (this.researchMissionDiscoveryList == null) {
            this.researchMissionDiscoveryList = new ArrayList<String>();
        }
        this.researchMissionDiscoveryList.add(missionName);
    }

    public boolean isResearchMissionComplete(String missionName) {
        if (this.researchMissionDiscoveryList != null) {
            for (String str : this.researchMissionDiscoveryList) {
                if (!str.equals(missionName)) continue;
                return true;
            }
        }
        return false;
    }

    public void clear() {
        this.researchMissionDiscoveryList = null;
    }

    private List<String> extractDiscoveredResearchMissions(String researchMissionsString) {
        String[] parts = researchMissionsString.split(separator);
        this.researchMissionDiscoveryList = new ArrayList<String>();
        for (String s : parts) {
            if (s == null) continue;
            this.researchMissionDiscoveryList.add(s);
        }
        return this.researchMissionDiscoveryList;
    }

    private String compressDiscoveredResearchMissions() {
        if (this.researchMissionDiscoveryList != null) {
            Object res = "";
            for (String str : this.researchMissionDiscoveryList) {
                res = (String)res + str + separator;
            }
            return res;
        }
        return null;
    }

    public void loadData(Player player) {
        if (player.hasData(AttachmentInit.RESEARCH_MISSION_DISCOVERY)) {
            this.extractDiscoveredResearchMissions((String)player.getData(AttachmentInit.RESEARCH_MISSION_DISCOVERY));
        } else {
            player.setData(AttachmentInit.RESEARCH_MISSION_DISCOVERY, (Object)"");
        }
    }

    public void saveData(Player player) {
        String toSave = this.compressDiscoveredResearchMissions();
        if (toSave != null) {
            player.setData(AttachmentInit.RESEARCH_MISSION_DISCOVERY, (Object)toSave);
        }
    }
}

