/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.classes;

import com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.classes.MissionItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.ResearchMissionBaseSettings;
import com.qdc_mod.qdc_core_4.qdc_core.functions.GuiFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;

public class MissionRequirement_multi {
    public List<MissionItem> itemList = new ArrayList<MissionItem>();
    private int itemIndex = 0;
    public int maxFramesForItemChange = 150;
    public int frameCount = 0;
    public Point pos = null;
    public boolean isHoveringOver;

    public boolean checkIfHoveringOver(Point windowPos, int mouseX, int mouseY) {
        this.isHoveringOver = GuiFunctions.isHoveringOver(windowPos, this.pos, ResearchMissionBaseSettings.CONSTANTS.ITEM.SIZE, new Point(mouseX, mouseY));
        return this.isHoveringOver;
    }

    public void checkIfDiscovered() {
        for (MissionItem mi : this.itemList) {
            mi.checkIfDiscovered();
        }
    }

    public void setPos(Point pos) {
        this.pos = pos;
    }

    public String[] getAllItemNamesList() {
        String[] res = new String[this.itemList.size()];
        for (int i = 0; i < this.itemList.size(); ++i) {
            res[i] = GlobalFuncs.getItemName(this.itemList.get((int)i).item);
        }
        return res;
    }

    public boolean isAnItemDiscovered() {
        for (MissionItem mi : this.itemList) {
            if (!mi.isDiscovered) continue;
            return true;
        }
        return false;
    }

    public void updateDiscoveredItem(Item item) {
        for (MissionItem mi : this.itemList) {
            mi.setDiscoveredIfSameItem(item);
        }
    }

    public void addItem(Item item) {
        this.itemList.add(new MissionItem(item));
    }

    public Item getNextDisplayItem() {
        ++this.frameCount;
        if (this.frameCount >= this.maxFramesForItemChange) {
            ++this.itemIndex;
            if (this.itemIndex >= this.itemList.size()) {
                this.itemIndex = 0;
            }
            this.frameCount = 0;
        }
        return this.itemList.get((int)this.itemIndex).item;
    }

    public boolean isItemInList(Item item) {
        for (MissionItem mi : this.itemList) {
            if (mi.item != item) continue;
            return true;
        }
        return false;
    }
}

