/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.classes;

import com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.classes.MissionItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.classes.MissionRequirement_multi;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.ResearchMissionBaseSettings;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ResearchMission {
    public int numOfRequirementsDicovered = 0;
    public int maxNumOfRequirements = 0;
    public int numOfTargetsDicovered = 0;
    public int maxNumOfTargets = 0;
    public boolean isRequirementsComplete = false;
    public boolean isTargetsComplete = false;
    public String missionName = null;
    public List<MissionItem> mainRequirements = null;
    public List<MissionRequirement_multi> multiRequirements = null;
    public List<MissionItem> discoveryTargets = null;
    public List<ItemStack> rewardItems = null;
    public int manaLimitBonus = 0;
    public int manaBonus = 0;

    public Item getNextRequirement() {
        block3: {
            block2: {
                if (this.mainRequirements == null) break block2;
                for (MissionItem mi : this.mainRequirements) {
                    if (mi.isDiscovered) continue;
                    return mi.item;
                }
                break block3;
            }
            if (this.multiRequirements == null) break block3;
            for (MissionRequirement_multi mi : this.multiRequirements) {
                if (mi.isAnItemDiscovered()) continue;
                return mi.itemList.get((int)0).item;
            }
        }
        return null;
    }

    public Item getNextTarget() {
        if (this.discoveryTargets != null) {
            for (MissionItem mi : this.discoveryTargets) {
                if (mi.isDiscovered) continue;
                return mi.item;
            }
        }
        return null;
    }

    public ResearchMission(String missionName) {
        this.missionName = missionName;
    }

    public void addMainRequirement(Item item) {
        if (this.mainRequirements == null) {
            this.mainRequirements = new ArrayList<MissionItem>();
        }
        if (this.maxNumOfRequirements < 9) {
            this.mainRequirements.add(new MissionItem(item));
            ++this.maxNumOfRequirements;
        }
    }

    public void addMultiRequirement(MissionRequirement_multi req) {
        if (this.multiRequirements == null) {
            this.multiRequirements = new ArrayList<MissionRequirement_multi>();
        }
        if (this.maxNumOfRequirements < 9) {
            this.multiRequirements.add(req);
            ++this.maxNumOfRequirements;
        }
    }

    public void addTarget(Item item) {
        if (this.discoveryTargets == null) {
            this.discoveryTargets = new ArrayList<MissionItem>();
        }
        if (this.discoveryTargets.size() < 9) {
            this.discoveryTargets.add(new MissionItem(item));
            ++this.maxNumOfTargets;
        }
    }

    public void addRewardItem(ItemStack itemStack) {
        if (this.rewardItems == null) {
            this.rewardItems = new ArrayList<ItemStack>();
        }
        if (this.rewardItems.size() < 3) {
            this.rewardItems.add(itemStack);
        }
    }

    public void setManaLimitBonus(int manaLimitBonus) {
        this.manaLimitBonus = manaLimitBonus;
    }

    public void setManaBonus(int manaBonus) {
        this.manaBonus = manaBonus;
    }

    public void checkForItemDiscovery() {
        if (this.mainRequirements != null) {
            for (MissionItem mi : this.mainRequirements) {
                mi.checkIfDiscovered();
            }
        }
        if (this.multiRequirements != null) {
            for (MissionRequirement_multi mrm : this.multiRequirements) {
                if (!mrm.isAnItemDiscovered()) continue;
                ++this.numOfRequirementsDicovered;
            }
        }
        if (this.discoveryTargets != null) {
            for (MissionItem mi : this.discoveryTargets) {
                if (!mi.isDiscovered) continue;
                ++this.numOfTargetsDicovered;
            }
        }
    }

    public void updateDiscoveredItem(Item item) {
        if (this.mainRequirements != null) {
            for (MissionItem mi : this.mainRequirements) {
                mi.setDiscoveredIfSameItem(item);
            }
        }
        if (this.multiRequirements != null) {
            for (MissionRequirement_multi mrm : this.multiRequirements) {
                mrm.updateDiscoveredItem(item);
            }
        }
        if (this.discoveryTargets != null) {
            for (MissionItem mi : this.discoveryTargets) {
                mi.setDiscoveredIfSameItem(item);
            }
        }
        this.countDiscoveries();
    }

    public void countDiscoveries() {
        this.numOfRequirementsDicovered = 0;
        this.numOfTargetsDicovered = 0;
        if (this.mainRequirements != null) {
            for (MissionItem mi : this.mainRequirements) {
                if (!mi.isDiscovered) continue;
                ++this.numOfRequirementsDicovered;
            }
        }
        if (this.multiRequirements != null) {
            for (MissionRequirement_multi mrm : this.multiRequirements) {
                if (!mrm.isAnItemDiscovered()) continue;
                ++this.numOfRequirementsDicovered;
            }
        }
        if (this.discoveryTargets != null) {
            for (MissionItem mi : this.discoveryTargets) {
                if (!mi.isDiscovered) continue;
                ++this.numOfTargetsDicovered;
            }
        }
        if (this.numOfRequirementsDicovered == this.maxNumOfRequirements) {
            this.isRequirementsComplete = true;
        }
        if (this.numOfTargetsDicovered == this.maxNumOfTargets) {
            this.isTargetsComplete = true;
        }
    }

    public Item checkIfHoveringOverItem(Point windowPos, int mouseX, int mouseY) {
        if (this.mainRequirements != null) {
            for (MissionItem mi : this.mainRequirements) {
                if (!mi.checkIfHoveringOver(windowPos, mouseX, mouseY)) continue;
                return mi.item;
            }
        }
        if (this.multiRequirements != null) {
            for (MissionRequirement_multi mrm : this.multiRequirements) {
                if (!mrm.checkIfHoveringOver(windowPos, mouseX, mouseY)) continue;
                return mrm.getNextDisplayItem();
            }
        }
        if (this.discoveryTargets != null && this.isRequirementsComplete) {
            for (MissionItem mi : this.discoveryTargets) {
                if (!mi.checkIfHoveringOver(windowPos, mouseX, mouseY)) continue;
                return mi.item;
            }
        }
        return null;
    }

    public void updateItemsPos() {
        int index = 0;
        if (this.multiRequirements != null) {
            for (MissionRequirement_multi mrm : this.multiRequirements) {
                mrm.setPos(ResearchMissionBaseSettings.MISSION_WINDOW.REQUIRED_DISCOVERIES.LIST.DISCOVERY_LIST.get(index));
                ++index;
            }
        }
        if (this.mainRequirements != null) {
            for (MissionItem mi : this.mainRequirements) {
                mi.setPos(ResearchMissionBaseSettings.MISSION_WINDOW.REQUIRED_DISCOVERIES.LIST.DISCOVERY_LIST.get(index));
                ++index;
            }
        }
        index = 0;
        if (this.discoveryTargets != null) {
            for (MissionItem mi : this.discoveryTargets) {
                mi.setPos(ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_DISCOVERIES.LIST.DISCOVERY_LIST.get(index));
                ++index;
            }
        }
    }
}

