/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.functions;

import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.classes.ResearchMission;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.item.Item;

public class ResearchMissionFunctions {
    public static List<Item> getRewards() {
        Item premiumItem;
        Item freeItem;
        ArrayList<Item> res = new ArrayList<Item>();
        List<ResearchMission> missions = ResearchMissionFunctions.getActiveMissions();
        if (missions.size() == 0) {
            missions = MainBox.RESEARCH_MISSION_BOX.researchMissions;
            ResearchMission randomMission = ResearchMissionFunctions.getRandomMissionFromList(missions);
            freeItem = randomMission.discoveryTargets.get((int)0).item;
            premiumItem = randomMission.rewardItems.get(0).getItem();
        } else {
            ResearchMission randomMission = ResearchMissionFunctions.getRandomMissionFromList(missions);
            freeItem = randomMission.getNextRequirement();
            if (freeItem == null) {
                freeItem = randomMission.getNextTarget();
            }
            premiumItem = randomMission.rewardItems.get(0).getItem();
        }
        res.add(freeItem);
        res.add(premiumItem);
        return res;
    }

    private static ResearchMission getRandomMissionFromList(List<ResearchMission> missions) {
        Random r = new Random();
        int index = r.nextInt(missions.size() - 1);
        return missions.get(index);
    }

    public static List<ResearchMission> getActiveMissions() {
        int i;
        ArrayList<ResearchMission> allAvailableMissions = new ArrayList<ResearchMission>();
        for (ResearchMission rm : MainBox.RESEARCH_MISSION_BOX.researchMissions) {
            rm.checkForItemDiscovery();
            rm.countDiscoveries();
            if (MainBox.RESEARCH_MISSION_BOX.isResearchMissionComplete(rm.missionName)) continue;
            allAvailableMissions.add(rm);
        }
        ArrayList<ResearchMission> completeMissions = new ArrayList<ResearchMission>();
        ArrayList[] requirementsCompleteMissions = new ArrayList[9];
        ArrayList[] requirementsIncompleteMissions = new ArrayList[9];
        for (int i2 = 0; i2 < 9; ++i2) {
            requirementsCompleteMissions[i2] = new ArrayList();
            requirementsIncompleteMissions[i2] = new ArrayList();
        }
        for (ResearchMission rm : allAvailableMissions) {
            if (rm.isRequirementsComplete) {
                if (rm.isTargetsComplete) {
                    completeMissions.add(rm);
                    continue;
                }
                requirementsCompleteMissions[rm.numOfTargetsDicovered].add(rm);
                continue;
            }
            requirementsIncompleteMissions[rm.numOfRequirementsDicovered].add(rm);
        }
        ArrayList<ResearchMission> orderedMissions = new ArrayList<ResearchMission>();
        orderedMissions.addAll(completeMissions);
        for (i = 8; i > -1; --i) {
            orderedMissions.addAll(requirementsCompleteMissions[i]);
        }
        for (i = 8; i > -1; --i) {
            orderedMissions.addAll(requirementsIncompleteMissions[i]);
        }
        return orderedMissions;
    }
}

