/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.assembler;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.item_box.classes.ModItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.assembler.AssemblerItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.assembler.ItemTab;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.AssemblerSettings;
import com.qdc_mod.qdc_core_4.qdc_core.functions.GuiFunctions;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.Item;

public class WindowItem {
    public String name;
    public int totalItems = -1;
    public int discoveryCount = -1;
    public Point pos;
    public boolean isHoveringOver;
    public int tabIndex = 0;
    public int itemIndex = 0;
    public List<ItemTab> itemsTabsList = new ArrayList<ItemTab>();
    public Item iconItem;
    public ItemTab curItemTab = null;
    public int curTabIndex = -1;
    public int tabCount = -1;
    public String displayString = "";

    public WindowItem(Item iconItem, String name, int totalItems, int discoveryCount, List<ModItem> allItems) {
        this.iconItem = iconItem;
        this.name = name;
        this.totalItems = totalItems;
        this.discoveryCount = discoveryCount;
        this.populateItems(allItems);
        this.setDisplayString();
    }

    public boolean handleNextClick() {
        if (this.curTabIndex - 1 < this.itemsTabsList.size() - 1) {
            ++this.curTabIndex;
            this.curItemTab = this.itemsTabsList.get(this.curTabIndex - 1);
            return true;
        }
        return false;
    }

    public boolean handlePrevClick() {
        if (this.curTabIndex > 1) {
            --this.curTabIndex;
            this.curItemTab = this.itemsTabsList.get(this.curTabIndex - 1);
            return true;
        }
        return false;
    }

    public void setDisplayString() {
        this.displayString = this.name + " [" + this.discoveryCount + "/" + this.totalItems + "]";
    }

    public void populateItems(List<ModItem> allItems) {
        for (ModItem item : allItems) {
            if (!item.hasSearchString(Qdc.AssemblerVariables.searchString)) continue;
            if (this.itemsTabsList.size() == 0) {
                this.itemsTabsList.add(new ItemTab());
            }
            if (!this.itemsTabsList.get((int)this.tabIndex).hasSpace) {
                this.itemsTabsList.add(new ItemTab());
                ++this.tabIndex;
                this.itemIndex = 0;
            }
            this.itemsTabsList.get(this.tabIndex).add(new AssemblerItem(item.item, AssemblerSettings.ASSEMBLER_WINDOW.ITEMS.ITEM_POS_LIST.get(this.itemIndex)));
            ++this.itemIndex;
        }
        if (this.itemsTabsList.size() > 0) {
            this.curItemTab = this.itemsTabsList.get(0);
            this.curTabIndex = 1;
            this.tabCount = this.itemsTabsList.size();
        } else {
            this.curTabIndex = -1;
            this.tabCount = -1;
        }
    }

    public void setPosition(Point pos) {
        this.pos = pos;
    }

    public boolean checkIfHoveringOver(Point windowPos, int mouseX, int mouseY) {
        this.isHoveringOver = GuiFunctions.isHoveringOver(windowPos, this.pos, AssemblerSettings.CATEGORY_WINDOW.CATEGORY_LIST.ITEM.SIZE, new Point(mouseX, mouseY));
        return this.isHoveringOver;
    }
}

