/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.converter;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import java.math.BigDecimal;
import net.minecraft.world.item.Item;

public class ParticleCategory {
    public ENUMS.ParticleType type;
    public String name;
    public Item icon;
    public BigDecimal particlesHave;
    public String particleHaveString;
    public int ratio;
    public long transaction;
    public String transactionString;

    public ParticleCategory(ENUMS.ParticleType type, int ratio) {
        this.type = type;
        this.name = String.valueOf((Object)type);
        this.icon = QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(type);
        this.particlesHave = QdcApi.QDC_CORE.FUNCTIONS.getParticleAmountBigDecimal(type);
        this.particleHaveString = QdcApi.QDC_CORE.FUNCTIONS.getParticleAmountShort(type);
        this.ratio = ratio;
        this.setTransaction(0L);
    }

    public boolean haveEnoughParticles(long amount) {
        int res = this.particlesHave.compareTo(new BigDecimal(amount));
        return res > -1;
    }

    public void setTransaction(long transaction) {
        this.transaction = transaction;
        this.transactionString = transaction > 0L ? GlobalFuncs.fixString(new BigDecimal(transaction)) : "0";
    }
}

