/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.GuiDrawFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.ModButton;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.assembler.AssemblerBox;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.assembler.AssemblerItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.assembler.ItemTab;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.assembler.WindowItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.AssemblerSettings;
import com.qdc_mod.qdc_core_4.qdc_core.common.menu.AssemblerMenu;
import com.qdc_mod.qdc_core_4.qdc_core.functions.AssemblerFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AssemblerScreen
extends AbstractContainerScreen<AssemblerMenu> {
    AssemblerBox assemblerBox = new AssemblerBox();
    private List<ItemStack> inventoryItemList = null;
    private final Point WINDOW_SIZE = AssemblerSettings.MAIN_WINDOW.SIZE;
    private final Point WINDOW_POS = new Point(0, 0);
    public List<GuiButton> buttonList = null;
    private btnType curHoverItem = null;
    private Player player;
    private final Point TXT_POS = AssemblerSettings.SEARCH_WINDOW.POS;
    private final Point TXT_SIZE = AssemblerSettings.SEARCH_WINDOW.SIZE;
    EditBox txtSearch;
    private Point titleSize;
    private Point titlePos;
    private final Color windowFillColor;
    private final Color windowBorderColor;
    private final Color BTN_TEXT_COLOR;
    private final Color BTN_TEXT_COLOR_HOVER;
    private final Point SEARCH_POS;
    private final Point SEARCH_SIZE;
    private final Point CATERGORY_WINDOW_POS;
    private final Point CATERGORY_WINDOW_SIZE;
    private final Point CATERGORY_TITLE_POS;
    private final Point CATERGORY_TITLE_SIZE;
    private final Color CATERGORY_TITLE_COLOR;
    private final Point CATERGORY_ITEM_SIZE;
    private final Color CATEGORY_ITEM_FILL;
    private final Color CATEGORY_ITEM_BORDER;
    private final Color CATEGORY_ITEM_BORDER_ACTIVE;
    private final Color CATEGORY_TEXT_COLOR;
    private final Color CATEGORY_TEXT_ACTIVE_COLOR;
    private final List<Point> CATEGORY_POSITION_LIST;
    private final Point TAB_INDEX_POS;
    private final Color TAB_INDEX_TEXT_COLOR;
    private final Point ASSEMBLER_WINDOW_POS;
    private final Point ASSEMBLER_WINDOW_SIZE;
    private final Point ITEM_SIZE;
    private ItemTab curItemTab;
    private final Point ASSEMBLER_TAB_INDEX_POS;
    private final Color ASSEMBLER_TAB_INDEX_TEXT_COLOR;
    private final Point CATEGORY_NAME_POS;
    private final Point CATEGORY_NAME_SIZE;
    private final Color CATEGORY_NAME_COLOR;
    private final Point CATEGORY_ICON_POS;
    private final Color ASSEMBLER_ITEM_BORDER_COLOR;
    private final Color ASSEMBLER_ITEM_BORDER_COLOR_ACTIVE;
    private final Color ASSEMBLER_ITEM_BORDER_COLOR_NOT_DISCOVERED;
    private final Point INFO_WINDOW_POS;
    private final Point INFO_WINDOW_SIZE;
    private final Point INFO_ITEM_NAME_SIZE;
    private final Point INFO_ITEM_NAME_POS;
    private final Color INFO_ITEM_NAME_COLOR;
    private final Point INFO_ITEM_ICON_POS;
    private AssemblerItem curAssemblerItem;
    private String discoveryString;
    private Color infoNameColor;
    private int particleIndex;
    private final Color PARTICLE_FILL_HAVE_ENOUGH;
    private final Color PARTICLE_FILL_NOT_HAVE_ENOUGH;
    private final Color PARTICLES_TEXT_COLOR_HAVE;
    private final Color PARTICLES_TEXT_COLOR_NOT_HAVE;
    private final Point INVENTORY_WINDOW_POS;
    private final Point INVENTORY_WINDOW_SIZE;
    private final Point INVENTORY_TITLE_POS;
    private final Point INVENTORY_TITLE_SIZE;
    private final List<Point> INVENTORY_ITEMS_POS_LIST;
    private Point curInvItemPos;
    private ItemStack curInvItemStack;

    private List<GuiButton> initGuiButtons() {
        ArrayList<GuiButton> res = new ArrayList<GuiButton>();
        res.add(new GuiButton(this, AssemblerSettings.CATEGORY_WINDOW.BUTTONS.PREV.POS, AssemblerSettings.CONSTANTS.BUTTON.SIZE, "Prev", btnType.CATEGORY_PREV));
        res.add(new GuiButton(this, AssemblerSettings.CATEGORY_WINDOW.BUTTONS.NEXT.POS, AssemblerSettings.CONSTANTS.BUTTON.SIZE, "Next", btnType.CATEGORY_NEXT));
        res.add(new GuiButton(this, AssemblerSettings.ASSEMBLER_WINDOW.BUTTONS.PREV.POS, AssemblerSettings.CONSTANTS.BUTTON.SIZE, "Prev", btnType.ASSEMBLER_PREV));
        res.add(new GuiButton(this, AssemblerSettings.ASSEMBLER_WINDOW.BUTTONS.NEXT.POS, AssemblerSettings.CONSTANTS.BUTTON.SIZE, "Next", btnType.ASSEMBLER_NEXT));
        return res;
    }

    public btnType isHoveringOverButton(int mouseX, int mouseY) {
        for (GuiButton b : this.buttonList) {
            if (!b.checkIfHoveringOver(this.WINDOW_POS, mouseX, mouseY)) continue;
            return b.type;
        }
        return null;
    }

    public AssemblerScreen(AssemblerMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.titleSize = new Point(this.WINDOW_SIZE.x, 16);
        this.titlePos = new Point(this.WINDOW_POS.x, this.WINDOW_POS.y - 20);
        this.windowFillColor = Color.pink;
        this.windowBorderColor = Color.white;
        this.BTN_TEXT_COLOR = AssemblerSettings.CONSTANTS.BUTTON.TEXT_COLOR;
        this.BTN_TEXT_COLOR_HOVER = AssemblerSettings.CONSTANTS.BUTTON.TEXT_COLOR_HOVER;
        this.SEARCH_POS = AssemblerSettings.SEARCH_WINDOW.POS;
        this.SEARCH_SIZE = AssemblerSettings.SEARCH_WINDOW.SIZE;
        this.CATERGORY_WINDOW_POS = AssemblerSettings.CATEGORY_WINDOW.POS;
        this.CATERGORY_WINDOW_SIZE = AssemblerSettings.CATEGORY_WINDOW.SIZE;
        this.CATERGORY_TITLE_POS = AssemblerSettings.CATEGORY_WINDOW.TITLE.POS;
        this.CATERGORY_TITLE_SIZE = AssemblerSettings.CATEGORY_WINDOW.TITLE.SIZE;
        this.CATERGORY_TITLE_COLOR = AssemblerSettings.CATEGORY_WINDOW.TITLE.TEXT_COLOR;
        this.CATERGORY_ITEM_SIZE = AssemblerSettings.CATEGORY_WINDOW.CATEGORY_LIST.ITEM.SIZE;
        this.CATEGORY_ITEM_FILL = AssemblerSettings.CATEGORY_WINDOW.CATEGORY_LIST.ITEM.FILL_COLOR;
        this.CATEGORY_ITEM_BORDER = AssemblerSettings.CATEGORY_WINDOW.CATEGORY_LIST.ITEM.BORDER_COLOR;
        this.CATEGORY_ITEM_BORDER_ACTIVE = AssemblerSettings.CATEGORY_WINDOW.CATEGORY_LIST.ITEM.BORDER_HOVER_COLOR;
        this.CATEGORY_TEXT_COLOR = AssemblerSettings.CATEGORY_WINDOW.CATEGORY_LIST.ITEM.TEXT_COLOR;
        this.CATEGORY_TEXT_ACTIVE_COLOR = AssemblerSettings.CATEGORY_WINDOW.CATEGORY_LIST.ITEM.TEXT_HOVER_COLOR;
        this.CATEGORY_POSITION_LIST = AssemblerSettings.CATEGORY_WINDOW.CATEGORY_LIST.CATEGORY_POSITION_LIST;
        this.TAB_INDEX_POS = AssemblerSettings.CATEGORY_WINDOW.TAB_INDEX.POS;
        this.TAB_INDEX_TEXT_COLOR = AssemblerSettings.CATEGORY_WINDOW.TAB_INDEX.TEXT_COLOR;
        this.ASSEMBLER_WINDOW_POS = AssemblerSettings.ASSEMBLER_WINDOW.POS;
        this.ASSEMBLER_WINDOW_SIZE = AssemblerSettings.ASSEMBLER_WINDOW.SIZE;
        this.ITEM_SIZE = AssemblerSettings.ASSEMBLER_WINDOW.ITEMS.SIZE;
        this.curItemTab = null;
        this.ASSEMBLER_TAB_INDEX_POS = AssemblerSettings.ASSEMBLER_WINDOW.TAB_INDEX.POS;
        this.ASSEMBLER_TAB_INDEX_TEXT_COLOR = AssemblerSettings.ASSEMBLER_WINDOW.TAB_INDEX.TEXT_COLOR;
        this.CATEGORY_NAME_POS = AssemblerSettings.ASSEMBLER_WINDOW.CATEGORY.NAME.POS;
        this.CATEGORY_NAME_SIZE = AssemblerSettings.ASSEMBLER_WINDOW.CATEGORY.NAME.SIZE;
        this.CATEGORY_NAME_COLOR = AssemblerSettings.ASSEMBLER_WINDOW.CATEGORY.NAME.COLOR;
        this.CATEGORY_ICON_POS = AssemblerSettings.ASSEMBLER_WINDOW.CATEGORY.ICON.POS;
        this.ASSEMBLER_ITEM_BORDER_COLOR = AssemblerSettings.ASSEMBLER_WINDOW.ITEMS.BORDER_COLOR;
        this.ASSEMBLER_ITEM_BORDER_COLOR_ACTIVE = AssemblerSettings.ASSEMBLER_WINDOW.ITEMS.BORDER_COLOR_ACTIVE;
        this.ASSEMBLER_ITEM_BORDER_COLOR_NOT_DISCOVERED = AssemblerSettings.ASSEMBLER_WINDOW.ITEMS.BORDER_COLOR_NOT_DISCOVERED;
        this.INFO_WINDOW_POS = AssemblerSettings.INFO_WINDOW.POS;
        this.INFO_WINDOW_SIZE = AssemblerSettings.INFO_WINDOW.SIZE;
        this.INFO_ITEM_NAME_SIZE = AssemblerSettings.INFO_WINDOW.NAME.SIZE;
        this.INFO_ITEM_NAME_POS = AssemblerSettings.INFO_WINDOW.NAME.POS;
        this.INFO_ITEM_NAME_COLOR = AssemblerSettings.INFO_WINDOW.NAME.COLOR;
        this.INFO_ITEM_ICON_POS = AssemblerSettings.INFO_WINDOW.ICON.POS;
        this.discoveryString = "";
        this.particleIndex = -1;
        this.PARTICLE_FILL_HAVE_ENOUGH = AssemblerSettings.INFO_WINDOW.PARTICLES.COLOR_HAVE_ENOUGH;
        this.PARTICLE_FILL_NOT_HAVE_ENOUGH = AssemblerSettings.INFO_WINDOW.PARTICLES.COLOR_NOT_HAVE_ENOUGH;
        this.PARTICLES_TEXT_COLOR_HAVE = AssemblerSettings.INFO_WINDOW.PARTICLES.TEXT_COLOR_HAVE;
        this.PARTICLES_TEXT_COLOR_NOT_HAVE = AssemblerSettings.INFO_WINDOW.PARTICLES.TEXT_COLOR_NOT_HAVE;
        this.INVENTORY_WINDOW_POS = AssemblerSettings.INVENTORY.POS;
        this.INVENTORY_WINDOW_SIZE = AssemblerSettings.INVENTORY.SIZE;
        this.INVENTORY_TITLE_POS = AssemblerSettings.INVENTORY.TITLE.POS;
        this.INVENTORY_TITLE_SIZE = AssemblerSettings.INVENTORY.TITLE.SIZE;
        this.INVENTORY_ITEMS_POS_LIST = AssemblerSettings.INVENTORY.INVENTORY_ITEMS_POS_LIST;
        this.player = inv.player;
    }

    protected void init() {
        super.init();
        this.WINDOW_POS.x = this.width / 2 - this.WINDOW_SIZE.x / 2;
        this.WINDOW_POS.y = this.height / 2 - this.WINDOW_SIZE.y / 2;
        this.txtSearch = new EditBox(this.font, this.WINDOW_POS.x + this.TXT_POS.x, this.WINDOW_POS.y + this.TXT_POS.y, this.TXT_SIZE.x, this.TXT_SIZE.y, (Component)Component.literal((String)"txtSearch"));
        this.txtSearch.setCanLoseFocus(false);
        this.txtSearch.setTextColor(Color.white.getRGB());
        this.txtSearch.setBordered(true);
        this.txtSearch.setMaxLength(20);
        this.txtSearch.setResponder(this::onSearchChanged);
        this.txtSearch.setValue(Qdc.AssemblerVariables.searchString);
        this.addRenderableWidget((GuiEventListener)this.txtSearch);
        this.txtSearch.setEditable(true);
        if (this.buttonList == null) {
            this.buttonList = this.initGuiButtons();
        }
        this.loadInventoryItems();
        MainBox.WINDOW_BOX.calcWindowDiscoveries();
    }

    public void onSearchChanged(String search) {
        Qdc.AssemblerVariables.searchString = search;
        this.assemblerBox.doSearch();
    }

    protected void setInitialFocus() {
        this.setInitialFocus((GuiEventListener)this.txtSearch);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.minecraft.player.closeContainer();
        }
        return !this.txtSearch.keyPressed(keyCode, scanCode, modifiers) && !this.txtSearch.canConsumeInput() ? super.keyPressed(keyCode, scanCode, modifiers) : true;
    }

    public void removed() {
        super.removed();
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void render(GuiGraphics GuiGraphics2, int mouseX, int mouseY, float partialTicks) {
        super.render(GuiGraphics2, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics GuiGraphics2, float partialTicks, int x, int y) {
        this.WINDOW_POS.x = this.width / 2 - this.WINDOW_SIZE.x / 2;
        this.WINDOW_POS.y = this.height / 2 - this.WINDOW_SIZE.y / 2;
        this.drawWindowTitle(GuiGraphics2);
        this.drawMainWindow(GuiGraphics2);
        this.curHoverItem = this.isHoveringOverButton(x, y);
        this.assemblerBox.checkIfHoveringOver(this.WINDOW_POS, x, y);
    }

    private void drawWindowTitle(GuiGraphics GuiGraphics2) {
        this.drawWindowTitle(GuiGraphics2, this.titlePos, this.titleSize, "Item Assembler");
    }

    public void drawMainWindow(GuiGraphics gg) {
        this.drawSearchSection(gg);
        this.drawCategorySection(gg);
        this.drawAssemblerSection(gg);
        this.drawInfoSection(gg);
        this.drawInventorySection(gg);
        this.drawButtons(gg);
    }

    public void drawButtons(GuiGraphics gg) {
        for (GuiButton button : this.buttonList) {
            if (this.curHoverItem == button.type) {
                this.drawButton(gg, button.pos, button.size, true);
                this.writeStringCentred(gg, button.text, button.pos.x + 20, button.pos.y + 2, this.BTN_TEXT_COLOR_HOVER);
                continue;
            }
            this.drawButton(gg, button.pos, button.size, false);
            this.writeStringCentred(gg, button.text, button.pos.x + 20, button.pos.y + 2, this.BTN_TEXT_COLOR);
        }
    }

    public void drawSearchSection(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, this.SEARCH_POS, this.SEARCH_SIZE, this.windowFillColor, this.windowBorderColor);
    }

    public void drawCategorySection(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, this.CATERGORY_WINDOW_POS, this.CATERGORY_WINDOW_SIZE, this.windowFillColor, this.windowBorderColor);
        this.drawRectangleWithBorder(gg, this.CATERGORY_TITLE_POS, this.CATERGORY_TITLE_SIZE, this.windowFillColor, this.windowBorderColor);
        this.writeString(gg, "Discoveries: " + MainBox.WINDOW_BOX.totalDiscoverdItems + "/" + MainBox.WINDOW_BOX.totalDiscoveryItems, this.CATERGORY_TITLE_POS.x + 3, this.CATERGORY_TITLE_POS.y + 3, this.CATERGORY_TITLE_COLOR);
        this.writeStringCentred(gg, this.assemblerBox.curWindowTabIndex + "/" + this.assemblerBox.windowTabCount, this.TAB_INDEX_POS.x, this.TAB_INDEX_POS.y, this.TAB_INDEX_TEXT_COLOR);
        if (this.assemblerBox.curWindowTab != null) {
            for (int i = 0; i < this.assemblerBox.curWindowTab.windowList.size(); ++i) {
                WindowItem wi = this.assemblerBox.curWindowTab.windowList.get(i);
                if (wi.isHoveringOver) {
                    this.drawRectangleWithBorder(gg, this.CATEGORY_POSITION_LIST.get(i), this.CATERGORY_ITEM_SIZE, this.CATEGORY_ITEM_FILL, this.CATEGORY_ITEM_BORDER_ACTIVE);
                    this.writeString(gg, wi.displayString, this.CATEGORY_POSITION_LIST.get((int)i).x + 18, this.CATEGORY_POSITION_LIST.get((int)i).y + 4, this.CATEGORY_TEXT_ACTIVE_COLOR);
                } else {
                    this.drawRectangleWithBorder(gg, this.CATEGORY_POSITION_LIST.get(i), this.CATERGORY_ITEM_SIZE, this.CATEGORY_ITEM_FILL, this.CATEGORY_ITEM_BORDER);
                    this.writeString(gg, wi.displayString, this.CATEGORY_POSITION_LIST.get((int)i).x + 18, this.CATEGORY_POSITION_LIST.get((int)i).y + 4, this.CATEGORY_TEXT_COLOR);
                }
                this.drawItemIcon(gg, wi.iconItem, this.CATEGORY_POSITION_LIST.get((int)i).x, this.CATEGORY_POSITION_LIST.get((int)i).y);
            }
        }
    }

    public void drawAssemblerSection(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, this.ASSEMBLER_WINDOW_POS, this.ASSEMBLER_WINDOW_SIZE, this.windowFillColor, this.windowBorderColor);
        this.drawRectangleWithBorder(gg, this.ASSEMBLER_WINDOW_POS, this.CATEGORY_NAME_SIZE, this.windowFillColor, this.windowBorderColor);
        if (this.assemblerBox.curWindowTab != null) {
            if (this.assemblerBox.curWindowTab.curWindow != null) {
                this.writeString(gg, this.assemblerBox.curWindowTab.curWindow.displayString, this.CATEGORY_NAME_POS.x, this.CATEGORY_NAME_POS.y, this.CATEGORY_NAME_COLOR);
                this.drawItemIcon(gg, this.assemblerBox.curWindowTab.curWindow.iconItem, this.CATEGORY_ICON_POS.x, this.CATEGORY_ICON_POS.y);
                this.writeStringCentred(gg, this.assemblerBox.curWindowTab.curWindow.curTabIndex + "/" + this.assemblerBox.curWindowTab.curWindow.tabCount, this.ASSEMBLER_TAB_INDEX_POS.x, this.ASSEMBLER_TAB_INDEX_POS.y, this.ASSEMBLER_TAB_INDEX_TEXT_COLOR);
            } else {
                this.writeStringCentred(gg, "0/0", this.ASSEMBLER_TAB_INDEX_POS.x, this.ASSEMBLER_TAB_INDEX_POS.y, this.ASSEMBLER_TAB_INDEX_TEXT_COLOR);
            }
        } else {
            this.writeStringCentred(gg, "0/0", this.ASSEMBLER_TAB_INDEX_POS.x, this.ASSEMBLER_TAB_INDEX_POS.y, this.ASSEMBLER_TAB_INDEX_TEXT_COLOR);
        }
        if (this.assemblerBox.curWindowTab != null && this.assemblerBox.curWindowTab.curWindow != null && this.assemblerBox.curWindowTab.curWindow.curItemTab != null) {
            this.curItemTab = this.assemblerBox.curWindowTab.curWindow.curItemTab;
            for (AssemblerItem ti : this.curItemTab.itemList) {
                if (ti.isDiscovered) {
                    if (ti.isHoveringOver) {
                        this.drawRectangleWithBorder(gg, ti.pos, this.ITEM_SIZE, this.windowFillColor, this.ASSEMBLER_ITEM_BORDER_COLOR_ACTIVE);
                        this.drawItemIcon(gg, ti.item, ti.pos.x + 1, ti.pos.y + 1);
                        continue;
                    }
                    this.drawRectangleWithBorder(gg, ti.pos, this.ITEM_SIZE, this.windowFillColor, this.ASSEMBLER_ITEM_BORDER_COLOR);
                    this.drawItemIcon(gg, ti.item, ti.pos.x + 1, ti.pos.y + 1);
                    continue;
                }
                this.drawRectangleWithBorder(gg, ti.pos, this.ITEM_SIZE, this.ASSEMBLER_ITEM_BORDER_COLOR_NOT_DISCOVERED, this.ASSEMBLER_ITEM_BORDER_COLOR_NOT_DISCOVERED);
                this.drawItemIcon(gg, ti.item, ti.pos.x + 1, ti.pos.y + 1);
            }
        }
    }

    public void drawInfoSection(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, this.INFO_WINDOW_POS, this.INFO_WINDOW_SIZE, this.windowFillColor, this.windowBorderColor);
        this.drawRectangleWithBorder(gg, this.INFO_WINDOW_POS, this.INFO_ITEM_NAME_SIZE, this.windowFillColor, this.windowBorderColor);
        if (this.assemblerBox.curWindowTab != null && this.assemblerBox.curWindowTab.curWindow != null && this.assemblerBox.curWindowTab.curWindow.curItemTab != null) {
            if (this.assemblerBox.curWindowTab.curWindow.curItemTab.curItemHovered != null) {
                this.curAssemblerItem = this.assemblerBox.curWindowTab.curWindow.curItemTab.curItemHovered;
                this.curAssemblerItem.update();
                this.generateDiscoveryString();
                this.writeString(gg, this.curAssemblerItem.name + this.discoveryString, this.INFO_ITEM_NAME_POS.x, this.INFO_ITEM_NAME_POS.y, this.infoNameColor);
                this.drawItemIcon(gg, this.curAssemblerItem.item, this.INFO_ITEM_ICON_POS.x, this.INFO_ITEM_ICON_POS.y);
                this.particleIndex = 0;
                for (ParticleItem pi : this.curAssemblerItem.particles.particleList) {
                    if (pi.type != ENUMS.ParticleType.MANA) {
                        this.drawParticleSegment(gg, pi.type, pi.canCreate, pi.amount);
                    } else if (this.curAssemblerItem.isInStorage) {
                        this.drawParticleStorageSegment(gg, this.curAssemblerItem.storage);
                    } else {
                        this.drawParticleSegment(gg, pi.type, pi.canCreate, pi.amount);
                    }
                    ++this.particleIndex;
                }
            } else {
                this.writeString(gg, "Left Click: Assemble 1 item.", this.INFO_ITEM_NAME_POS.x, this.INFO_ITEM_NAME_POS.y + 20, Color.white);
                this.writeString(gg, "Right Click: Assemble whole stack.", this.INFO_ITEM_NAME_POS.x, this.INFO_ITEM_NAME_POS.y + 35, Color.white);
            }
        }
    }

    private void drawParticleSegment(GuiGraphics gg, ENUMS.ParticleType type, boolean canCreate, double amount) {
        Point curPos = AssemblerSettings.INFO_WINDOW.PARTICLES.PARTICLE_POS_LIST.get(this.particleIndex);
        if (canCreate) {
            this.drawRectangleWithBorder(gg, curPos, AssemblerSettings.INFO_WINDOW.PARTICLES.SIZE, this.PARTICLE_FILL_HAVE_ENOUGH, this.windowBorderColor);
            this.writeString(gg, GlobalFuncs.fixDouble(amount), curPos.x + 18, curPos.y + 3, this.PARTICLES_TEXT_COLOR_HAVE);
        } else {
            this.drawRectangleWithBorder(gg, curPos, AssemblerSettings.INFO_WINDOW.PARTICLES.SIZE, this.PARTICLE_FILL_NOT_HAVE_ENOUGH, this.windowBorderColor);
            this.writeString(gg, GlobalFuncs.fixDouble(amount), curPos.x + 18, curPos.y + 3, this.PARTICLES_TEXT_COLOR_NOT_HAVE);
        }
        this.drawItemIcon(gg, QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(type), curPos.x + 1, curPos.y + 1);
    }

    private void drawParticleStorageSegment(GuiGraphics gg, int storage) {
        Point curPos = AssemblerSettings.INFO_WINDOW.PARTICLES.PARTICLE_POS_LIST.get(this.particleIndex);
        this.drawRectangleWithBorder(gg, curPos, AssemblerSettings.INFO_WINDOW.PARTICLES.SIZE, this.PARTICLE_FILL_HAVE_ENOUGH, this.windowBorderColor);
        this.writeString(gg, "" + storage, curPos.x + 18, curPos.y + 3, this.PARTICLES_TEXT_COLOR_HAVE);
        this.drawItemIcon(gg, Items.CHEST, curPos.x + 1, curPos.y + 1);
    }

    private void generateDiscoveryString() {
        if (this.curAssemblerItem.isDiscovered) {
            this.infoNameColor = Color.green;
            this.discoveryString = "";
        } else {
            this.discoveryString = " (Undiscovered)";
            this.infoNameColor = Color.red;
        }
    }

    public void drawInventorySection(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, this.INVENTORY_WINDOW_POS, this.INVENTORY_WINDOW_SIZE, this.windowFillColor, this.windowBorderColor);
        this.drawRectangleWithBorder(gg, this.INVENTORY_WINDOW_POS, this.INVENTORY_TITLE_SIZE, this.windowFillColor, this.windowBorderColor);
        this.writeString(gg, "Inventory", this.INVENTORY_TITLE_POS.x + 10, this.INVENTORY_TITLE_POS.y + 3, this.windowBorderColor);
        for (int i = 0; i < this.INVENTORY_ITEMS_POS_LIST.size(); ++i) {
            this.curInvItemPos = this.INVENTORY_ITEMS_POS_LIST.get(i);
            this.curInvItemStack = this.inventoryItemList.get(i);
            this.drawItemIcon(gg, this.curInvItemStack.getItem(), this.curInvItemPos.x, this.curInvItemPos.y, this.curInvItemStack.getCount());
        }
    }

    private void loadInventoryItems() {
        this.inventoryItemList = AssemblerFunctions.getPlayerInventoryItems(Qdc.curPlayer);
    }

    private void drawButton(GuiGraphics gg, Point pos, Point size, boolean isActive) {
        GuiDrawFunctions.drawButton(gg, this.WINDOW_POS, pos, size, isActive);
    }

    protected void renderLabels(GuiGraphics p_230451_1_, int p_230451_2_, int p_230451_3_) {
    }

    public void drawWindowTitle(GuiGraphics gg, Point pos, Point size, String text) {
        GuiDrawFunctions.drawWindowTitle(gg, this.WINDOW_POS, pos, size, this.font, text);
    }

    private void drawItemIcon(GuiGraphics gg, Item item, int x, int y) {
        GuiDrawFunctions.drawItemIcon(gg, this.font, this.WINDOW_POS, item, x, y);
    }

    private void drawItemIcon(GuiGraphics gg, Item item, int x, int y, int count) {
        GuiDrawFunctions.drawItemIcon(gg, this.font, this.WINDOW_POS, item, x, y, count);
    }

    private void drawRectangleWithBorder(GuiGraphics gg, Point pos, Point size, Color fillColor, Color borderColor) {
        GuiDrawFunctions.drawRectangleWithBorder(gg, this.WINDOW_POS, pos, size, fillColor, borderColor);
    }

    private void drawRectangle(GuiGraphics gg, int xPos, int yPos, int width, int height, Color color) {
        GuiDrawFunctions.drawRectangle(gg, this.WINDOW_POS, xPos, yPos, width, height, color);
    }

    private void writeString(GuiGraphics gg, String text, int x, int y, Color color) {
        GuiDrawFunctions.writeString(gg, this.font, this.WINDOW_POS, text, x, y, color);
    }

    private void writeStringCentred(GuiGraphics gg, String text, int x, int y, Color color) {
        GuiDrawFunctions.writeStringCentred(gg, this.font, this.WINDOW_POS, text, x, y, color);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.curHoverItem != null) {
            switch (this.curHoverItem.ordinal()) {
                case 1: {
                    if (!this.assemblerBox.handleNextClick()) break;
                    this.playClickSound();
                    break;
                }
                case 0: {
                    if (!this.assemblerBox.handlePrevClick()) break;
                    this.playClickSound();
                    break;
                }
                case 3: {
                    if (this.assemblerBox.curWindowTab == null || this.assemblerBox.curWindowTab.curWindow == null || !this.assemblerBox.curWindowTab.curWindow.handleNextClick()) break;
                    this.playClickSound();
                    break;
                }
                case 2: {
                    if (this.assemblerBox.curWindowTab == null || this.assemblerBox.curWindowTab.curWindow == null || !this.assemblerBox.curWindowTab.curWindow.handlePrevClick()) break;
                    this.playClickSound();
                    break;
                }
            }
        }
        if (this.assemblerBox.curWindowTab != null && this.assemblerBox.curWindowTab.curWindowItemHover != null) {
            this.assemblerBox.handleCategoryClick();
            this.playClickSound();
        }
        if (this.assemblerBox.curWindowTab != null && this.assemblerBox.curWindowTab.curWindow != null && this.assemblerBox.curWindowTab.curWindow.curItemTab != null && this.assemblerBox.curWindowTab.curWindow.curItemTab.curItemHovered != null && this.curAssemblerItem.isDiscovered) {
            if (button == 0) {
                if (AssemblerFunctions.handleItemAssembleClick(this.curAssemblerItem, false)) {
                    this.loadInventoryItems();
                    this.playClickSound();
                }
            } else if (AssemblerFunctions.handleItemAssembleClick(this.curAssemblerItem, true)) {
                this.loadInventoryItems();
                this.playClickSound();
            }
        }
        return false;
    }

    private void playClickSound() {
        this.player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.5f, 1.0f);
    }

    public class GuiButton
    extends ModButton {
        public btnType type;

        public GuiButton(AssemblerScreen this$0, Point pos, Point size, String text, btnType type) {
            super(pos, size, text);
            this.type = type;
        }
    }

    public static enum btnType {
        CATEGORY_PREV,
        CATEGORY_NEXT,
        ASSEMBLER_PREV,
        ASSEMBLER_NEXT;

    }
}

