/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen;

import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.classes.MissionItem;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.research_missions_box.classes.MissionRequirement_multi;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.GuiDrawFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.ModButton;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.research_mission_base.MisssionLIstGuiItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.research_mission_base.ResearchBox;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.research_mission_base.ResearchMissionListItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.AssemblerSettings;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.ResearchMissionBaseSettings;
import com.qdc_mod.qdc_core_4.qdc_core.common.menu.ResearchMissionBaseMenu;
import com.qdc_mod.qdc_core_4.qdc_core.global.GlobalFuncs;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ResearchMissionBaseScreen
extends AbstractContainerScreen<ResearchMissionBaseMenu> {
    private final Point WINDOW_SIZE = AssemblerSettings.MAIN_WINDOW.SIZE;
    private final Point WINDOW_POS = new Point(0, 0);
    private ResearchBox researchBox = new ResearchBox();
    public List<GuiButton> buttonList = null;
    private btnType curHoverItem = null;
    private Player player;
    private Point titleSize;
    private Point titlePos;
    private final MissionListWindow missionListWindow;
    private final MissionWindow missionWindow;
    private final Color windowFillColor;
    private final Color windowBorderColor;
    private final Color BTN_TEXT_COLOR;
    private final Color BTN_TEXT_COLOR_HOVER;

    private List<GuiButton> initGuiButtons() {
        ArrayList<GuiButton> res = new ArrayList<GuiButton>();
        res.add(new GuiButton(this, ResearchMissionBaseSettings.MISSION_LIST_WINDOW.BUTTONS.PREV.POS, ResearchMissionBaseSettings.CONSTANTS.BUTTON.SIZE, "Prev", btnType.PREV));
        res.add(new GuiButton(this, ResearchMissionBaseSettings.MISSION_LIST_WINDOW.BUTTONS.NEXT.POS, ResearchMissionBaseSettings.CONSTANTS.BUTTON.SIZE, "Next", btnType.NEXT));
        res.add(new GuiButton(this, ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.CLAIM_BUTTON.POS, ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.CLAIM_BUTTON.SIZE, "Claim Rewards!", btnType.CLAIM));
        return res;
    }

    public btnType isHoveringOverButton(int mouseX, int mouseY) {
        for (GuiButton b : this.buttonList) {
            if (!b.checkIfHoveringOver(this.WINDOW_POS, mouseX, mouseY)) continue;
            return b.type;
        }
        return null;
    }

    public ResearchMissionBaseScreen(ResearchMissionBaseMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.titleSize = new Point(this.WINDOW_SIZE.x, 16);
        this.titlePos = new Point(this.WINDOW_POS.x, this.WINDOW_POS.y - 20);
        this.missionListWindow = new MissionListWindow();
        this.missionWindow = new MissionWindow();
        this.windowFillColor = Color.pink;
        this.windowBorderColor = Color.white;
        this.BTN_TEXT_COLOR = ResearchMissionBaseSettings.CONSTANTS.BUTTON.TEXT_COLOR;
        this.BTN_TEXT_COLOR_HOVER = ResearchMissionBaseSettings.CONSTANTS.BUTTON.TEXT_COLOR_HOVER;
        this.player = inv.player;
    }

    protected void init() {
        super.init();
        this.WINDOW_POS.x = this.width / 2 - this.WINDOW_SIZE.x / 2;
        this.WINDOW_POS.y = this.height / 2 - this.WINDOW_SIZE.y / 2;
        if (this.buttonList == null) {
            this.buttonList = this.initGuiButtons();
        }
        this.researchBox.reset();
    }

    public void removed() {
        super.removed();
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void render(GuiGraphics GuiGraphics2, int mouseX, int mouseY, float partialTicks) {
        super.render(GuiGraphics2, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics GuiGraphics2, float partialTicks, int x, int y) {
        this.WINDOW_POS.x = this.width / 2 - this.WINDOW_SIZE.x / 2;
        this.WINDOW_POS.y = this.height / 2 - this.WINDOW_SIZE.y / 2;
        this.drawWindowTitle(GuiGraphics2);
        this.drawMainWindow(GuiGraphics2);
        this.curHoverItem = this.isHoveringOverButton(x, y);
        if (this.researchBox.curResearchItem != null) {
            this.researchBox.checkIfHoveringOver(this.WINDOW_POS, x, y);
        }
    }

    private void drawWindowTitle(GuiGraphics GuiGraphics2) {
        this.drawWindowTitle(GuiGraphics2, this.titlePos, this.titleSize, "Research Mission Base");
    }

    public void drawMainWindow(GuiGraphics gg) {
        this.missionListWindow.drawMissionListWindow(gg);
        this.missionWindow.drawMissionWindow(gg);
        this.drawButtons(gg);
    }

    public void drawButtons(GuiGraphics gg) {
        for (GuiButton button : this.buttonList) {
            if (button.type != btnType.CLAIM) {
                if (this.curHoverItem == button.type) {
                    this.drawButton(gg, button.pos, button.size, true);
                    this.writeStringCentred(gg, button.text, button.pos.x + 20, button.pos.y + 2, this.BTN_TEXT_COLOR_HOVER);
                    continue;
                }
                this.drawButton(gg, button.pos, button.size, false);
                this.writeStringCentred(gg, button.text, button.pos.x + 20, button.pos.y + 2, this.BTN_TEXT_COLOR);
                continue;
            }
            if (this.researchBox.curResearchItem == null || !this.researchBox.curResearchItem.guiItem.showClaimButton) continue;
            if (this.curHoverItem == button.type) {
                this.drawButton(gg, button.pos, button.size, true);
                this.writeStringCentred(gg, button.text, button.pos.x + button.size.x / 2, button.pos.y + 3, this.BTN_TEXT_COLOR_HOVER);
                continue;
            }
            this.drawButton(gg, button.pos, button.size, false);
            this.writeStringCentred(gg, button.text, button.pos.x + button.size.x / 2, button.pos.y + 3, this.BTN_TEXT_COLOR);
        }
    }

    private void drawButton(GuiGraphics gg, Point pos, Point size, boolean isActive) {
        GuiDrawFunctions.drawButton(gg, this.WINDOW_POS, pos, size, isActive);
    }

    protected void renderLabels(GuiGraphics p_230451_1_, int p_230451_2_, int p_230451_3_) {
    }

    public void drawWindowTitle(GuiGraphics gg, Point pos, Point size, String text) {
        GuiDrawFunctions.drawWindowTitle(gg, this.WINDOW_POS, pos, size, this.font, text);
    }

    private void drawItemIcon(GuiGraphics gg, Item item, int x, int y) {
        GuiDrawFunctions.drawItemIcon(gg, this.font, this.WINDOW_POS, item, x, y);
    }

    private void drawItemIcon(GuiGraphics gg, Item item, int x, int y, int count) {
        GuiDrawFunctions.drawItemIcon(gg, this.font, this.WINDOW_POS, item, x, y, count);
    }

    private void drawRectangleWithBorder(GuiGraphics gg, Point pos, Point size, Color fillColor, Color borderColor) {
        GuiDrawFunctions.drawRectangleWithBorder(gg, this.WINDOW_POS, pos, size, fillColor, borderColor);
    }

    private void drawRectangle(GuiGraphics gg, int xPos, int yPos, int width, int height, Color color) {
        GuiDrawFunctions.drawRectangle(gg, this.WINDOW_POS, xPos, yPos, width, height, color);
    }

    private void writeString(GuiGraphics gg, String text, int x, int y, Color color) {
        GuiDrawFunctions.writeString(gg, this.font, this.WINDOW_POS, text, x, y, color);
    }

    private void writeStringCentred(GuiGraphics gg, String text, int x, int y, Color color) {
        GuiDrawFunctions.writeStringCentred(gg, this.font, this.WINDOW_POS, text, x, y, color);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.curHoverItem != null) {
            switch (this.curHoverItem.ordinal()) {
                case 2: {
                    if (this.researchBox.curResearchItem == null || !this.researchBox.curResearchItem.guiItem.showClaimButton || !this.researchBox.handleClaimClick()) break;
                    this.playClickSound();
                    this.researchBox = new ResearchBox();
                    break;
                }
                case 1: {
                    if (!this.researchBox.handleNextClick()) break;
                    this.playClickSound();
                    break;
                }
                case 0: {
                    if (!this.researchBox.handlePrevClick()) break;
                    this.playClickSound();
                    break;
                }
            }
        }
        if (this.researchBox.curReasearchHovered != null) {
            this.researchBox.handleMissionClick();
            this.playClickSound();
        }
        return false;
    }

    private void playClickSound() {
        this.player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.5f, 1.0f);
    }

    public class GuiButton
    extends ModButton {
        public btnType type;

        public GuiButton(ResearchMissionBaseScreen this$0, Point pos, Point size, String text, btnType type) {
            super(pos, size, text);
            this.type = type;
        }
    }

    public static enum btnType {
        PREV,
        NEXT,
        CLAIM;

    }

    private class MissionListWindow {
        private final Point MISSION_LIST_WINDOW_POS = ResearchMissionBaseSettings.MISSION_LIST_WINDOW.POS;
        private final Point MISSION_LIST_WINDOW_SIZE = ResearchMissionBaseSettings.MISSION_LIST_WINDOW.SIZE;
        private final Color MISSION_LIST_WINDOW_COLOR = ResearchMissionBaseSettings.MISSION_LIST_WINDOW.BG_COLOR;
        private final Color MISSION_LIST_ITEM_TEXT_COLOR = ResearchMissionBaseSettings.MISSION_LIST_WINDOW.MISSION_LIST.ITEM.TEXT_COLOR;
        private final Point MISSION_LIST_TITLE_POS = ResearchMissionBaseSettings.MISSION_LIST_WINDOW.TITLE.POS;
        private final Point MISSION_LIST_TITLE_SIZE = ResearchMissionBaseSettings.MISSION_LIST_WINDOW.TITLE.SIZE;
        private final Color MISSION_LIST_TITLE_TEXT_COLOR = ResearchMissionBaseSettings.MISSION_LIST_WINDOW.TITLE.TEXT_COLOR;
        private final Color MISSION_LIST_TITLE_BG_COLOR = ResearchMissionBaseSettings.MISSION_LIST_WINDOW.TITLE.BG_COLOR;
        private final Point MISSION_LIST_TAB_INDEX_POS = ResearchMissionBaseSettings.MISSION_LIST_WINDOW.TAB_INDEX.POS;
        private final Color MISSION_LIST_TAB_INDEX_TEXT_COLOR = ResearchMissionBaseSettings.MISSION_LIST_WINDOW.TAB_INDEX.TEXT_COLOR;

        private MissionListWindow() {
        }

        private void drawMissionListWindow(GuiGraphics gg) {
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.MISSION_LIST_WINDOW_POS, this.MISSION_LIST_WINDOW_SIZE, this.MISSION_LIST_WINDOW_COLOR, ResearchMissionBaseScreen.this.windowBorderColor);
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.MISSION_LIST_TITLE_POS, this.MISSION_LIST_TITLE_SIZE, this.MISSION_LIST_TITLE_BG_COLOR, ResearchMissionBaseScreen.this.windowBorderColor);
            ResearchMissionBaseScreen.this.writeString(gg, "Mission List: ", this.MISSION_LIST_TITLE_POS.x + 5, this.MISSION_LIST_TITLE_POS.y + 3, this.MISSION_LIST_TITLE_TEXT_COLOR);
            ResearchMissionBaseScreen.this.writeStringCentred(gg, ResearchMissionBaseScreen.this.researchBox.tabIndexString, this.MISSION_LIST_TAB_INDEX_POS.x, this.MISSION_LIST_TAB_INDEX_POS.y, this.MISSION_LIST_TAB_INDEX_TEXT_COLOR);
            if (ResearchMissionBaseScreen.this.researchBox.curTab != null) {
                for (ResearchMissionListItem mission : ResearchMissionBaseScreen.this.researchBox.curTab.missionList) {
                    this.drawMissionListItem(gg, mission.guiItem, mission.isHoveringOver);
                }
            }
        }

        private void drawMissionListItem(GuiGraphics gg, MisssionLIstGuiItem mission, boolean isHoveringOver) {
            if (!isHoveringOver) {
                ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, mission.pos, mission.size, mission.bgColor, Color.white);
            } else {
                ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, mission.pos, mission.size, mission.bgColor, Color.green);
            }
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, mission.namePos, mission.nameSize, Color.pink, Color.pink);
            ResearchMissionBaseScreen.this.writeString(gg, mission.missionName, mission.namePos.x + 5, mission.namePos.y + 3, this.MISSION_LIST_ITEM_TEXT_COLOR);
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, mission.requirementsPos, mission.requirementsSize, Color.pink, Color.pink);
            ResearchMissionBaseScreen.this.writeStringCentred(gg, mission.requirementsString, mission.requirementsPos.x + 12, mission.requirementsPos.y + 3, this.MISSION_LIST_ITEM_TEXT_COLOR);
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, mission.targetsPos, mission.targetsSize, Color.pink, Color.pink);
            ResearchMissionBaseScreen.this.writeStringCentred(gg, mission.targetsString, mission.targetsPos.x + 12, mission.targetsPos.y + 3, this.MISSION_LIST_ITEM_TEXT_COLOR);
        }
    }

    private class MissionWindow {
        private final Point MISSION_WINDOW_POS = ResearchMissionBaseSettings.MISSION_WINDOW.POS;
        private final Point MISSION_WINDOW_SIZE = ResearchMissionBaseSettings.MISSION_WINDOW.SIZE;
        private final Point MISSION_NAME_POS = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_NAME.POS;
        private final Point MISSION_NAME_SIZE = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_NAME.SIZE;
        private final Color MISSION_NAME_BG_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_NAME.BG_COLOR;
        private final Color MISSION_NAME_TEXT_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_NAME.TEXT.COLOR;
        private final Point MISSION_NAME_TEXT_POS = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_NAME.TEXT.POS;
        private final Point MISSION_NAME_TITLE_POS = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_NAME.TITLE.POS;
        private final Point MISSION_NAME_TITLE_SIZE = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_NAME.TITLE.SIZE;
        private final Color MISSION_NAME_TITLE_BG_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_NAME.TITLE.BG_COLOR;
        private final Color MISSION_NAME_TITLE_TEXT_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_NAME.TITLE.COLOR;
        private final Point ITEM_NAME_POS = ResearchMissionBaseSettings.MISSION_WINDOW.ITEM_NAME.POS;
        private final Point ITEM_NAME_SIZE = ResearchMissionBaseSettings.MISSION_WINDOW.ITEM_NAME.SIZE;
        private final Color ITEM_NAME_BG_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.ITEM_NAME.BG_COLOR;
        private final Color ITEM_NAME_TEXT_COLOR_DISCOVERED = ResearchMissionBaseSettings.MISSION_WINDOW.ITEM_NAME.TEXT.DISCOVERED_COLOR;
        private final Color ITEM_NAME_TEXT_COLOR_UNDISCOVERED = ResearchMissionBaseSettings.MISSION_WINDOW.ITEM_NAME.TEXT.UNDISCOVERED_COLOR;
        private final Point ITEM_NAME_ICON_POS = ResearchMissionBaseSettings.MISSION_WINDOW.ITEM_NAME.ICON.POS;
        private final Point ITEM_NAME_TEXT_POS = ResearchMissionBaseSettings.MISSION_WINDOW.ITEM_NAME.TEXT.POS;
        private final Point REQUIRED_DISCOVERIES_POS = ResearchMissionBaseSettings.MISSION_WINDOW.REQUIRED_DISCOVERIES.POS;
        private final Point REQUIRED_DISCOVERIES_SIZE = ResearchMissionBaseSettings.MISSION_WINDOW.REQUIRED_DISCOVERIES.SIZE;
        private final Color REQUIRED_DISCOVERIES_BG_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.REQUIRED_DISCOVERIES.BG_COLOR;
        private final Point REQUIRED_DISCOVERIES_TITLE_POS = ResearchMissionBaseSettings.MISSION_WINDOW.REQUIRED_DISCOVERIES.TITLE.POS;
        private final Point REQUIRED_DISCOVERIES_TITLE_SIZE = ResearchMissionBaseSettings.MISSION_WINDOW.REQUIRED_DISCOVERIES.TITLE.SIZE;
        private final Color REQUIRED_DISCOVERIES_TITLE_BG_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.REQUIRED_DISCOVERIES.TITLE.BG_COLOR;
        private final Color REQUIRED_DISCOVERIES_TEXT_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.REQUIRED_DISCOVERIES.TITLE.TEXT.COLOR;
        private final Point REQUIRED_DISCOVERIES_TEXT_POS = ResearchMissionBaseSettings.MISSION_WINDOW.REQUIRED_DISCOVERIES.TITLE.TEXT.POS;
        private final Point ITEM_SIZE = ResearchMissionBaseSettings.CONSTANTS.ITEM.SIZE;
        private String titleExtension = "";
        private final Point MISSION_DISCOVERIES_POS = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_DISCOVERIES.POS;
        private final Point MISSION_DISCOVERIES_SIZE = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_DISCOVERIES.SIZE;
        private final Color MISSION_DISCOVERIES_BG_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_DISCOVERIES.BG_COLOR;
        private final Point MISSION_DISCOVERIES_TITLE_POS = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_DISCOVERIES.TITLE.POS;
        private final Point MISSION_DISCOVERIES_TITLE_SIZE = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_DISCOVERIES.TITLE.SIZE;
        private final Color MISSION_DISCOVERIES_TITLE_BG_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_DISCOVERIES.TITLE.BG_COLOR;
        private final Color MISSION_DISCOVERIES_TEXT_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_DISCOVERIES.TITLE.TEXT.COLOR;
        private final Point MISSION_DISCOVERIES_TEXT_POS = ResearchMissionBaseSettings.MISSION_WINDOW.MISSION_DISCOVERIES.TITLE.TEXT.POS;
        private final Point REWARDS_POS = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.POS;
        private final Point REWARDS_SIZE = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.SIZE;
        private final Color REWARDS_BG_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.BG_COLOR;
        private final Point REWARDS_TITLE_POS = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.TITLE.POS;
        private final Point REWARDS_TITLE_SIZE = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.TITLE.SIZE;
        private final Color REWARDS_TITLE_BG_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.TITLE.BG_COLOR;
        private final Color REWARDS_TEXT_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.TITLE.TEXT.COLOR;
        private final Point REWARDS_TEXT_POS = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.TITLE.TEXT.POS;
        private final Point MANA_SECTION_POS = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.MANA.POS;
        private final Point MANA_SECTION_SIZE = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.MANA.SIZE;
        private final Color MANA_TITLE_TEXT_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.MANA.TITLE_TEXT_COLOR;
        private final Color MANA_TITLE_BG_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.MANA.TITLE_BG_COLOR;
        private final Color MANA_AMOUNT_TEXT_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.MANA.AMOUNT_TEXT_COLOR;
        private final Color MANA_AMOUNT_BG_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.MANA.AMOUNT_BG_COLOR;
        private final Point MANA_TITLE_SIZE = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.MANA.TITLE_SIZE;
        private final Point MANA_AMOUNT_SIZE = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.MANA.AMOUNT_SIZE;
        private final Point MANA_POINTS_TITLE_POS = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.MANA.POINTS.TITLE.POS;
        private final Point MANA_POINTS_TITLE_TEXT_POS = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.MANA.POINTS.TITLE.TEXT.POS;
        private final Point MANA_POINTS_AMOUNT_POS = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.MANA.POINTS.AMOUNT.POS;
        private final Point MANA_POINTS_AMOUNT_TEXT_POS = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.MANA.POINTS.AMOUNT.TEXT.POS;
        private final Point MANA_LIMIT_TITLE_POS = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.MANA.LIMIT_BONUS.TITLE.POS;
        private final Point MANA_LIMIT_TITLE_TEXT_POS = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.MANA.LIMIT_BONUS.TITLE.TEXT.POS;
        private final Point MANA_LIMIT_AMOUNT_POS = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.MANA.LIMIT_BONUS.AMOUNT.POS;
        private final Point MANA_LIMIT_AMOUNT_TEXT_POS = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.MANA.LIMIT_BONUS.AMOUNT.TEXT.POS;
        private final Point REWARDS_ITEM_SIZE = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.REWARD_ITEM_LIST.ITEM.SIZE;
        private final Color REWARDS_ITEM_BG_COLOR = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.REWARD_ITEM_LIST.ITEM.BG_COLOR;
        private int rewardItemCounter = 0;
        private Point curRewardItemPos = null;

        private MissionWindow() {
        }

        private void drawMissionWindow(GuiGraphics gg) {
            this.drawMissionName(gg);
            this.drawItemName(gg);
            this.drawRequiredDiscoveries(gg);
            this.drawMissionTargets(gg);
            this.drawRewards(gg);
        }

        private void drawMissionName(GuiGraphics gg) {
            if (ResearchMissionBaseScreen.this.researchBox.curTab != null) {
                if (ResearchMissionBaseScreen.this.researchBox.curResearchItem != null) {
                    ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.MISSION_NAME_POS, this.MISSION_NAME_SIZE, ResearchMissionBaseScreen.this.researchBox.curResearchItem.guiItem.bgColor, ResearchMissionBaseScreen.this.windowBorderColor);
                    ResearchMissionBaseScreen.this.writeString(gg, ResearchMissionBaseScreen.this.researchBox.curResearchItem.mission.missionName, this.MISSION_NAME_TEXT_POS.x, this.MISSION_NAME_TEXT_POS.y, ResearchMissionBaseScreen.this.researchBox.curResearchItem.guiItem.nameTextColor);
                } else {
                    ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.MISSION_NAME_POS, this.MISSION_NAME_SIZE, Color.pink, ResearchMissionBaseScreen.this.windowBorderColor);
                }
            } else {
                ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.MISSION_NAME_POS, this.MISSION_NAME_SIZE, Color.pink, ResearchMissionBaseScreen.this.windowBorderColor);
            }
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.MISSION_NAME_POS, this.MISSION_NAME_TITLE_SIZE, this.MISSION_NAME_TITLE_BG_COLOR, ResearchMissionBaseScreen.this.windowBorderColor);
            ResearchMissionBaseScreen.this.writeString(gg, "Mission: ", this.MISSION_NAME_TITLE_POS.x, this.MISSION_NAME_TITLE_POS.y, this.MISSION_NAME_TITLE_TEXT_COLOR);
        }

        private void drawItemName(GuiGraphics gg) {
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.ITEM_NAME_POS, this.ITEM_NAME_SIZE, this.ITEM_NAME_BG_COLOR, ResearchMissionBaseScreen.this.windowBorderColor);
            if (ResearchMissionBaseScreen.this.researchBox.curItemHovered != null) {
                ResearchMissionBaseScreen.this.drawItemIcon(gg, ResearchMissionBaseScreen.this.researchBox.curItemHovered, this.ITEM_NAME_ICON_POS.x, this.ITEM_NAME_ICON_POS.y);
                if (QdcApi.QDC_CORE.FUNCTIONS.isItemDiscovered(ResearchMissionBaseScreen.this.researchBox.curItemHovered)) {
                    ResearchMissionBaseScreen.this.writeString(gg, GlobalFuncs.getItemName(ResearchMissionBaseScreen.this.researchBox.curItemHovered), this.ITEM_NAME_TEXT_POS.x, this.ITEM_NAME_TEXT_POS.y, this.ITEM_NAME_TEXT_COLOR_DISCOVERED);
                } else {
                    ResearchMissionBaseScreen.this.writeString(gg, GlobalFuncs.getItemName(ResearchMissionBaseScreen.this.researchBox.curItemHovered), this.ITEM_NAME_TEXT_POS.x, this.ITEM_NAME_TEXT_POS.y, this.ITEM_NAME_TEXT_COLOR_UNDISCOVERED);
                }
            }
        }

        private void drawRequiredDiscoveries(GuiGraphics gg) {
            this.titleExtension = ResearchMissionBaseScreen.this.researchBox.curResearchItem != null ? "[" + ResearchMissionBaseScreen.this.researchBox.curResearchItem.guiItem.requirementsString + "]" : "";
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.REQUIRED_DISCOVERIES_POS, this.REQUIRED_DISCOVERIES_SIZE, this.REQUIRED_DISCOVERIES_BG_COLOR, ResearchMissionBaseScreen.this.windowBorderColor);
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.REQUIRED_DISCOVERIES_TITLE_POS, this.REQUIRED_DISCOVERIES_TITLE_SIZE, this.REQUIRED_DISCOVERIES_TITLE_BG_COLOR, ResearchMissionBaseScreen.this.windowBorderColor);
            ResearchMissionBaseScreen.this.writeString(gg, "Required Discoveries " + this.titleExtension, this.REQUIRED_DISCOVERIES_TEXT_POS.x, this.REQUIRED_DISCOVERIES_TEXT_POS.y, this.REQUIRED_DISCOVERIES_TEXT_COLOR);
            if (ResearchMissionBaseScreen.this.researchBox.curTab != null && ResearchMissionBaseScreen.this.researchBox.curResearchItem != null) {
                if (ResearchMissionBaseScreen.this.researchBox.curResearchItem.mission.multiRequirements != null) {
                    for (MissionRequirement_multi missionRequirement_multi : ResearchMissionBaseScreen.this.researchBox.curResearchItem.mission.multiRequirements) {
                        if (missionRequirement_multi.isAnItemDiscovered()) {
                            ResearchMissionBaseScreen.this.drawRectangle(gg, missionRequirement_multi.pos.x, missionRequirement_multi.pos.y, this.ITEM_SIZE.x, this.ITEM_SIZE.y, Color.green);
                        } else {
                            ResearchMissionBaseScreen.this.drawRectangle(gg, missionRequirement_multi.pos.x, missionRequirement_multi.pos.y, this.ITEM_SIZE.x, this.ITEM_SIZE.y, Color.red);
                        }
                        ResearchMissionBaseScreen.this.drawItemIcon(gg, missionRequirement_multi.getNextDisplayItem(), missionRequirement_multi.pos.x + 1, missionRequirement_multi.pos.y + 1);
                    }
                }
                if (ResearchMissionBaseScreen.this.researchBox.curResearchItem.mission.mainRequirements != null) {
                    for (MissionItem missionItem : ResearchMissionBaseScreen.this.researchBox.curResearchItem.mission.mainRequirements) {
                        if (missionItem.isDiscovered()) {
                            ResearchMissionBaseScreen.this.drawRectangle(gg, missionItem.pos.x, missionItem.pos.y, this.ITEM_SIZE.x, this.ITEM_SIZE.y, Color.green);
                        } else {
                            ResearchMissionBaseScreen.this.drawRectangle(gg, missionItem.pos.x, missionItem.pos.y, this.ITEM_SIZE.x, this.ITEM_SIZE.y, Color.red);
                        }
                        ResearchMissionBaseScreen.this.drawItemIcon(gg, missionItem.item, missionItem.pos.x + 1, missionItem.pos.y + 1);
                    }
                }
            }
        }

        private void drawMissionTargets(GuiGraphics gg) {
            this.titleExtension = ResearchMissionBaseScreen.this.researchBox.curResearchItem != null ? "[" + ResearchMissionBaseScreen.this.researchBox.curResearchItem.guiItem.targetsString + "]" : "";
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.MISSION_DISCOVERIES_POS, this.MISSION_DISCOVERIES_SIZE, this.MISSION_DISCOVERIES_BG_COLOR, ResearchMissionBaseScreen.this.windowBorderColor);
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.MISSION_DISCOVERIES_TITLE_POS, this.MISSION_DISCOVERIES_TITLE_SIZE, this.MISSION_DISCOVERIES_TITLE_BG_COLOR, ResearchMissionBaseScreen.this.windowBorderColor);
            ResearchMissionBaseScreen.this.writeString(gg, "Mission Target Discoveries " + this.titleExtension, this.MISSION_DISCOVERIES_TEXT_POS.x, this.MISSION_DISCOVERIES_TEXT_POS.y, this.MISSION_DISCOVERIES_TEXT_COLOR);
            if (ResearchMissionBaseScreen.this.researchBox.curTab != null && ResearchMissionBaseScreen.this.researchBox.curResearchItem != null && ResearchMissionBaseScreen.this.researchBox.curResearchItem.mission.isRequirementsComplete) {
                for (MissionItem item : ResearchMissionBaseScreen.this.researchBox.curResearchItem.mission.discoveryTargets) {
                    if (item.isDiscovered()) {
                        ResearchMissionBaseScreen.this.drawRectangle(gg, item.pos.x, item.pos.y, this.ITEM_SIZE.x, this.ITEM_SIZE.y, Color.green);
                    } else {
                        ResearchMissionBaseScreen.this.drawRectangle(gg, item.pos.x, item.pos.y, this.ITEM_SIZE.x, this.ITEM_SIZE.y, Color.red);
                    }
                    ResearchMissionBaseScreen.this.drawItemIcon(gg, item.item, item.pos.x + 1, item.pos.y + 1);
                }
            }
        }

        private void drawRewards(GuiGraphics gg) {
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.REWARDS_POS, this.REWARDS_SIZE, this.REWARDS_BG_COLOR, ResearchMissionBaseScreen.this.windowBorderColor);
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.REWARDS_TITLE_POS, this.REWARDS_TITLE_SIZE, this.REWARDS_TITLE_BG_COLOR, ResearchMissionBaseScreen.this.windowBorderColor);
            ResearchMissionBaseScreen.this.writeString(gg, "Rewards", this.REWARDS_TEXT_POS.x, this.REWARDS_TEXT_POS.y, this.REWARDS_TEXT_COLOR);
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.MANA_SECTION_POS, this.MANA_SECTION_SIZE, this.REWARDS_BG_COLOR, ResearchMissionBaseScreen.this.windowBorderColor);
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.MANA_POINTS_TITLE_POS, this.MANA_TITLE_SIZE, this.MANA_TITLE_BG_COLOR, ResearchMissionBaseScreen.this.windowBorderColor);
            ResearchMissionBaseScreen.this.writeStringCentred(gg, "Mana Points:", this.MANA_POINTS_TITLE_TEXT_POS.x, this.MANA_POINTS_TITLE_TEXT_POS.y, this.MANA_TITLE_TEXT_COLOR);
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.MANA_POINTS_AMOUNT_POS, this.MANA_AMOUNT_SIZE, this.MANA_AMOUNT_BG_COLOR, ResearchMissionBaseScreen.this.windowBorderColor);
            if (ResearchMissionBaseScreen.this.researchBox.curResearchItem != null) {
                ResearchMissionBaseScreen.this.writeStringCentred(gg, ResearchMissionBaseScreen.this.researchBox.curResearchItem.guiItem.manaPointsString, this.MANA_POINTS_AMOUNT_TEXT_POS.x, this.MANA_POINTS_AMOUNT_TEXT_POS.y, this.MANA_AMOUNT_TEXT_COLOR);
            }
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.MANA_LIMIT_TITLE_POS, this.MANA_TITLE_SIZE, this.MANA_TITLE_BG_COLOR, ResearchMissionBaseScreen.this.windowBorderColor);
            ResearchMissionBaseScreen.this.writeStringCentred(gg, "Mana Limit:", this.MANA_LIMIT_TITLE_TEXT_POS.x, this.MANA_LIMIT_TITLE_TEXT_POS.y, this.MANA_TITLE_TEXT_COLOR);
            ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.MANA_LIMIT_AMOUNT_POS, this.MANA_AMOUNT_SIZE, this.MANA_AMOUNT_BG_COLOR, ResearchMissionBaseScreen.this.windowBorderColor);
            if (ResearchMissionBaseScreen.this.researchBox.curResearchItem != null) {
                ResearchMissionBaseScreen.this.writeStringCentred(gg, ResearchMissionBaseScreen.this.researchBox.curResearchItem.guiItem.manaLimitString, this.MANA_LIMIT_AMOUNT_TEXT_POS.x, this.MANA_LIMIT_AMOUNT_TEXT_POS.y, this.MANA_AMOUNT_TEXT_COLOR);
            }
            this.drawItemRewards(gg);
        }

        private void drawItemRewards(GuiGraphics gg) {
            this.rewardItemCounter = 0;
            if (ResearchMissionBaseScreen.this.researchBox.curResearchItem != null) {
                for (ItemStack is : ResearchMissionBaseScreen.this.researchBox.curResearchItem.mission.rewardItems) {
                    this.curRewardItemPos = ResearchMissionBaseSettings.MISSION_WINDOW.REWARDS.REWARD_ITEM_LIST.ITEM_LIST.get(this.rewardItemCounter);
                    ResearchMissionBaseScreen.this.drawRectangleWithBorder(gg, this.curRewardItemPos, this.REWARDS_ITEM_SIZE, this.REWARDS_ITEM_BG_COLOR, ResearchMissionBaseScreen.this.windowBorderColor);
                    if (ResearchMissionBaseScreen.this.researchBox.curResearchItem.mission.isRequirementsComplete) {
                        ResearchMissionBaseScreen.this.drawItemIcon(gg, is.getItem(), this.curRewardItemPos.x + 1, this.curRewardItemPos.y + 1);
                    }
                    ++this.rewardItemCounter;
                }
            }
        }
    }
}

