/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.common.gui.screen;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.GuiDrawFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.ModButton;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.RecyclerSettings;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.ResearchMissionBaseSettings;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.RevelationSettings;
import com.qdc_mod.qdc_core_4.qdc_core.common.menu.RevelationMenu;
import com.qdc_mod.qdc_core_4.qdc_core.functions.ParticleFunctions;
import com.qdc_mod.qdc_core_4.qdc_core.functions.TimeFunctions;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RevelationScreen
extends AbstractContainerScreen<RevelationMenu> {
    private final Point WINDOW_SIZE = RecyclerSettings.MAIN_WINDOW.SIZE;
    private final Point WINDOW_POS = new Point(0, 0);
    public List<GuiButton> buttonList = null;
    private btnType curHoverItem = null;
    private Player player;
    private Point titleSize;
    private Point titlePos;
    private final Point TIMER_WINDOW_POS;
    private final Point TIMER_WINDOW_SIZE;
    private final Color TIMER_WINDOW_BG_COLOR;
    private final Point TIMER_TITLE_SIZE;
    private final Point TIMER_TITLE_TEXT_POS;
    private final Color TIMER_TITLE_TEXT_COLOR;
    private final Color TIMER_TITLE_BG_COLOR;
    private final Point TIME_TEXT_POS;
    private final Color TIME_TEXT_COLOR;
    private final Point ITEM_WINDOW_POS;
    private final Point ITEM_WINDOW_SIZE;
    private final Color ITEM_WINDOW_BG_COLOR;
    private final Point ITEM_TITLE_TEXT_POS;
    private final Point ITEM_TITLE_SIZE;
    private final Color ITEM_TITLE_BG_COLOR;
    private final Color ITEM_TITLE_TEXT_COLOR;
    private final Point ITEM_ICON_POS;
    private final Point ITEM_ICON_SIZE;
    private final Point ITEM_NAME_TEXT_POS;
    private final Color ITEM_NAME_TEXT_COLOR;
    private final Point PARTICLES_WINDOW_POS;
    private final Point PARTICLES_WINDOW_SIZE;
    private final Color PARTICLES_WINDOW_BG_COLOR;
    private final Point PARTICLE_ITEM_SIZE;
    private Point curParticleItemPos;
    private final Color BTN_TEXT_COLOR;
    private final Color BTN_TEXT_COLOR_HOVER;

    private List<GuiButton> initGuiButtons() {
        ArrayList<GuiButton> res = new ArrayList<GuiButton>();
        res.add(new GuiButton(this, RevelationSettings.BUTTON.POS, RevelationSettings.BUTTON.SIZE, "Claim Rewards!", btnType.CLAIM));
        return res;
    }

    public btnType isHoveringOverButton(int mouseX, int mouseY) {
        for (GuiButton b : this.buttonList) {
            if (!b.checkIfHoveringOver(this.WINDOW_POS, mouseX, mouseY)) continue;
            return b.type;
        }
        return null;
    }

    public RevelationScreen(RevelationMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.titleSize = new Point(this.WINDOW_SIZE.x, 16);
        this.titlePos = new Point(this.WINDOW_POS.x, this.WINDOW_POS.y - 20);
        this.TIMER_WINDOW_POS = RevelationSettings.TIMER.POS;
        this.TIMER_WINDOW_SIZE = RevelationSettings.TIMER.SIZE;
        this.TIMER_WINDOW_BG_COLOR = RevelationSettings.TIMER.BG_COLOR;
        this.TIMER_TITLE_SIZE = RevelationSettings.TIMER.TITLE.SIZE;
        this.TIMER_TITLE_TEXT_POS = RevelationSettings.TIMER.TITLE.TEXT_POS;
        this.TIMER_TITLE_TEXT_COLOR = RevelationSettings.TIMER.TITLE.TEXT_COLOR;
        this.TIMER_TITLE_BG_COLOR = RevelationSettings.TIMER.TITLE.BG_COLOR;
        this.TIME_TEXT_POS = RevelationSettings.TIMER.TIME.TEXT_POS;
        this.TIME_TEXT_COLOR = RevelationSettings.TIMER.TIME.TEXT_COLOR;
        this.ITEM_WINDOW_POS = RevelationSettings.UNDISCOVERED_ITEM.POS;
        this.ITEM_WINDOW_SIZE = RevelationSettings.UNDISCOVERED_ITEM.SIZE;
        this.ITEM_WINDOW_BG_COLOR = RevelationSettings.UNDISCOVERED_ITEM.BG_COLOR;
        this.ITEM_TITLE_TEXT_POS = RevelationSettings.UNDISCOVERED_ITEM.TITLE.TEXT_POS;
        this.ITEM_TITLE_SIZE = RevelationSettings.UNDISCOVERED_ITEM.TITLE.SIZE;
        this.ITEM_TITLE_BG_COLOR = RevelationSettings.UNDISCOVERED_ITEM.TITLE.BG_COLOR;
        this.ITEM_TITLE_TEXT_COLOR = RevelationSettings.UNDISCOVERED_ITEM.TITLE.TEXT_COLOR;
        this.ITEM_ICON_POS = RevelationSettings.UNDISCOVERED_ITEM.ICON.POS;
        this.ITEM_ICON_SIZE = RevelationSettings.UNDISCOVERED_ITEM.ICON.SIZE;
        this.ITEM_NAME_TEXT_POS = RevelationSettings.UNDISCOVERED_ITEM.NAME.TEXT_POS;
        this.ITEM_NAME_TEXT_COLOR = RevelationSettings.UNDISCOVERED_ITEM.NAME.TEXT_COLOR;
        this.PARTICLES_WINDOW_POS = RevelationSettings.PARTICLES.POS;
        this.PARTICLES_WINDOW_SIZE = RevelationSettings.PARTICLES.SIZE;
        this.PARTICLES_WINDOW_BG_COLOR = RevelationSettings.PARTICLES.BG_COLOR;
        this.PARTICLE_ITEM_SIZE = RevelationSettings.PARTICLES.ITEM_LIST.ITEM.SIZE;
        this.BTN_TEXT_COLOR = ResearchMissionBaseSettings.CONSTANTS.BUTTON.TEXT_COLOR;
        this.BTN_TEXT_COLOR_HOVER = ResearchMissionBaseSettings.CONSTANTS.BUTTON.TEXT_COLOR_HOVER;
        this.player = inv.player;
    }

    protected void init() {
        super.init();
        this.WINDOW_POS.x = this.width / 2 - this.WINDOW_SIZE.x / 2;
        this.WINDOW_POS.y = this.height / 2 - this.WINDOW_SIZE.y / 2;
        if (this.buttonList == null) {
            this.buttonList = this.initGuiButtons();
        }
    }

    public void removed() {
        super.removed();
    }

    public void render(GuiGraphics GuiGraphics2, int mouseX, int mouseY, float partialTicks) {
        super.render(GuiGraphics2, mouseX, mouseY, partialTicks);
    }

    protected void renderBg(GuiGraphics GuiGraphics2, float partialTicks, int x, int y) {
        this.WINDOW_POS.x = this.width / 2 - this.WINDOW_SIZE.x / 2;
        this.WINDOW_POS.y = this.height / 2 - this.WINDOW_SIZE.y / 2;
        this.drawWindowTitle(GuiGraphics2);
        this.drawMainWindow(GuiGraphics2);
        this.curHoverItem = this.isHoveringOverButton(x, y);
    }

    private void drawWindowTitle(GuiGraphics GuiGraphics2) {
        this.drawWindowTitle(GuiGraphics2, this.titlePos, this.titleSize, "Quantum Revelation");
    }

    public void drawMainWindow(GuiGraphics gg) {
        this.drawButtons(gg);
        if (Qdc.RevelationStuff.isRevelationReady) {
            this.drawRewards(gg);
        } else {
            this.drawTimer(gg);
        }
    }

    public void drawTimer(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, this.TIMER_WINDOW_POS, this.TIMER_WINDOW_SIZE, this.TIMER_WINDOW_BG_COLOR, Color.white);
        this.drawRectangleWithBorder(gg, this.TIMER_WINDOW_POS, this.TIMER_TITLE_SIZE, this.TIMER_TITLE_BG_COLOR, Color.white);
        this.writeString(gg, "Time Left:", this.TIMER_TITLE_TEXT_POS.x, this.TIMER_TITLE_TEXT_POS.y, this.TIMER_TITLE_TEXT_COLOR);
        this.writeStringCentred(gg, TimeFunctions.generateTimeLeftString(), this.TIME_TEXT_POS.x, this.TIME_TEXT_POS.y, this.TIME_TEXT_COLOR);
    }

    public void drawRewards(GuiGraphics gg) {
        this.drawParticlesSection(gg);
        if (MainBox.REVELATION_BOX.itemReward != null) {
            this.drawUndiscoveredItemSection(gg);
        }
    }

    public void drawUndiscoveredItemSection(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, this.ITEM_WINDOW_POS, this.ITEM_WINDOW_SIZE, this.ITEM_WINDOW_BG_COLOR, Color.white);
        this.drawRectangleWithBorder(gg, this.ITEM_WINDOW_POS, this.ITEM_TITLE_SIZE, this.ITEM_TITLE_BG_COLOR, Color.white);
        this.writeString(gg, "Undiscovered Item:", this.ITEM_TITLE_TEXT_POS.x, this.ITEM_TITLE_TEXT_POS.y, this.ITEM_TITLE_TEXT_COLOR);
        this.drawRectangleWithBorder(gg, this.ITEM_ICON_POS, this.ITEM_ICON_SIZE, Color.white, Color.white);
        this.drawItemIcon(gg, MainBox.REVELATION_BOX.itemReward, this.ITEM_ICON_POS.x + 2, this.ITEM_ICON_POS.y + 2);
        this.writeString(gg, MainBox.REVELATION_BOX.itemRewardString, this.ITEM_NAME_TEXT_POS.x, this.ITEM_NAME_TEXT_POS.y, this.ITEM_NAME_TEXT_COLOR);
    }

    public void drawParticlesSection(GuiGraphics gg) {
        this.drawRectangleWithBorder(gg, this.PARTICLES_WINDOW_POS, this.PARTICLES_WINDOW_SIZE, this.PARTICLES_WINDOW_BG_COLOR, Color.white);
        for (int i = 0; i < 7; ++i) {
            this.drawParticleItem(gg, MainBox.REVELATION_BOX.particleReward.particleList.get(i), i);
        }
    }

    private void drawParticleItem(GuiGraphics gg, ParticleItem item, int index) {
        this.curParticleItemPos = RevelationSettings.PARTICLES.ITEM_LIST.CATEGORY_POSITION_LIST.get(index);
        this.drawRectangleWithBorder(gg, this.curParticleItemPos, this.PARTICLE_ITEM_SIZE, this.PARTICLES_WINDOW_BG_COLOR, Color.white);
        this.drawItemIcon(gg, QdcApi.QDC_CORE.FUNCTIONS.getParticleIconItem(item.type), this.curParticleItemPos.x + 1, this.curParticleItemPos.y + 1);
        this.writeString(gg, String.valueOf((Object)item.type), this.curParticleItemPos.x + 20, this.curParticleItemPos.y + 5, ParticleFunctions.getParticleTextColor(item.type));
        this.writeString(gg, "+" + (int)item.amount, this.curParticleItemPos.x + 83, this.curParticleItemPos.y + 5, ParticleFunctions.getParticleTextColor(item.type));
    }

    public void drawButtons(GuiGraphics gg) {
        for (GuiButton button : this.buttonList) {
            if (!Qdc.RevelationStuff.isRevelationReady) continue;
            if (this.curHoverItem == button.type) {
                this.drawButton(gg, button.pos, button.size, true);
                this.writeStringCentred(gg, button.text, button.pos.x + RevelationSettings.BUTTON.SIZE.x / 2, button.pos.y + 6, this.BTN_TEXT_COLOR_HOVER);
                continue;
            }
            this.drawButton(gg, button.pos, button.size, false);
            this.writeStringCentred(gg, button.text, button.pos.x + RevelationSettings.BUTTON.SIZE.x / 2, button.pos.y + 6, this.BTN_TEXT_COLOR);
        }
    }

    private void drawButton(GuiGraphics gg, Point pos, Point size, boolean isActive) {
        GuiDrawFunctions.drawButton(gg, this.WINDOW_POS, pos, size, isActive);
    }

    protected void renderLabels(GuiGraphics p_230451_1_, int p_230451_2_, int p_230451_3_) {
    }

    public void drawWindowTitle(GuiGraphics gg, Point pos, Point size, String text) {
        GuiDrawFunctions.drawWindowTitle(gg, this.WINDOW_POS, pos, size, this.font, text);
    }

    private void drawItemIcon(GuiGraphics gg, Item item, int x, int y) {
        GuiDrawFunctions.drawItemIcon(gg, this.font, this.WINDOW_POS, item, x, y);
    }

    private void drawItemIcon(GuiGraphics gg, Item item, int x, int y, int count) {
        GuiDrawFunctions.drawItemIcon(gg, this.font, this.WINDOW_POS, item, x, y, count);
    }

    private void drawRectangleWithBorder(GuiGraphics gg, Point pos, Point size, Color fillColor, Color borderColor) {
        GuiDrawFunctions.drawRectangleWithBorder(gg, this.WINDOW_POS, pos, size, fillColor, borderColor);
    }

    private void drawRectangle(GuiGraphics gg, int xPos, int yPos, int width, int height, Color color) {
        GuiDrawFunctions.drawRectangle(gg, this.WINDOW_POS, xPos, yPos, width, height, color);
    }

    private void writeString(GuiGraphics gg, String text, int x, int y, Color color) {
        GuiDrawFunctions.writeString(gg, this.font, this.WINDOW_POS, text, x, y, color);
    }

    private void writeStringCentred(GuiGraphics gg, String text, int x, int y, Color color) {
        GuiDrawFunctions.writeStringCentred(gg, this.font, this.WINDOW_POS, text, x, y, color);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.curHoverItem != null) {
            switch (this.curHoverItem.ordinal()) {
                case 0: {
                    MainBox.REVELATION_BOX.handleClaimClick();
                    this.playDiscoverySound();
                }
            }
        }
        return false;
    }

    private void playClickSound() {
        this.player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.5f, 1.0f);
    }

    private void playDiscoverySound() {
        this.player.playSound(SoundEvents.BELL_BLOCK, 0.5f, 1.0f);
    }

    private void playErrorSound() {
        this.player.playSound((SoundEvent)SoundEvents.NOTE_BLOCK_BASEDRUM.value(), 0.5f, 1.0f);
    }

    public class GuiButton
    extends ModButton {
        public btnType type;

        public GuiButton(RevelationScreen this$0, Point pos, Point size, String text, btnType type) {
            super(pos, size, text);
            this.type = type;
        }
    }

    public static enum btnType {
        CLAIM;

    }
}

