/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.functions;

import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import java.awt.Color;
import net.minecraft.world.item.Item;

public class ParticleFunctions {
    public static final Item natureIcon = QdcApi.QDC_CORE.ITEMS.PARTICLE_ICON.NATURE;
    public static final Item foodIcon = QdcApi.QDC_CORE.ITEMS.PARTICLE_ICON.FOOD;
    public static final Item metalIcon = QdcApi.QDC_CORE.ITEMS.PARTICLE_ICON.METAL;
    public static final Item gemIcon = QdcApi.QDC_CORE.ITEMS.PARTICLE_ICON.GEM;
    public static final Item corruptionIcon = QdcApi.QDC_CORE.ITEMS.PARTICLE_ICON.CORRUPTION;
    public static final Item manaIcon = QdcApi.QDC_CORE.ITEMS.PARTICLE_ICON.MANA;
    public static final Color amountColor = Color.white;
    public static final Color natureColor = Color.green;
    public static final Color foodColor = Color.orange;
    public static final Color metalColor = Color.white;
    public static final Color gemColor = Color.cyan;
    public static final Color corruptionColor = new Color(207, 159, 255);
    public static final Color manaColor = Color.yellow;

    public static int calcCorruptionParticlesForItem(ParticleCollection particles) {
        double resAmount = 0.0;
        for (ParticleItem pi : particles.particleList) {
            resAmount += ParticleFunctions.calcCorruptionFOrParticle(pi);
        }
        if (resAmount < 5.0) {
            resAmount = 5.0;
        }
        if (resAmount > 250.0) {
            resAmount = 250.0;
        }
        return (int)resAmount;
    }

    private static double calcCorruptionFOrParticle(ParticleItem particleItem) {
        double rate = ParticleFunctions.getCorrutioParticleRate(particleItem.type);
        double curAmount = particleItem.amount;
        return curAmount * rate;
    }

    private static double getCorrutioParticleRate(ENUMS.ParticleType type) {
        switch (type) {
            case NATURE: {
                return 0.5;
            }
            case FOOD: {
                return 1.0;
            }
            case METAL: {
                return 2.5;
            }
            case GEM: {
                return 10.0;
            }
        }
        return 0.0;
    }

    public static Item getParticleIconItem(ENUMS.ParticleType type) {
        switch (type) {
            case NATURE: {
                return natureIcon;
            }
            case FOOD: {
                return foodIcon;
            }
            case METAL: {
                return metalIcon;
            }
            case GEM: {
                return gemIcon;
            }
            case CORRUPTION: {
                return corruptionIcon;
            }
            case MANA: {
                return manaIcon;
            }
            case MANA_MAX: {
                return manaIcon;
            }
        }
        return manaIcon;
    }

    public static Color getParticleTextColor(ENUMS.ParticleType type) {
        switch (type) {
            case NATURE: {
                return natureColor;
            }
            case FOOD: {
                return foodColor;
            }
            case METAL: {
                return metalColor;
            }
            case GEM: {
                return gemColor;
            }
            case CORRUPTION: {
                return corruptionColor;
            }
            case MANA: {
                return manaColor;
            }
            case MANA_MAX: {
                return manaColor;
            }
        }
        return manaColor;
    }
}

