/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.functions.item_drop_functions;

import com.qdc_mod.qdc_core_4.api.QdcApi;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.item.Item;

public class ItemDropFunctions {
    public static final Random rand = new Random();
    public static final List<DropType> dropList = ItemDropFunctions.genDropList();
    public static final List<Item> COMMON_LOOT = ItemDropFunctions.generateCommonLoot();
    public static final List<Item> UNCOMMON_LOOT = ItemDropFunctions.generateUncommonLoot();
    public static final List<Item> RARE_LOOT = ItemDropFunctions.generateRareLoot();

    public static Item getRandomDrop() {
        DropType randomType = ItemDropFunctions.getRandomDropType();
        Item drop = ItemDropFunctions.getDropFromType(randomType);
        return drop;
    }

    private static DropType getRandomDropType() {
        return dropList.get(rand.nextInt(dropList.size()));
    }

    private static Item getDropFromType(DropType type) {
        switch (type.ordinal()) {
            case 0: {
                return ItemDropFunctions.getDropFromList(COMMON_LOOT);
            }
            case 1: {
                return ItemDropFunctions.getDropFromList(UNCOMMON_LOOT);
            }
            case 2: {
                return ItemDropFunctions.getDropFromList(RARE_LOOT);
            }
        }
        return ItemDropFunctions.getDropFromList(COMMON_LOOT);
    }

    private static Item getDropFromList(List<Item> list) {
        return list.get(rand.nextInt(list.size()));
    }

    private static List<Item> generateCommonLoot() {
        ArrayList<Item> res = new ArrayList<Item>();
        res.add(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.NATURE);
        res.add(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.FOOD);
        res.add(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.NATURE);
        res.add(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.FOOD);
        res.add(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.NATURE);
        res.add(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.CORRUPTION);
        return res;
    }

    private static List<Item> generateUncommonLoot() {
        ArrayList<Item> res = new ArrayList<Item>();
        res.add(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.FOOD);
        res.add(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.METAL);
        res.add(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.CORRUPTION);
        res.add(QdcApi.QDC_CORE.ITEMS.QUANTUM_CORE);
        res.add(QdcApi.QDC_CORE.ITEMS.QUANTUM_TRANSMITTER);
        res.add(QdcApi.QDC_CORE.ITEMS.QUANTUM_RECIEVER);
        return res;
    }

    private static List<Item> generateRareLoot() {
        ArrayList<Item> res = new ArrayList<Item>();
        res.add(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.GEM);
        res.add(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.MANA);
        res.add(QdcApi.QDC_CORE.ITEMS.PARTICLE_ITEM.CORRUPTION);
        res.add(QdcApi.QDC_CORE.ITEMS.QUANTUM_COMPACT_CORE);
        res.add(QdcApi.QDC_CORE.ITEMS.QUANTUM_COMPACT_TRANSMITTER);
        res.add(QdcApi.QDC_CORE.ITEMS.QUANTUM_COMPACT_RECIEVER);
        res.add(QdcApi.QDC_CORE.ITEMS.QUANTUM_KNOWLEDGE);
        return res;
    }

    private static List<DropType> genDropList() {
        ArrayList<DropType> res = new ArrayList<DropType>();
        ItemDropFunctions.addDropsToList(DropType.COMMON, 100, res);
        ItemDropFunctions.addDropsToList(DropType.UNCOMMON, 80, res);
        ItemDropFunctions.addDropsToList(DropType.COMMON, 100, res);
        ItemDropFunctions.addDropsToList(DropType.RARE, 25, res);
        ItemDropFunctions.addDropsToList(DropType.COMMON, 100, res);
        return res;
    }

    private static void addDropsToList(DropType type, int count, List<DropType> res) {
        for (int i = 0; i < count; ++i) {
            res.add(type);
        }
    }

    public static enum DropType {
        COMMON,
        UNCOMMON,
        RARE;

    }
}

