/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.global;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class GlobalFuncs {
    public static Boolean showConsoleMessages = true;

    public static int getItemID(Item item) {
        return Item.getId((Item)item);
    }

    public static Item getItemFromID(String id) {
        int intID = Integer.parseInt(id);
        return GlobalFuncs.getItemFromID(intID);
    }

    public static Item getItemFromID(int id) {
        return Item.byId((int)id);
    }

    public static void displayParticleData() {
        GlobalFuncs.line();
        GlobalFuncs.msg("Nature - " + MainBox.PARTICLE_BOX.getParticleAmountString(ENUMS.ParticleType.NATURE));
        GlobalFuncs.msg("Food - " + MainBox.PARTICLE_BOX.getParticleAmountString(ENUMS.ParticleType.FOOD));
        GlobalFuncs.msg("Metal - " + MainBox.PARTICLE_BOX.getParticleAmountString(ENUMS.ParticleType.METAL));
        GlobalFuncs.msg("Gem - " + MainBox.PARTICLE_BOX.getParticleAmountString(ENUMS.ParticleType.GEM));
        GlobalFuncs.msg("Corruption - " + MainBox.PARTICLE_BOX.getParticleAmountString(ENUMS.ParticleType.CORRUPTION));
        GlobalFuncs.msg("Mana - " + MainBox.PARTICLE_BOX.getParticleAmountString(ENUMS.ParticleType.MANA));
        GlobalFuncs.msg("Mana Max - " + MainBox.PARTICLE_BOX.getParticleAmountString(ENUMS.ParticleType.MANA_MAX));
        GlobalFuncs.line();
    }

    public static String fixString(BigDecimal amount) {
        int comp = amount.compareTo(new BigDecimal("1000000"));
        if (comp > -1) {
            return GlobalFuncs.fixBigDecimal(amount.divide(new BigDecimal("1000000"))) + "M";
        }
        comp = amount.compareTo(new BigDecimal("10000"));
        if (comp > -1) {
            return GlobalFuncs.fixBigDecimal(amount.divide(new BigDecimal("1000"))) + "K";
        }
        return GlobalFuncs.fixBigDecimal(amount);
    }

    private static String fixBigDecimal(BigDecimal bd) {
        bd = bd.setScale(2, 1);
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(0);
        df.setGroupingUsed(false);
        return df.format(bd);
    }

    public static String formatNumber(BigDecimal val, int numOfDecimal) {
        BigDecimal bd = val.setScale(2, 1);
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(numOfDecimal);
        df.setMinimumFractionDigits(0);
        df.setGroupingUsed(true);
        return df.format(bd);
    }

    public static ParticleCollection removeManaFromParticleCollection(ParticleCollection pc) {
        if (pc == null) {
            return pc;
        }
        ParticleCollection res = new ParticleCollection();
        for (ParticleItem pi : pc.particleList) {
            if (pi.type == ENUMS.ParticleType.MANA || pi.type == ENUMS.ParticleType.MANA_MAX) continue;
            res.add(pi);
        }
        return res;
    }

    public static String prepareBigDecimalForSave(BigDecimal val) {
        BigDecimal bd = val.setScale(2, 1);
        DecimalFormat df = new DecimalFormat();
        df.setMaximumFractionDigits(2);
        df.setMinimumFractionDigits(0);
        df.setGroupingUsed(false);
        return df.format(bd);
    }

    public static String getItemNameShort(Item item, int len) {
        String name = GlobalFuncs.getItemName(item);
        if (len > name.length() - 1) {
            return name;
        }
        return name.substring(0, len) + "..";
    }

    public static String getItemName(Item item) {
        return item.getName(new ItemStack((ItemLike)item)).getString();
    }

    public static String fixDouble(double d) {
        String str = "" + GlobalFuncs.round(d, 2);
        if (str.endsWith(".0")) {
            return str.replace(".0", "");
        }
        return str;
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static void showInGameMessage(String msg) {
        Qdc.curPlayer.displayClientMessage((Component)Component.literal((String)msg), false);
    }

    public static BigDecimal addParticles(BigDecimal cur, double toAdd) {
        return cur.add(new BigDecimal(toAdd));
    }

    public static void msg(String str) {
        if (showConsoleMessages.booleanValue()) {
            System.out.println(str);
        }
    }

    public static void msg(int num) {
        if (showConsoleMessages.booleanValue()) {
            System.out.println(num);
        }
    }

    public static void msg(float num) {
        if (showConsoleMessages.booleanValue()) {
            System.out.println(num);
        }
    }

    public static void msg(BigDecimal bd) {
        if (showConsoleMessages.booleanValue()) {
            System.out.println(bd);
        }
    }

    public static void msg(ParticleCollection particles) {
        if (showConsoleMessages.booleanValue()) {
            GlobalFuncs.line();
            for (ParticleItem item : particles.particleList) {
                System.out.println(String.valueOf((Object)item.type) + " " + item.amount);
            }
            GlobalFuncs.line();
        }
    }

    public static void line() {
        if (showConsoleMessages.booleanValue()) {
            System.out.println("----------------------------------");
        }
    }

    public static boolean isSameBlock(Block a, Block b) {
        return a.getName().equals((Object)b.getName());
    }
}

