/*
 * Decompiled with CFR 0.152.
 */
package com.qdc_mod.qdc_core_4.qdc_core.functions;

import com.qdc_mod.qdc_core_4.Qdc;
import com.qdc_mod.qdc_core_4.api.ENUMS;
import com.qdc_mod.qdc_core_4.api.QdcApi;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.MainBox;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleCollection;
import com.qdc_mod.qdc_core_4.qdc_core.boxes.particle_box.classes.ParticleItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.classes.assembler.AssemblerItem;
import com.qdc_mod.qdc_core_4.qdc_core.common.gui.settings.AssemblerSettings;
import com.qdc_mod.qdc_core_4.qdc_core.network.packets.myData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class AssemblerFunctions {
    public static final List<Integer> INVENTORY_ACTUAL_INDEX_LIST = AssemblerSettings.INVENTORY.INVENTORY_ACTUAL_INDEX_LIST;

    public static List<ItemStack> getPlayerInventoryItems(Player player) {
        ArrayList<ItemStack> res = new ArrayList<ItemStack>();
        for (int i : INVENTORY_ACTUAL_INDEX_LIST) {
            res.add(player.getInventory().getItem(i));
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean handleItemAssembleClick(AssemblerItem item, boolean createStack) {
        if (!createStack) {
            int canCreate = AssemblerFunctions.checkCanCreate(item.item, 1, item.particles, item.storage);
            if (canCreate != 1) return false;
            int slotWithItem = Qdc.curPlayer.getInventory().getSlotWithRemainingSpace(new ItemStack((ItemLike)item.item));
            if (slotWithItem > -1) {
                int max;
                int oldCount = Qdc.curPlayer.getInventory().getItem(slotWithItem).getCount();
                int newCount = oldCount + 1;
                if (newCount > (max = Qdc.curPlayer.getInventory().getItem(slotWithItem).getMaxStackSize())) return false;
                if (item.storage > 0) {
                    AssemblerFunctions.assembleItems(item.item, item.particles, true, slotWithItem, 1);
                    return true;
                } else {
                    AssemblerFunctions.assembleItems(item.item, item.particles, false, slotWithItem, 1);
                }
                return true;
            } else {
                int freeSlot = Qdc.curPlayer.getInventory().getFreeSlot();
                if (freeSlot <= -1) return false;
                if (item.storage > 0) {
                    AssemblerFunctions.assembleItems(item.item, item.particles, true, freeSlot, 1);
                    return true;
                } else {
                    AssemblerFunctions.assembleItems(item.item, item.particles, false, freeSlot, 1);
                }
            }
            return true;
        } else {
            int maxStack = new ItemStack((ItemLike)item.item).getMaxStackSize();
            int slotWithItem = Qdc.curPlayer.getInventory().getSlotWithRemainingSpace(new ItemStack((ItemLike)item.item));
            if (slotWithItem > -1) {
                int remInSlot = maxStack - Qdc.curPlayer.getInventory().getItem(slotWithItem).getCount();
                if (item.storage > 0) {
                    if (item.storage >= remInSlot) {
                        int canCreate = AssemblerFunctions.checkCanCreate(item.item, remInSlot, item.particles, item.storage);
                        if (canCreate == 0) {
                            return false;
                        }
                        AssemblerFunctions.assembleItems(item.item, item.particles, true, slotWithItem, canCreate);
                        return true;
                    } else {
                        int canCreateFromStorage = item.storage;
                        int canCreate = AssemblerFunctions.checkCanCreate(item.item, canCreateFromStorage, item.particles, item.storage);
                        if (canCreate == 0) {
                            return false;
                        }
                        AssemblerFunctions.assembleItems(item.item, item.particles, true, slotWithItem, canCreate);
                    }
                    return true;
                } else {
                    int canCreate = AssemblerFunctions.checkCanCreate(item.item, remInSlot, item.particles, item.storage);
                    if (canCreate == 0) {
                        return false;
                    }
                    AssemblerFunctions.assembleItems(item.item, item.particles, false, slotWithItem, canCreate);
                }
                return true;
            } else {
                int freeSlot = Qdc.curPlayer.getInventory().getFreeSlot();
                if (freeSlot <= -1) return false;
                int remInSlot = maxStack;
                if (item.storage > 0) {
                    if (item.storage >= remInSlot) {
                        int canCreate = AssemblerFunctions.checkCanCreate(item.item, remInSlot, item.particles, item.storage);
                        if (canCreate == 0) {
                            return false;
                        }
                        AssemblerFunctions.assembleItems(item.item, item.particles, true, freeSlot, canCreate);
                        return true;
                    } else {
                        int canCreateFromStorage = item.storage;
                        int canCreate = AssemblerFunctions.checkCanCreate(item.item, canCreateFromStorage, item.particles, item.storage);
                        if (canCreate == 0) {
                            return false;
                        }
                        AssemblerFunctions.assembleItems(item.item, item.particles, true, freeSlot, canCreate);
                    }
                    return true;
                } else {
                    int canCreate = AssemblerFunctions.checkCanCreate(item.item, remInSlot, item.particles, item.storage);
                    if (canCreate == 0) {
                        return false;
                    }
                    AssemblerFunctions.assembleItems(item.item, item.particles, false, freeSlot, canCreate);
                }
            }
        }
        return true;
    }

    private static boolean assembleItems(Item item, ParticleCollection particles, boolean ignoreMana, int slotIndex, int itemAmount) {
        if (slotIndex == -1) {
            return false;
        }
        int newCount = -1;
        ParticleCollection toRemove = new ParticleCollection();
        toRemove.addOtherParticleCollection(particles, ignoreMana);
        toRemove = toRemove.multiply(itemAmount);
        if (QdcApi.QDC_CORE.FUNCTIONS.canRemoveParticles(toRemove)) {
            if (Qdc.curPlayer.getInventory().getItem(slotIndex).isEmpty()) {
                Qdc.curPlayer.getInventory().setItem(slotIndex, new ItemStack((ItemLike)item, itemAmount));
                newCount = itemAmount;
            } else {
                int max;
                int oldCount = Qdc.curPlayer.getInventory().getItem(slotIndex).getCount();
                newCount = oldCount + itemAmount;
                if (newCount <= (max = Qdc.curPlayer.getInventory().getItem(slotIndex).getMaxStackSize())) {
                    Qdc.curPlayer.getInventory().setItem(slotIndex, new ItemStack((ItemLike)item, newCount));
                } else {
                    return false;
                }
            }
            if (ignoreMana) {
                int storage = QdcApi.QDC_CORE.FUNCTIONS.getItemStorageCount(item);
                if (storage >= itemAmount) {
                    QdcApi.QDC_CORE.FUNCTIONS.removeFromStorage(item, itemAmount);
                } else {
                    return false;
                }
            }
            QdcApi.QDC_CORE.FUNCTIONS.removeParticles(toRemove);
            int itemID = Item.getId((Item)item);
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new myData.MyData(slotIndex, itemID, newCount), (CustomPacketPayload[])new CustomPacketPayload[0]);
            MainBox.saveData(Qdc.curPlayer);
        }
        return true;
    }

    private static int checkCanCreate(Item item, int amount, ParticleCollection particles, int storage) {
        int res = amount;
        int curCreateAmount = 0;
        for (ParticleItem pi : particles.particleList) {
            curCreateAmount = pi.type != ENUMS.ParticleType.MANA ? QdcApi.QDC_CORE.FUNCTIONS.getCanCreateCount(pi.type, pi.amount) : (storage > 0 ? storage : QdcApi.QDC_CORE.FUNCTIONS.getCanCreateCount(pi.type, pi.amount));
            if (curCreateAmount >= res) continue;
            res = curCreateAmount;
        }
        return res;
    }
}

